package com.biz.crm.common.sms.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.sms.sdk.service.ValiditySmsCodeService;
import com.bizunited.nebula.common.service.sms.SmsService;
import com.bizunited.nebula.common.service.sms.SmsTypeEnums;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 发送手机号验证码通用接口
 *
 * @author pengxi
 * @date 2022/05/10
 */
@Slf4j
@RestController
@RequestMapping("/v1/sms/sms")
@Api(tags = "发送手机号验证码通用接口")
public class SmsController {

  @Autowired(required = false)
  private SmsService smsService;

  @Autowired(required = false)
  private ValiditySmsCodeService validitySmsCodeService;

  @ApiOperation(value = "发送【登录】手机号验证码")
  @PostMapping("/sendLoginSmsCode")
  public Result<?> sendLoginSmsCode(
      @RequestParam(value = "phone") @ApiParam(name = "phone", required = true, value = "手机号") String phone,
      @RequestParam(value = "timeout") @ApiParam(name = "timeout", required = true, value = "有效期（单位毫秒，默认值300）") Integer timeout) {
    try {
      String verificationCode = this.validitySmsCodeService.generateVerificationCode();
      this.validitySmsCodeService.setVerificationCodeValidityPeriod(phone, verificationCode, timeout);
      String content = "{\"code\":\"" + verificationCode + "\"}";
      this.smsService.sendSms(phone,"SMS_136420112", content, SmsTypeEnums.INFO);
      return Result.ok("验证码发送成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "发送【找回密码】手机号验证码")
  @PostMapping("/sendRetrievePasswordSmsCode")
  public Result<?> sendRetrievePasswordSmsCode(
      @RequestParam(value = "phone") @ApiParam(name = "phone", required = true, value = "手机号") String phone,
      @RequestParam(value = "timeout") @ApiParam(name = "timeout", required = true, value = "有效期（单位毫秒，默认值300）") Integer timeout) {
    try {
      String verificationCode = this.validitySmsCodeService.generateVerificationCode();
      this.validitySmsCodeService.setVerificationCodeValidityPeriod(phone, verificationCode, timeout);
      String content = "{\"code\":\"" + verificationCode + "\"}";
      this.smsService.sendSms(phone,"SMS_136420109",content, SmsTypeEnums.INFO);
      return Result.ok("验证码发送成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
