package com.biz.crm.common.sms.local.service.internal;

import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.teaopenapi.models.Config;
import com.bizunited.nebula.common.service.sms.SmsServiceAdapter;
import com.bizunited.nebula.common.service.sms.SmsTypeEnums;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * 阿里云短信发送实现类
 *
 * @author pengxi
 * @date 2022-05-07
 */
@Slf4j
@Service
public class AliyunSmsServiceImpl extends SmsServiceAdapter {
  /**
   * sms:
   *   supplier: aliyun
   *   endpoint: dysmsapi.aliyuncs.com
   *   accessKeyId: LTAI7dZVm90xQWia
   *   accessKeySecret: PW8ni30AfEumIzauhE8XZl77WZ8FeR
   *   signName: 博智维讯
   */
  @Value("${sms.supplier:}")
  private String supplier;
  @Value("${sms.endpoint:}")
  private String endpoint;
  @Value("${sms.accessKeyId:}")
  private String accessKeyId;
  @Value("${sms.accessKeySecret:}")
  private String accessKeySecret;
  @Value("${sms.signName:}")
  private String signName;

  /**
   * 使用AK&SK初始化账号Client
   * @param accessKeyId
   * @param accessKeySecret
   * @param endpoint
   * @return Client
   * @throws Exception
   */
  public Client createClient(String accessKeyId, String accessKeySecret, String endpoint) throws Exception {
    Config config = new Config()
        // 您的AccessKey ID
        .setAccessKeyId(accessKeyId)
        // 您的AccessKey Secret
        .setAccessKeySecret(accessKeySecret)
        // 访问的域名
        .setEndpoint(endpoint);
    return new Client(config);
  }


  public void aliyunSendSms(SendSmsRequest sendSmsRequest) {
    try {
      Client client = createClient(accessKeyId, accessKeySecret, endpoint);
      SendSmsResponse resp = client.sendSms(sendSmsRequest);
      String success = "OK";
      Validate.isTrue(StringUtils.equals(resp.body.code, success), resp.body.message);
    } catch (Exception e) {
      log.error("短信发送异常：{}",e.getMessage(),e);
      Validate.isTrue(Boolean.FALSE, "短信发送异常：" + e.getMessage());
    }
  }

  /**
   * 标识当前实现类的短信供应商
   */
  private String currentSupplier() {
    return "aliyun";
  }

  /**
   * 默认短信登录模板
   * 注意：短信内容的参数已处理，调用方只需要传入code值
   */
  @Override
  public void sendSms(String phone, String content, SmsTypeEnums smsType) {
    this.sendSms(phone, "SMS_136420112", "{\"code\":\"" + content + "\"}", smsType);
  }

  @Override
  public void sendSms(String phone, String templateId, String content, SmsTypeEnums smsType) {
    if (!this.currentSupplier().equals(supplier)) {
      // 表示当前系统配置为非阿里云短信供应商
      return;
    }

    Validate.notNull(phone, "手机号不能为空！");
    Validate.notNull(content, "短信内容不能为空！");
    Validate.notNull(smsType, "短信类型不能为空！");

    SendSmsRequest sendSmsRequest = new SendSmsRequest();
    sendSmsRequest.setSignName(signName);
    sendSmsRequest.setPhoneNumbers(phone);
    sendSmsRequest.setTemplateCode(templateId);
    //sendSmsRequest.setTemplateParam("{\"code\":\"" + verificationCode + "\"}");
    sendSmsRequest.setTemplateParam(content);
    this.aliyunSendSms(sendSmsRequest);
  }
}