package com.biz.crm.common.sms.local.service.internal;

import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.sms.sdk.constant.SmsConstant;
import com.biz.crm.common.sms.sdk.service.ValiditySmsCodeService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 短信验证码有效期管理服务实现
 *
 * @author pengxi
 */
@Service
public class ValiditySmsCodeServiceImpl implements ValiditySmsCodeService {

  @Autowired
  private RedisService redisService;

  @Override
  public void setVerificationCodeValidityPeriod(String phone, String verificationCode) {
    this.setVerificationCodeValidityPeriod(phone, verificationCode, 300L);
  }

  @Override
  public void setVerificationCodeValidityPeriod(String phone, String verificationCode, long timeout) {
    Validate.notNull(phone, "手机号不能为空！");
    Validate.notNull(verificationCode, "短信验证码不能为空！");
    Validate.notNull(timeout, "有效期（单位毫秒）不能为空！");
    Validate.isTrue(timeout > 0 , "错误的有效期（单位毫秒）, 请检查!!");
    // 根据短信模板+手机号获取60s有效期的redis信息，用于控制频繁发送短信
    this.redisService.hSet(
        StringUtils.join(SmsConstant.SMS_VERIFICATION_CODE, phone, ":", verificationCode),
        StringUtils.join(phone, verificationCode),
        verificationCode,
        // 有效期5分钟
        timeout);
  }

  @Override
  public Boolean isAvailableVerificationCode(String phone, String verificationCode) {
    Validate.notNull(phone, "手机号不能为空！");
    Validate.notNull(verificationCode, "短信验证码不能为空！");
    // 根据短信模板+手机号获取60s有效期的redis信息，用于控制频繁发送短信
    Object obj = this.redisService.hGet(
        StringUtils.join(SmsConstant.SMS_VERIFICATION_CODE, phone, ":", verificationCode),
        StringUtils.join(phone, verificationCode));
    if (obj != null) {
      return Boolean.TRUE;
    }
    return Boolean.FALSE;
  }
}
