/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.sms.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.sms.sdk.service.ValiditySmsCodeService;
import com.bizunited.nebula.common.service.sms.SmsService;
import com.bizunited.nebula.common.service.sms.SmsTypeEnums;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/sms/sms"})
@Api(tags={"\u53d1\u9001\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u901a\u7528\u63a5\u53e3"})
public class SmsController {
    private static final Logger log = LoggerFactory.getLogger(SmsController.class);
    @Autowired(required=false)
    private SmsService smsService;
    @Autowired(required=false)
    private ValiditySmsCodeService validitySmsCodeService;

    @ApiOperation(value="\u53d1\u9001\u3010\u767b\u5f55\u3011\u624b\u673a\u53f7\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/sendLoginSmsCode"})
    public Result<?> sendLoginSmsCode(@RequestParam(value="phone") @ApiParam(name="phone", required=true, value="\u624b\u673a\u53f7") String phone, @RequestParam(value="timeout") @ApiParam(name="timeout", required=true, value="\u6709\u6548\u671f\uff08\u5355\u4f4d\u6beb\u79d2\uff0c\u9ed8\u8ba4\u503c300\uff09") Integer timeout) {
        try {
            String verificationCode = this.validitySmsCodeService.generateVerificationCode();
            this.validitySmsCodeService.setVerificationCodeValidityPeriod(phone, verificationCode, (long)timeout.intValue());
            String content = "{\"code\":\"" + verificationCode + "\"}";
            this.smsService.sendSms(phone, "SMS_136420112", content, SmsTypeEnums.INFO);
            return Result.ok((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d1\u9001\u3010\u627e\u56de\u5bc6\u7801\u3011\u624b\u673a\u53f7\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/sendRetrievePasswordSmsCode"})
    public Result<?> sendRetrievePasswordSmsCode(@RequestParam(value="phone") @ApiParam(name="phone", required=true, value="\u624b\u673a\u53f7") String phone, @RequestParam(value="timeout") @ApiParam(name="timeout", required=true, value="\u6709\u6548\u671f\uff08\u5355\u4f4d\u6beb\u79d2\uff0c\u9ed8\u8ba4\u503c300\uff09") Integer timeout) {
        try {
            String verificationCode = this.validitySmsCodeService.generateVerificationCode();
            this.validitySmsCodeService.setVerificationCodeValidityPeriod(phone, verificationCode, (long)timeout.intValue());
            String content = "{\"code\":\"" + verificationCode + "\"}";
            this.smsService.sendSms(phone, "SMS_136420109", content, SmsTypeEnums.INFO);
            return Result.ok((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

