/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.sms.local.service.internal;

import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.teaopenapi.models.Config;
import com.biz.crm.common.sms.local.config.AliyunSmsConfiguration;
import com.bizunited.nebula.common.service.sms.SmsServiceAdapter;
import com.bizunited.nebula.common.service.sms.SmsTypeEnums;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="sms", name={"supplier"}, havingValue="aliyun")
public class AliyunSmsServiceImpl
extends SmsServiceAdapter {
    private static final Logger log = LoggerFactory.getLogger(AliyunSmsServiceImpl.class);
    private Client client;
    @Autowired
    private AliyunSmsConfiguration aliyunSmsConfiguration;

    @PostConstruct
    public void initClient() throws Exception {
        Config config = new Config().setAccessKeyId(this.aliyunSmsConfiguration.getAccessKeyId()).setAccessKeySecret(this.aliyunSmsConfiguration.getAccessKeySecret()).setEndpoint(this.aliyunSmsConfiguration.getEndpoint());
        this.client = new Client(config);
    }

    public void aliyunSendSms(SendSmsRequest sendSmsRequest) {
        try {
            SendSmsResponse resp = this.client.sendSms(sendSmsRequest);
            String success = "OK";
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)resp.body.code, (CharSequence)success), (String)resp.body.message, (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error("\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            Validate.isTrue((boolean)Boolean.FALSE, (String)("\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff1a" + e.getMessage()), (Object[])new Object[0]);
        }
    }

    public void sendSms(String phone, String content, SmsTypeEnums smsType) {
        this.sendSms(phone, "SMS_136420112", "{\"code\":\"" + content + "\"}", smsType);
    }

    public void sendSms(String phone, String templateId, String content, SmsTypeEnums smsType) {
        Validate.notNull((Object)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)content, (String)"\u77ed\u4fe1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)smsType, (String)"\u77ed\u4fe1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SendSmsRequest sendSmsRequest = new SendSmsRequest();
        sendSmsRequest.setSignName(this.aliyunSmsConfiguration.getSignName());
        sendSmsRequest.setPhoneNumbers(phone);
        sendSmsRequest.setTemplateCode(templateId);
        sendSmsRequest.setTemplateParam(content);
        this.aliyunSendSms(sendSmsRequest);
    }
}

