/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.sms.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.sms.local.config.TencentSmsConfiguration;
import com.bizunited.nebula.common.service.sms.SmsServiceAdapter;
import com.bizunited.nebula.common.service.sms.SmsTypeEnums;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.sms.v20190711.SmsClient;
import com.tencentcloudapi.sms.v20190711.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20190711.models.SendSmsResponse;
import com.tencentcloudapi.sms.v20190711.models.SendStatus;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="sms", name={"supplier"}, havingValue="tencent")
public class TencentSmsServiceImpl
extends SmsServiceAdapter {
    private static final Logger log = LoggerFactory.getLogger(TencentSmsServiceImpl.class);
    private SmsClient smsClient;
    @Autowired
    private TencentSmsConfiguration tencentSmsConfiguration;

    @PostConstruct
    public void initClient() {
        Credential cred = new Credential(this.tencentSmsConfiguration.getAccessKeyId(), this.tencentSmsConfiguration.getAccessKeySecret());
        ClientProfile clientProfile = new ClientProfile();
        clientProfile.setSignMethod("TC3-HMAC-SHA256");
        this.smsClient = new SmsClient(cred, this.tencentSmsConfiguration.getRegion());
    }

    public void aliyunSendSms(SendSmsRequest sendSmsRequest) {
        try {
            SendSmsResponse resp = this.smsClient.SendSms(sendSmsRequest);
            Validate.isTrue((Objects.nonNull(resp) && resp.getSendStatusSet() != null && resp.getSendStatusSet().length > 0 && Objects.nonNull(resp.getSendStatusSet()[0]) ? 1 : 0) != 0, (String)"\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38", (Object[])new Object[0]);
            SendStatus sendStatus = resp.getSendStatusSet()[0];
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)sendStatus.getCode(), (CharSequence)"Ok"), (String)sendStatus.getMessage(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error("\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            Validate.isTrue((boolean)Boolean.FALSE, (String)("\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff1a" + e.getMessage()), (Object[])new Object[0]);
        }
    }

    public void sendSms(String phone, String templateId, String content, SmsTypeEnums smsType) {
        Validate.notNull((Object)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)content, (String)"\u77ed\u4fe1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)smsType, (String)"\u77ed\u4fe1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SendSmsRequest sendSmsRequest = new SendSmsRequest();
        sendSmsRequest.setSmsSdkAppid(this.tencentSmsConfiguration.getAppId());
        String[] phones = new String[]{phone};
        sendSmsRequest.setPhoneNumberSet(phones);
        sendSmsRequest.setTemplateID(templateId);
        String[] templateParam = JSONArray.parseArray((String)content, String.class).toArray(new String[0]);
        sendSmsRequest.setTemplateParamSet(templateParam);
        sendSmsRequest.setSign(this.tencentSmsConfiguration.getSignName());
        this.aliyunSendSms(sendSmsRequest);
    }
}

