package com.biz.crm.common.sms.sdk.service;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * 短信验证码有效期管理服务接口
 *
 * @author pengxi
 */
public interface ValiditySmsCodeService {

  /**
   * 生成随机数字验证码
   *
   * @return String
   */
  default String generateVerificationCode() {
    //验证码长度
    int length = 6;
    double random = Math.random();
    return String.format("%0" + length + "d", new BigDecimal(random).multiply(BigDecimal.valueOf(Math.pow(10, length))).setScale(0, RoundingMode.HALF_UP).longValue());
  }

  /**
   * 设置验证码有效期（默认300毫秒）
   *
   * @param phone 手机号
   * @param verificationCode 验证码
   */
  @Deprecated
  void setVerificationCodeValidityPeriod(String phone, String verificationCode);

  /**
   * 设置验证码有效期
   *
   * @param phone 手机号
   * @param verificationCode 验证码
   * @param timeout 有效期，单位毫秒
   */
  void setVerificationCodeValidityPeriod(String phone, String verificationCode, long timeout);

  /**
   * 验证码是否有效
   *
   * @param phone 手机号
   * @param verificationCode 验证码
   * @return Boolean
   */
  Boolean isAvailableVerificationCode(String phone, String verificationCode);
}