package com.biz.crm.taxpay.core.cipher;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.taxpay.Constants;
import com.biz.crm.taxpay.uitil.DigestUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import static java.util.Objects.requireNonNull;

public  class TaxPaySigner implements Signer {

    private final String cashAppid;
    private final String cashSecret;

    /**
     *  构造函数
     * @param cashAppid 税筹平台分配的appid
     * @param cashSecret 税筹平台分配的Secret
     */
    public TaxPaySigner(String cashAppid, String cashSecret) {
        this.cashAppid = requireNonNull(cashAppid);
        this.cashSecret = requireNonNull(cashSecret);
    }

    @Override
    public String callBackSign(JSONObject jsonObject, long timestamp) {
        requireNonNull(jsonObject);
        jsonObject.put(Constants.TAX_KEY_APPID,cashAppid);
        jsonObject.put(Constants.TAX_KEY_SECRET,cashSecret);
        jsonObject.put(Constants.TAX_KEY_DATETIME,timestamp);
        return DigestUtils.md5DigestAsHex(JSON.toJSONString(jsonObject).getBytes());
    }

    private String sign(JSONObject jsonObject, long timestamp) {
        requireNonNull(jsonObject);
        JSONObject body = new JSONObject();
        body.put(Constants.TAX_KEY_DATA, jsonObject);
        body.put(Constants.TAX_KEY_APPID,cashAppid);
        body.put(Constants.TAX_KEY_SECRET,cashSecret);
        body.put(Constants.TAX_KEY_DATETIME,timestamp);
        //使用MD5加密
        return DigestUtils.md5DigestAsHex(JSON.toJSONString(body).getBytes());
    }

    @Override
    public Map<String, String> createHeadMap(JSONObject jsonObject) {
        Map<String, String> map=new HashMap<>(3);
        long timestamp=new Date().getTime();
        map.put(Constants.TAX_KEY_APPID,cashAppid);
        map.put(Constants.TAX_KEY_TIMESTAMP,String.valueOf(timestamp));
        map.put(Constants.TAX_KEY_SIGN,sign(jsonObject,timestamp));
        return map;
    }
}
