package com.biz.crm.taxpay.exception;

import cn.hutool.http.HttpStatus;
import com.alibaba.fastjson2.JSONObject;
import com.biz.crm.taxpay.model.TaxBaseResponse;

/***
 * 业务异常
 */
public class ServiceException extends RuntimeException{

    private final int httpStatusCode;
    private final String responseBody;
    private Integer errorCode;
    private String errorMessage;

    /**
     * 业务状态码为为200调用
     * @param httpStatusCode http状态码
     * @param responseBody http返回体
     */
    public ServiceException(int httpStatusCode, String responseBody) {
        super(
                String.format(
                        "业务出错:[%d]%nhttpResponseBody[%.1024s]%n",
                        httpStatusCode, responseBody));
        this.httpStatusCode = httpStatusCode;
        this.responseBody = responseBody;
        if (responseBody != null && !responseBody.isEmpty()) {
            TaxBaseResponse taxBaseResponse = JSONObject.parseObject(responseBody, TaxBaseResponse.class);
            this.errorCode = taxBaseResponse.getCode();
            this.errorMessage = taxBaseResponse.getMessage();
        }
    }

    public ServiceException(String message) {
        super(message);
        this.httpStatusCode = HttpStatus.HTTP_OK;
        this.responseBody = null;
        this.errorCode = HttpStatus.HTTP_INTERNAL_ERROR;
        this.errorMessage = message;
    }

    public int getHttpStatusCode() {
        return httpStatusCode;
    }

    public String getResponseBody() {
        return responseBody;
    }

    public Integer getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
