package com.biz.crm.taxpay.model;

/**
 * 税筹提现结果返回
 */
public class TaxBaseResponse<T> {
    /**
     *  接口请求成功标示 必填
     *  说明：true - 请求成功 false - 请求失败
     */
    private Boolean success;

    /***
     * 接口返回信息描述
     */
    private String message;

    /***
     * 接口返回信息编码
     * 说明：200 - 业务处理成功 其他值 - 业务处理失败，失败原因详见message字段描述
     * 如：
     *    500 系统内部错误 注意状态码是500时(提现接口需要使用原单号cashRecordNo重试、否则可能会造成重复提现)
     *    10001 门店未同步不存在
     *    10002 门店未注册
     *    10003 门店未认证
     *    10004 门店未签约
     *    10005 提现cashRecordNo单号重复、已存在，说明当前cashRecordNo对应的提现记录已生成
     *    10006 请求参数缺失或错误异常
     *    10007 签名验证异常
     */
    private Integer code;

    /**
     * 接口请求时间戳
     */
    private Long timestamp;

    /***
     * 业务数据
     */
    private T result;

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public T getResult() {
        return result;
    }

    public void setResult(T result) {
        this.result = result;
    }
}
