package com.biz.crm.taxpay.model;

import java.math.BigDecimal;
import java.util.List;

/**
 * 税筹提现请求对象
 */
public class TaxCashRequest {
    /**
     *  提现总金额(单位：分) 必填
     *  说明：单位：分
     */
    private BigDecimal amount;

    /***
     * 提现单号 必填
     * 说明：提现单号，唯一标识一笔提现记录，由商户生成，每次提现请求的提现单号不能重复
     */
    private String cashRecordNo;

    /***
     * 提现到账通知回调地址 选填
     * 说明：提现到账通知回调地址，提现成功后，会向该地址发送提现结果通知。 若不填，则不进行回调
     */
    private String notifyUrl;

    /**
     * 提现者编码 必填
     * 说明：一般传终端编码
     */
    private String terminalCode;

    private List<TaxCashDetailRequest> details;

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getCashRecordNo() {
        return cashRecordNo;
    }

    public void setCashRecordNo(String cashRecordNo) {
        this.cashRecordNo = cashRecordNo;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getTerminalCode() {
        return terminalCode;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }

    public List<TaxCashDetailRequest> getDetails() {
        return details;
    }

    public void setDetails(List<TaxCashDetailRequest> details) {
        this.details = details;
    }
}
