package com.biz.crm.taxpay.service;

import com.biz.crm.taxpay.model.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/***
 * 税筹平台服务接口
 */
public interface TaxRaiseService {


    /**
     * 税筹提现操作
     * @param request 提现请求参数
     * @return  提现结果
     */
    TaxBaseResponse taxCash(TaxCashRequest request);


    /***
     * 验证提现者的认证信息
     * @param terminalCode
     * @return
     */
    TaxBaseResponse<TaxSignResponse> verifySign(String terminalCode);


    /**
     * 根据提现编码查询提现信息
     * @param cashRecordNo 提现编码
     * @return
     */
    TaxBaseResponse<TaxCashResultResponse> findCashResultByNo(String cashRecordNo);


    /**
     * 根据提现者编码清除对应的认证信息
     * @param terminalCode
     * @return
     */
    TaxBaseResponse cleanSign(String terminalCode);


    /**
     * 税筹提现打款状态数据回调数据解析
     * 说明：验签成功，返回提现记录明细信息 验签失败，抛出ServiceException异常
     * @param request 提现请求参数
     * @return  提现结果
     */
    TaxCashResultResponse cashCallBack(HttpServletRequest request);

    /***
     * 门店认证状态回调数据解析
     * 说明：验签成功，返回门店认证结果 验签失败，抛出ServiceException异常
     * @param request 请求数据
     * @return 门店认证结果
     */
    TaxSignCallBackResponse signCallBack(HttpServletRequest request);


    /***
     * 税筹对账接口
     * @param startDate 开始时间
     * @param endDate  结束时间
     * @return
     */
    TaxBaseResponse<List<TaxCashStatAccountResponse>> statCashAccount(String startDate,String endDate);
}
