package com.biz.crm.taxpay.core.cipher;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.taxpay.exception.HttpRequestException;
import com.biz.crm.taxpay.exception.ServiceException;
import com.biz.crm.taxpay.model.TaxBaseResponse;

public  class TaxPayValidator implements Validator {


    @Override
    public TaxBaseResponse validate(int httpStatusCode, String httpResponse) {
        if(httpStatusCode<200||httpStatusCode>=300){
            throw new HttpRequestException(httpStatusCode,httpResponse);
        }
        TaxBaseResponse baseResponse = JSONObject.parseObject(httpResponse, TaxBaseResponse.class);
        if(!baseResponse.getSuccess() ||
                baseResponse.getCode()==null ||
                baseResponse.getCode().intValue()!=200){
            throw new ServiceException(httpStatusCode,httpResponse);
        }
        return baseResponse;
    }
}
