package com.biz.crm.taxpay.model;

import java.math.BigDecimal;

/**
 * 税筹提现明细请求对象
 */
public class TaxCashDetailRequest {
    /**
     *  提现总金额(单位：分) 必填
     *  说明：单位：分
     */
    private BigDecimal amount;

    /***
     *  红包池编码 必填
     * 说明：由税筹平台分配的红包池编码
     */
    private String poolAccountCode;

    public TaxCashDetailRequest(BigDecimal amount, String poolAccountCode) {
        this.amount = amount;
        this.poolAccountCode = poolAccountCode;
    }
    public TaxCashDetailRequest() {
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getPoolAccountCode() {
        return poolAccountCode;
    }

    public void setPoolAccountCode(String poolAccountCode) {
        this.poolAccountCode = poolAccountCode;
    }
}
