/*
 * Decompiled with CFR 0.152.
 */
package com.fadada.sdk.utils.crypt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import sun.misc.BASE64Encoder;

public class FddEncryptTool {
    private static final byte[] DECODE_TABLE;
    private static final byte[] ENCODE_TABLE;
    private static final String[] hexDigits;
    private static char[] hexChar;
    private static final String CRYPT_ALGORITHM = "DESede";

    private FddEncryptTool() {
    }

    public static byte[] Base64Encode(byte[] data) {
        if (data == null) {
            return null;
        }
        int fullGroups = data.length / 3;
        int resultBytes = fullGroups * 4;
        if (data.length % 3 != 0) {
            resultBytes += 4;
        }
        byte[] result = new byte[resultBytes];
        int resultIndex = 0;
        int dataIndex = 0;
        int temp = 0;
        for (int i = 0; i < fullGroups; ++i) {
            temp = (data[dataIndex++] & 0xFF) << 16 | (data[dataIndex++] & 0xFF) << 8 | data[dataIndex++] & 0xFF;
            result[resultIndex++] = ENCODE_TABLE[temp >> 18 & 0x3F];
            result[resultIndex++] = ENCODE_TABLE[temp >> 12 & 0x3F];
            result[resultIndex++] = ENCODE_TABLE[temp >> 6 & 0x3F];
            result[resultIndex++] = ENCODE_TABLE[temp & 0x3F];
        }
        temp = 0;
        while (dataIndex < data.length) {
            temp <<= 8;
            temp |= data[dataIndex++] & 0xFF;
        }
        switch (data.length % 3) {
            case 1: {
                temp <<= 8;
                result[resultIndex++] = ENCODE_TABLE[(temp <<= 8) >> 18 & 0x3F];
                result[resultIndex++] = ENCODE_TABLE[temp >> 12 & 0x3F];
                result[resultIndex++] = 61;
                result[resultIndex++] = 61;
                break;
            }
            case 2: {
                result[resultIndex++] = ENCODE_TABLE[(temp <<= 8) >> 18 & 0x3F];
                result[resultIndex++] = ENCODE_TABLE[temp >> 12 & 0x3F];
                result[resultIndex++] = ENCODE_TABLE[temp >> 6 & 0x3F];
                result[resultIndex++] = 61;
                break;
            }
        }
        return result;
    }

    public static byte[] Base64Decode(byte[] base64Data) {
        if (base64Data == null) {
            return null;
        }
        if (base64Data.length == 0) {
            return new byte[0];
        }
        if (base64Data.length % 4 != 0) {
            throw new IllegalArgumentException("\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u957f\u5ea6\u4e3a\uff1a " + base64Data.length);
        }
        byte[] result = null;
        int groupCount = base64Data.length / 4;
        int lastData = base64Data.length;
        while (base64Data[lastData - 1] == 61) {
            if (--lastData != 0) continue;
            return new byte[0];
        }
        result = new byte[lastData - groupCount];
        int temp = 0;
        int resultIndex = 0;
        int dataIndex = 0;
        while (dataIndex + 4 < base64Data.length) {
            temp = DECODE_TABLE[base64Data[dataIndex++]];
            temp = (temp << 6) + DECODE_TABLE[base64Data[dataIndex++]];
            temp = (temp << 6) + DECODE_TABLE[base64Data[dataIndex++]];
            temp = (temp << 6) + DECODE_TABLE[base64Data[dataIndex++]];
            result[resultIndex++] = (byte)(temp >> 16 & 0xFF);
            result[resultIndex++] = (byte)(temp >> 8 & 0xFF);
            result[resultIndex++] = (byte)(temp & 0xFF);
        }
        temp = 0;
        int j = 0;
        while (dataIndex < base64Data.length) {
            temp = (temp << 6) + DECODE_TABLE[base64Data[dataIndex]];
            ++dataIndex;
            ++j;
        }
        while (j < 4) {
            temp <<= 6;
            ++j;
        }
        result[resultIndex++] = (byte)(temp >> 16 & 0xFF);
        if (base64Data[dataIndex - 2] != 61) {
            result[resultIndex++] = (byte)(temp >> 8 & 0xFF);
        }
        if (base64Data[dataIndex - 1] != 61) {
            result[resultIndex++] = (byte)(temp & 0xFF);
        }
        return result;
    }

    public static String getimgBase64(File file) {
        String imgBase64 = "";
        Base64 base64 = new Base64();
        try {
            FileInputStream io = new FileInputStream(file);
            byte[] bytes = new byte[(int)file.length()];
            io.read(bytes);
            imgBase64 = new String(base64.encode(bytes));
            io.close();
        }
        catch (FileNotFoundException io) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imgBase64;
    }

    public static String ImageToBase64ByOnline(String imgURL) {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            URL url = new URL(imgURL);
            byte[] by = new byte[1024];
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            InputStream is = conn.getInputStream();
            int len = -1;
            while ((len = is.read(by)) != -1) {
                data.write(by, 0, len);
            }
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BASE64Encoder encoder = new BASE64Encoder();
        String endimgbase64 = encoder.encode(data.toByteArray()).replaceAll("\r|\n", "");
        return endimgbase64;
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(FddEncryptTool.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    public static byte[] md5Digest(byte[] src) throws Exception {
        MessageDigest alg = MessageDigest.getInstance("MD5");
        return alg.digest(src);
    }

    public static String md5Digest(String src) throws Exception {
        return FddEncryptTool.byteArrayToHexString(FddEncryptTool.md5Digest(src.getBytes("UTF-8")));
    }

    public static String sha1(String inStr) {
        String outStr = null;
        try {
            outStr = FddEncryptTool.digest(inStr.getBytes("UTF-8"), "SHA-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outStr;
    }

    public static String sha256(String inStr) {
        String outStr = null;
        try {
            outStr = FddEncryptTool.digest(inStr.getBytes("UTF-8"), "SHA-256");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sha256(File file) {
        FileInputStream fis = null;
        String outputStr = "";
        try {
            fis = new FileInputStream(file);
            byte[] b = new byte[1024];
            MessageDigest alg = MessageDigest.getInstance("SHA-256");
            int numRead = 0;
            while ((numRead = fis.read(b)) > 0) {
                alg.update(b, 0, numRead);
            }
            byte[] digest = alg.digest();
            outputStr = FddEncryptTool.byte2hexLower(digest);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            String string = outputStr;
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            String string = outputStr;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = outputStr;
            return string;
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outputStr;
    }

    public static String byte2hexLower(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int i = 0; i < b.length; ++i) {
            stmp = Integer.toHexString(b[i] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs;
    }

    public static String digest(byte[] inputBytes, String algorithm) {
        String outputStr = null;
        try {
            MessageDigest alg = MessageDigest.getInstance(algorithm);
            alg.update(inputBytes);
            byte[] digest = alg.digest();
            outputStr = FddEncryptTool.byte2hex(digest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return outputStr;
    }

    public static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int i = 0; i < b.length; ++i) {
            stmp = Integer.toHexString(b[i] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs.toUpperCase();
    }

    public static String getFileSHA256(String filename) {
        String str = "";
        try {
            str = FddEncryptTool.getHash(filename, "SHA-256");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    private static String getHash(String fileName, String hashType) throws Exception {
        FileInputStream fis = new FileInputStream(fileName);
        byte[] buffer = new byte[1024];
        MessageDigest md5 = MessageDigest.getInstance(hashType);
        int numRead = 0;
        while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
            md5.update(buffer, 0, numRead);
        }
        ((InputStream)fis).close();
        return FddEncryptTool.toHexString(md5.digest());
    }

    private static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }

    public static String encrypt(String value, String key) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), CRYPT_ALGORITHM);
            Cipher cipher = Cipher.getInstance(CRYPT_ALGORITHM);
            cipher.init(1, keySpec);
            byte[] encryptedByte = cipher.doFinal(value.getBytes("UTF-8"));
            String encodedByte = FddEncryptTool.byte2hex(encryptedByte);
            return encodedByte;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decrypt(String value, String key) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), CRYPT_ALGORITHM);
            Cipher cipher = Cipher.getInstance(CRYPT_ALGORITHM);
            cipher.init(2, keySpec);
            byte[] decryptedByte = cipher.doFinal(FddEncryptTool.hex2byte(value));
            return new String(decryptedByte, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] hex2byte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        if (hex.startsWith("0x")) {
            hex = hex.substring(2);
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        int l = hex.length();
        while (i < l) {
            String swap = "" + arr[i++] + arr[i];
            int byteint = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = new Integer(byteint).byteValue();
            ++i;
            ++j;
        }
        return b;
    }

    static {
        int c;
        DECODE_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};
        ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        int index = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            FddEncryptTool.ENCODE_TABLE[index++] = (byte)c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            FddEncryptTool.ENCODE_TABLE[index++] = (byte)c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            FddEncryptTool.ENCODE_TABLE[index++] = (byte)c;
        }
        FddEncryptTool.ENCODE_TABLE[index++] = 43;
        FddEncryptTool.ENCODE_TABLE[index++] = 47;
        for (int i = 0; i < 64; ++i) {
            FddEncryptTool.DECODE_TABLE[FddEncryptTool.ENCODE_TABLE[i]] = (byte)i;
        }
        hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

