package com.biz.crm.tpm.business.activities.profit.monitoring.local.controller;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activities.profit.monitoring.local.entity.ProfitMonitoring;
import com.biz.crm.tpm.business.activities.profit.monitoring.sdk.dto.ProfitMonitoringDto;
import com.biz.crm.tpm.business.activities.profit.monitoring.sdk.service.ProfitMonitoringService;
import com.biz.crm.tpm.business.activities.profit.monitoring.sdk.vo.ProfitMonitoringVo;
import io.swagger.annotations.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.math.BigDecimal;

/**
 * (ProfitMonitoring)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-08 12:05:57
 */

@RestController
@RequestMapping("/v1/profitMonitoring/profitMonitoring")
@Slf4j
@Api(tags = "TPM-活动监控中利润监控（分子公司）")
public class ProfitMonitoringController {

    /**
     * 服务对象 利润监控（分子公司）
     */
    @Autowired
    private ProfitMonitoringService profitMonitoringService;

    /**
     * 分页查询所有数据
     *
     * @param pageable            分页对象
     * @param profitMonitoringDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "利润监控（分子公司）分页查询所有数据")
    @GetMapping("/findByConditions")
    public Result<Page<ProfitMonitoringVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "dimensionBudget", value = "预算管理配置表") ProfitMonitoringDto profitMonitoringDto) {
        try {
            Page<ProfitMonitoringVo> page = this.profitMonitoringService.findByConditions(pageable, profitMonitoringDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建利润监控（分子公司）维护信息
     * @param dto 利润监控json
     * @return 执行利润监控vo
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<ProfitMonitoringVo> create(@RequestBody ProfitMonitoringDto dto) {
        try {
            ProfitMonitoringVo current = this.profitMonitoringService.create(dto);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


}
