package com.biz.crm.tpm.business.activities.profit.monitoring.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.activities.profit.monitoring.local.entity.ProfitMonitoring;
import com.biz.crm.tpm.business.activities.profit.monitoring.local.mapper.ProfitMonitoringMapper;
import com.biz.crm.tpm.business.activities.profit.monitoring.sdk.dto.ProfitMonitoringDto;
import com.biz.crm.tpm.business.activities.profit.monitoring.sdk.vo.ProfitMonitoringVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/11/8 16:57
 * @description: 利润监控（分子公司)
 */
@Component
@Slf4j
public class ProfitMonitoringRepository extends ServiceImpl<ProfitMonitoringMapper, ProfitMonitoring> {


    @Autowired
    ProfitMonitoringMapper profitMonitoringMapper;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto)     查询实体
     * @return 所有数据
     */
    public Page<ProfitMonitoringVo> findByConditions(Pageable pageable, ProfitMonitoringDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of(1, 50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<ProfitMonitoringVo> page = new Page<ProfitMonitoringVo>(pageable.getPageNumber(), pageable.getPageSize());
        return profitMonitoringMapper.findByConditions(page, dto);
    }
}
