package com.biz.crm.tpm.business.activities.profit.monitoring.local.service.imports;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgPaginationDto;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.activities.profit.monitoring.local.constant.ProfitMonitoringConstant;
import com.biz.crm.tpm.business.activities.profit.monitoring.local.entity.ProfitMonitoring;
import com.biz.crm.tpm.business.activities.profit.monitoring.local.repository.ProfitMonitoringRepository;
import com.biz.crm.tpm.business.activities.profit.monitoring.sdk.dto.ProfitMonitoringDto;
import com.biz.crm.tpm.business.activities.profit.monitoring.sdk.service.ProfitMonitoringService;
import com.biz.crm.tpm.business.activities.profit.monitoring.sdk.vo.ProfitMonitoringVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.datasource.repository.AppDataSourceRepository;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;

/**
 * (ProfitMonitoringServiceImpl)表服务实现类
 *
 * @author makejava
 * @since 2022-11-03 17:06:02
 */
@Slf4j
@Service("profitMonitoringService")
public class ProfitMonitoringServiceImpl implements ProfitMonitoringService {

    @Autowired
    private ProfitMonitoringRepository profitMonitoringRepository;

    @Resource
    private SalesOrgVoService salesOrgVoService;


    @Autowired
    private NebulaToolkitService nebulaToolkitService;


    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @Override
    public Page<ProfitMonitoringVo> findByConditions(Pageable pageable, ProfitMonitoringDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of(1, 50);
        }
        if (dto == null) {
            dto = new ProfitMonitoringDto();
        }

        /**获取租户编号*/
        if (StringUtils.isBlank(dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }

        /**获取删除标志*/
        if (StringUtils.isBlank(dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if (StringUtils.isBlank(dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }

        return this.profitMonitoringRepository.findByConditions(pageable, dto);
    }

    /**
     * 创建利润监控（分子公司）维护信息
     *
     * @param dto 执行资料json
     * @return 执行资料文件vo
     */
    @Override
    public ProfitMonitoringVo create(ProfitMonitoringDto dto) {
        Date now = new Date();
        //更新时间
        dto.setModifyTime(now);
        //费用所属年月
        dto.setFeeYearMonthTime(now);
        dto.setBusinessUnitCode(ProfitMonitoringConstant.BUSINESS_UNIT_CODE);
        dto.setBusinessFormatCode(ProfitMonitoringConstant.BUSINESS_FORMAT_CODE);
        dto.setBusinessUnitCode(ProfitMonitoringConstant.BUSINESS_FORMAT_CODE);
        //实际理论收入
        dto.setActualTheoryIncome(ProfitMonitoringConstant.ACTUAL_THEORY_PROFIT_RATE);
        //实际理论成本
        dto.setActualTheoryPrice(ProfitMonitoringConstant.ACTUAL_THEORY_PRICE);
        BigDecimal subtract = ProfitMonitoringConstant.ACTUAL_THEORY_PROFIT_RATE.subtract(ProfitMonitoringConstant.ACTUAL_THEORY_PRICE);
        //实际理论毛利
        dto.setActualTheoryGrossProfit(subtract);

        //查询销售组织
        List<SalesOrgVo> allSalesOrgLevelBySalesOrg = salesOrgVoService.findAllSalesOrgLevelBySalesOrg(ProfitMonitoringConstant.SALES_ORG_LEVEL_CONSTANT,"");
        if (CollectionUtils.isEmpty(allSalesOrgLevelBySalesOrg)) {
            throw new RuntimeException("新增利润监控数据时，未查询到销售组织！");
        }

        List<ProfitMonitoring> saveList = new ArrayList<>(allSalesOrgLevelBySalesOrg.size());
        //有多少销售组织就新建多少条利润监控数据
        for (SalesOrgVo appDataSourceRepository : allSalesOrgLevelBySalesOrg) {
            dto.setOrgCode(appDataSourceRepository.getSalesOrgCode());
            dto.setOrgName(appDataSourceRepository.getSalesOrgName());
            ProfitMonitoring profitMonitoring = this.nebulaToolkitService.copyObjectByWhiteList(dto,
                    ProfitMonitoring.class,
                    HashSet.class,
                    ArrayList.class);
            saveList.add(profitMonitoring);
        }

        //保存
        this.saveOrUpdate(saveList);
        return null;
        
    }

    @Transactional(rollbackFor = Exception.class)
    public void saveOrUpdate(List<ProfitMonitoring> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.profitMonitoringRepository.saveOrUpdateBatch(list);
    }
}
