/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.profit.monitoring.local.service.imports;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.activities.profit.monitoring.local.constant.ProfitMonitoringConstant;
import com.biz.crm.tpm.business.activities.profit.monitoring.local.entity.ProfitMonitoring;
import com.biz.crm.tpm.business.activities.profit.monitoring.local.repository.ProfitMonitoringRepository;
import com.biz.crm.tpm.business.activities.profit.monitoring.sdk.dto.ProfitMonitoringDto;
import com.biz.crm.tpm.business.activities.profit.monitoring.sdk.service.ProfitMonitoringService;
import com.biz.crm.tpm.business.activities.profit.monitoring.sdk.vo.ProfitMonitoringVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="profitMonitoringService")
public class ProfitMonitoringServiceImpl
implements ProfitMonitoringService {
    private static final Logger log = LoggerFactory.getLogger(ProfitMonitoringServiceImpl.class);
    @Autowired
    private ProfitMonitoringRepository profitMonitoringRepository;
    @Resource
    private SalesOrgVoService salesOrgVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public Page<ProfitMonitoringVo> findByConditions(Pageable pageable, ProfitMonitoringDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)50);
        }
        if (dto == null) {
            dto = new ProfitMonitoringDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return this.profitMonitoringRepository.findByConditions(pageable, dto);
    }

    public ProfitMonitoringVo create(ProfitMonitoringDto dto) {
        Date now = new Date();
        dto.setModifyTime(now);
        dto.setFeeYearMonthTime(now);
        dto.setBusinessUnitCode("\u5206\u5b50\u516c\u53f8");
        dto.setBusinessFormatCode("\u5e38\u6e29");
        dto.setBusinessUnitCode("\u5e38\u6e29");
        dto.setActualTheoryIncome(ProfitMonitoringConstant.ACTUAL_THEORY_PROFIT_RATE);
        dto.setActualTheoryPrice(ProfitMonitoringConstant.ACTUAL_THEORY_PRICE);
        BigDecimal subtract = ProfitMonitoringConstant.ACTUAL_THEORY_PROFIT_RATE.subtract(ProfitMonitoringConstant.ACTUAL_THEORY_PRICE);
        dto.setActualTheoryGrossProfit(subtract);
        List allSalesOrgLevelBySalesOrg = this.salesOrgVoService.findAllSalesOrgLevelBySalesOrg("mechanism", "");
        if (CollectionUtils.isEmpty((Collection)allSalesOrgLevelBySalesOrg)) {
            throw new RuntimeException("\u65b0\u589e\u5229\u6da6\u76d1\u63a7\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9500\u552e\u7ec4\u7ec7\uff01");
        }
        ArrayList<ProfitMonitoring> saveList = new ArrayList<ProfitMonitoring>(allSalesOrgLevelBySalesOrg.size());
        for (SalesOrgVo appDataSourceRepository : allSalesOrgLevelBySalesOrg) {
            dto.setOrgCode(appDataSourceRepository.getSalesOrgCode());
            dto.setOrgName(appDataSourceRepository.getSalesOrgName());
            ProfitMonitoring profitMonitoring = (ProfitMonitoring)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ProfitMonitoring.class, HashSet.class, ArrayList.class, new String[0]));
            saveList.add(profitMonitoring);
        }
        this.saveOrUpdate(saveList);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(List<ProfitMonitoring> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.profitMonitoringRepository.saveOrUpdateBatch(list);
    }
}

