package com.biz.crm.tpm.business.activities.profit.monitoring.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activities.profit.monitoring.sdk.dto.ProfitMonitoringDto;
import com.biz.crm.tpm.business.activities.profit.monitoring.sdk.vo.ProfitMonitoringVo;
import org.springframework.data.domain.Pageable;

/**
 * 服务对象 利润监控（分子公司）
 * @author makejava
 * @since 2022-12-03 17:14:14
 */
public interface ProfitMonitoringService {


    /**
     * 分页查询所有数据
     *
     * @param pageable            分页对象
     * @param profitMonitoringDto 查询实体
     * @return 所有数据
     */
    Page<ProfitMonitoringVo> findByConditions(Pageable pageable, ProfitMonitoringDto profitMonitoringDto);

    /**
     * 创建利润监控（分子公司）维护信息
     * @param dto 利润监控json
     * @return 执行利润监控vo
     */
    ProfitMonitoringVo create(ProfitMonitoringDto dto);
}
