package com.biz.crm.tpm.business.activity.plan.table.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.plan.table.feign.feign.impl.ActivityPlanTableFeignImpl;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.ActivityPlanTableDto;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/1 20:51
 * @description：活动规划套表
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = ActivityPlanTableFeignImpl.class)
public interface ActivityPlanTableFeign {

    @ApiOperation("创建")
    @PostMapping("/v1/activityPlanTable/save")
    Result<?> save(@RequestBody ActivityPlanTableDto dto);
}
