package com.biz.crm.tpm.business.activity.plan.table.local.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.service.ActivityPlanTableService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.constant.SubComActivityDesignConstant;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.SubComActivityDesignModifyPassMqTagEnum;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

/**
 * @author qiancheng
 * @date 2023/3/18
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = SubComActivityDesignConstant.TPM_SUB_COM_ACTIVITY_DESIGN_MODIFY_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = SubComActivityDesignConstant.TPM_SUB_COM_ACTIVITY_DESIGN_SAVE_DATA_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = SubComActivityDesignConstant.TPM_SUB_COM_ACTIVITY_DESIGN_SAVE_DATA_TAG + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class SubComActivityDesignSaveDataConsumer extends AbstractRocketMqConsumer {

    @Autowired
    private ActivityPlanTableService activityPlanTableService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info(SubComActivityDesignConstant.TPM_SUB_COM_ACTIVITY_DESIGN_SAVE_DATA_TAG+" order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }

        try {
            List<String> processNoList = JSONArray.parseArray(message.getMsgBody(), String.class);
            if (CollectionUtil.isEmpty(processNoList)) {
                return "消息为空!";
            }
            //更新原数据
            processNoList.forEach(processNo -> {
                activityPlanTableService.saveSubmitTimeData(processNo);
            });
        }catch (Exception e){
            log.error(SubComActivityDesignModifyPassMqTagEnum.PASS_UPDATE_PLAN.getName()+"处理失败"+e.getMessage(),e);
            return "消费失败."+e.getMessage();
        }

        return "消费成功.";
    }

}
