package com.biz.crm.tpm.business.activity.plan.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/5 11:38
 * @description：活动规划套表
 */
@ApiModel(value = "ActivityPlanTable", description = "活动规划套表")
@TableName("tpm_activity_plan_table")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_table")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_table", comment = "活动规划套表")
@Table(name = "tpm_activity_plan_table", indexes = {@Index(name = "activity_plan_table_code_index", unique = true, columnList = "activity_plan_table_code")})
public class ActivityPlanTable extends TenantFlagOpEntity {

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    @Column(name = "year_and_month",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '年月'")
    private String yearAndMonth;

    /**
     * 活动规划套表编码
     */
    @ApiModelProperty("活动规划套表编码")
    @Column(name = "activity_plan_table_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动规划套表编码")
    private String activityPlanTableCode;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码 '")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '组织名称 '")
    private String orgName;

    /**
     * 审批状态
     */
    @ApiModelProperty(value = "审批状态", notes = "审批状态")
    @Column(name = "process_status",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '审批状态'")
    private String processStatus;

    @ApiModelProperty(value = "审批流程编码", notes = "审批流程编码")
    @Column(name = "process_no",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '审批流程编码'")
    private String processNo;

    @ApiModelProperty(value = "数据生成状态", notes = "数据生成状态")
    @Column(name = "generate_status",  length = 8, columnDefinition = "VARCHAR(8) COMMENT '数据生成状态'")
    private String generateStatus;

    @ApiModelProperty(value = "", notes = "活动规划套表版本[activity_plan_table_version]")
    @Column(name = "table_version",  length = 1, columnDefinition = "VARCHAR(1) COMMENT '活动规划套表版本[activity_plan_table_version]'")
    private String tableVersion;
}
