package com.biz.crm.tpm.business.activity.plan.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.vo.FixedExpenseVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SpecialCostVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName ActivityPlanProfitEntity
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/13
 */
@ApiModel(value = "ActivityPlanProfitEntity", description = "活动规划套表-利润测算保存表")
@TableName("tpm_activity_plan_table_activity_plan_profit")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_table_activity_plan_profit")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_table_activity_plan_profit", comment = "活动规划套表-利润测算保存表")
@Table(name = "tpm_activity_plan_table_activity_plan_profit", indexes = {
        @Index(name = "table_code_index", columnList = "activity_plan_table_code"),
})
public class ActivityPlanTableActivityPlanProfitEntity extends TenantFlagOpEntity {

    /**
     * 活动规划套表编码
     */
    @ApiModelProperty("活动规划套表编码")
    @Column(name = "activity_plan_table_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动规划套表编码'")
    private String activityPlanTableCode;

    @ApiModelProperty("是否合计")
    @Column(name = "is_total", nullable = true, length = 20, columnDefinition = "VARCHAR(20) COMMENT '是否合计'")
    private Boolean isTotal;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(name = "客户渠道编码", notes = "")
    @Column(name = "customer_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道编码'")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(name = "客户渠道名称", notes = "")
    @Column(name = "customer_channel_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '客户渠道名称'")
    private String customerChannelName;

    @ApiModelProperty("出库件数")
    @Column(name = "out_storage_quantity", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '出库件数'")
    private BigDecimal outStorageQuantity;

    @ApiModelProperty("折前收入")
    @Column(name = "before_discount_income", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '折前收入'")
    private BigDecimal beforeDiscountIncome;

    @ApiModelProperty("折前成本")
    @Column(name = "before_discount_cost", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '折前成本'")
    private BigDecimal beforeDiscountCost;

    @ApiModelProperty("折后收入")
    @Column(name = "after_discount_income", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '折后收入'")
    private BigDecimal afterDiscountIncome;

    @ApiModelProperty("销量占比")
    @Column(name = "sale_quantity_ratio", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '销量占比'")
    private BigDecimal saleQuantityRatio;

    @ApiModelProperty("理论毛利额")
    @Column(name = "theory_gross_margin_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '理论毛利额'")
    private BigDecimal theoryGrossMarginAmount;

    @ApiModelProperty("理论毛利率")
    @Column(name = "theory_gross_margin_rate", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '理论毛利率'")
    private BigDecimal theoryGrossMarginRate;

    @ApiModelProperty("税金及附加")
    @Column(name = "tax_and_addition", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '税金及附加'")
    private BigDecimal taxAndAddition;

    @ApiModelProperty("点内费用")
    @Column(name = "point_in_cost", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '点内费用'")
    private BigDecimal pointInCost;

    @ApiModelProperty("点外费用")
    @Column(name = "point_out_cost", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '点外费用'")
    private BigDecimal pointOutCost;

    @ApiModelProperty("点数内费率")
    @Column(name = "point_in_cost_ratio", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '点数内费率'")
    private BigDecimal pointInCostRatio;

    @ApiModelProperty("点数外费率")
    @Column(name = "point_out_cost_ratio", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '点数外费率'")
    private BigDecimal pointOutCostRatio;

    @ApiModelProperty("总部考核")
    @Column(name = "headquarters_assess", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '总部考核'")
    private BigDecimal headquartersAssess;

    @ApiModelProperty("总部支出小计")
    @Column(name = "headquarters_expense_total", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '总部支出小计'")
    private BigDecimal headquartersExpenseTotal;

    @ApiModelProperty("利润额")
    @Column(name = "profit_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '利润额'")
    private BigDecimal profitAmount;

    @ApiModelProperty("产品促销费用率")
    @Column(name = "product_promotion_cost", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '产品促销费用率'")
    private BigDecimal productPromotionCost;

    @ApiModelProperty("其它费用率")
    @Column(name = "other_cost_ratio", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '其它费用率'")
    private BigDecimal otherCostRatio;

    @ApiModelProperty("专项费用率")
    @Column(name = "special_cost_rate", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '专项费用率'")
    private BigDecimal specialCostRate;

    @ApiModelProperty("固定支出费用率")
    @Column(name = "point_in_expend_cost_rate", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '固定支出费用率'")
    private BigDecimal pointInExpendCostRate;

    @ApiModelProperty("整体费用率")
    @Column(name = "all_cost_rate", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '整体费用率'")
    private BigDecimal allCostRate;

//    @ApiModelProperty("固定费用率")
//    private BigDecimal pointInCostRate;
//
//    @ApiModelProperty("后台费用率")
//    private BigDecimal backgroundCostRate;


    @ApiModelProperty("用于计算产品促销费用率，分子")
    @Column(name = "product_promotion_cost_numerator", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '用于计算产品促销费用率，分子'")
    private BigDecimal productPromotionCostNumerator;

    @ApiModelProperty("用于计算固定费用率，分子")
    @Column(name = "point_in_cost_rate_numerator", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '用于计算固定费用率，分子'")
    private BigDecimal pointInCostRateNumerator;

}
