package com.biz.crm.tpm.business.activity.plan.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName CostCollectEntity
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/9
 */
@ApiModel(value = "CostCollectEntity", description = "活动规划套表-费用汇总保存表")
@TableName("tpm_activity_plan_table_cost_collect")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_table_cost_collect")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_table_cost_collect", comment = "活动规划套表-费用汇总保存表")
@Table(name = "tpm_activity_plan_table_cost_collect", indexes = {@Index(name = "table_code_index", columnList = "activity_plan_table_code")})
public class ActivityPlanTableCostCollectEntity extends TenantFlagOpEntity {

    /**
     * 活动规划套表编码
     */
    @ApiModelProperty("活动规划套表编码")
    @Column(name = "activity_plan_table_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动规划套表编码'")
    private String activityPlanTableCode;

    /**
     * 活动规划编码
     */
    @ApiModelProperty(name = "活动规划编码", notes = "")
    @Column(name = "activity_design_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动规划编码'")
    private String activityDesignCode;

    /**
     * 活动规划名称
     */
    @ApiModelProperty(name = "活动规划名称", notes = "")
    @Column(name = "activity_design_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动规划名称'")
    private String activityDesignName;

    /**
     * 活动规划明细编码
     */
    @ApiModelProperty(name = "活动规划明细编码", notes = "")
    @Column(name = "activity_design_detail_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动规划明细编码'")
    private String activityDesignDetailCode;

    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动类型编码'")
    private String activityTypeCode;

    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", nullable = true, length = 255, columnDefinition = "VARCHAR(32) COMMENT '活动类型名称'")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty("核销方式")
    @Column(name = "audit_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销方式'")
    private String auditType;

    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_begin_time", nullable = true, columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginTime;

    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_end_time", nullable = true, columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndTime;

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "fee_year_month", nullable = true, columnDefinition = "datetime COMMENT '费用所属年月'")
    private Date feeYearMonth;

    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String productBrandCode;

    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '品牌名称'")
    private String productBrandName;

    @ApiModelProperty("品类编码")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码'")
    private String productCategoryCode;

    @ApiModelProperty("品类名称")
    @Column(name = "product_category_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '品类名称'")
    private String productCategoryName;

    @ApiModelProperty("品项编码")
    @Column(name = "product_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品项编码'")
    private String productItemCode;

    @ApiModelProperty("品项名称")
    @Column(name = "product_item_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '品项名称'")
    private String productItemName;

    @ApiModelProperty(value = "产品编码", notes = "产品编码")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(value = "产品名称", notes = "产品名称")
    @Column(name = "product_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty(value = "保质期", notes = "保质期")
    @Column(name = "product_expiration_date", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '产品名称'")
    private Integer productExpirationDate;

    @ApiModelProperty("费用合计")
    @Column(name = "total_cost", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '费用合计'")
    private BigDecimal totalCost;

    @ApiModelProperty(value = "点外金额", notes = "")
    @Column(name = "off_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '点外金额'")
    private BigDecimal offAmount;

    @ApiModelProperty(value = "点内金额", notes = "")
    @Column(name = "internal_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '点内金额'")
    private BigDecimal internalAmount;

    @ApiModelProperty(value = "自投金额", notes = "")
    @Column(name = "auto_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '自投金额'")
    private BigDecimal autoAmount;

    @ApiModelProperty("核销条件")
    @Column(name = "audit_condition", nullable = true, length = 60, columnDefinition = "VARCHAR(60) COMMENT '核销条件'")
    private String auditCondition;

}
