package com.biz.crm.tpm.business.activity.plan.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @ClassName FinalFixedExpenseEntity
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/9
 */
@ApiModel(value = "FinalFixedExpenseEntity", description = "活动规划套表-固定支出保存表")
@TableName("tpm_activity_plan_table_final_fixed_expense")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_table_final_fixed_expense")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_table_final_fixed_expense", comment = "活动规划套表-固定支出保存表")
@Table(name = "tpm_activity_plan_table_final_fixed_expense", indexes = {@Index(name = "table_code_index", columnList = "activity_plan_table_code")})
public class ActivityPlanTableFinalFixedExpenseEntity extends TenantFlagOpEntity {

    /**
     * 活动规划套表编码
     */
    @ApiModelProperty("活动规划套表编码")
    @Column(name = "activity_plan_table_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动规划套表编码'")
    private String activityPlanTableCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    @Column(name = "year_month_ly",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '年月'")
    private String yearMonthLy;
    /**
     * 类型
     */
    @ApiModelProperty(value = "类型", notes = "")
    @Column(name = "type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '类型'")
    private String typeCode;
    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码'")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '组织名称'")
    private String orgName;
    /**
     * 部门编码
     */
    @ApiModelProperty(value = "部门编码", notes = "")
    @Column(name = "department_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织名称'")
    private String departmentCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(value = "部门名称", notes = "")
    @Column(name = "department_name", nullable = true, length = 255, columnDefinition = "VARCHAR(32) COMMENT '部门名称'")
    private String departmentName;
    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码'")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '预算项目名称'")
    private String budgetItemName;

    /**
     * 预算金额
     */
    @ApiModelProperty(value = "预算金额", notes = "")
    @Column(name = "amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '预算金额'")
    private BigDecimal amount;

}
