package com.biz.crm.tpm.business.activity.plan.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @ClassName FixedExpenseEntity
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/13
 */
@ApiModel(value = "FixedExpenseEntity", description = "活动规划套表-固定支出保存表")
@TableName("tpm_activity_plan_table_fixed_expense")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_table_fixed_expense")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_table_fixed_expense", comment = "活动规划套表-固定支出保存表")
@Table(name = "tpm_activity_plan_table_fixed_expense", indexes = {@Index(name = "profit_id_index", columnList = "profit_id")})
public class ActivityPlanTableFixedExpenseEntity extends TenantFlagOpEntity {

    @ApiModelProperty("利润测算id")
    @Column(name = "profit_id", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '利润测算id'")
    private String profitId;

    @ApiModelProperty("是否合计")
    @Column(name = "is_total", nullable = true, length = 1, columnDefinition = "INT(1) COMMENT '是否合计'")
    private Boolean isTotal;

    @ApiModelProperty("预算类别编码")
    @Column(name = "budget_sort_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算类别编码'")
    private String budgetSortCode;

    @ApiModelProperty("预算类别名称")
    @Column(name = "budget_sort_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '预算类别名称'")
    private String budgetSortName;

    @ApiModelProperty("固定支出")
    @Column(name = "fixed_expense", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '固定支出'")
    private BigDecimal fixedExpense;


    /**
     * 类型[数据字典:tpm_budget_amount_type]
     */
    @ApiModelProperty(value = "类型", notes = "")
    @Column(name = "type_code", nullable = true, length = 60, columnDefinition = "VARCHAR(60) COMMENT '类型[tpm_budget_amount_type]'")
    private String typeCode;



    /**
     * 客户渠道编码
     */
    @ApiModelProperty(name = "客户渠道编码", notes = "")
    @Column(name = "customer_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道编码'")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(name = "客户渠道名称", notes = "")
    @Column(name = "customer_channel_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '客户渠道名称'")
    private String customerChannelName;

}
