package com.biz.crm.tpm.business.activity.plan.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName ActivityPlanTablePriceEntity
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/14
 */
@ApiModel(value = "ActivityPlanTablePriceEntity", description = "活动规划套表-价格保存表")
@TableName("tpm_activity_plan_table_price")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_table_price")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_table_price", comment = "活动规划套表-价格保存表")
@Table(name = "tpm_activity_plan_table_price", indexes = {@Index(name = "table_code_index", columnList = "activity_plan_table_code")})
public class ActivityPlanTablePriceEntity extends TenantFlagOpEntity {

    /**
     * 活动规划套表编码
     */
    @ApiModelProperty("活动规划套表编码")
    @Column(name = "activity_plan_table_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动规划套表编码'")
    private String activityPlanTableCode;

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "fee_year_month", nullable = true, length = 20, columnDefinition = "VARCHAR(20) COMMENT '费用所属年月'")
    private Date feeYearMonth;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码'")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '组织名称'")
    private String orgName;
    /**
     * 活动规划编码
     */
    @ApiModelProperty(value = "活动规划编码", notes = "")
    @Column(name = "activity_design_code", nullable = true, length = 32, columnDefinition = "VARCHAR(512) COMMENT '活动规划编码'")
    private String activityDesignCode;

    /**
     * 活动规划名称
     */
    @ApiModelProperty(value = "活动规划名称", notes = "")
    @Column(name = "activity_design_name", nullable = true, length = 255, columnDefinition = "VARCHAR(2000) COMMENT '活动规划名称'")
    private String activityDesignName;

    /**
     * 活动规划明细编码
     */
    @ApiModelProperty(value = "活动规划明细编码", notes = "")
    @Column(name = "activity_design_detail_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动规划明细编码'")
    private String activityDesignDetailCode;

    @ApiModelProperty("分销渠道")
    @Column(name = "distribution_channel_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分销渠道'")
    private String distributionChannelName;

    @ApiModelProperty("分销渠道编码")
    @Column(name = "distribution_channel_code", nullable = true, length = 255, columnDefinition = "VARCHAR(32) COMMENT '分销渠道编码'")
    private String distributionChannelCode;

    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty("产品日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "product_date", length = 20, columnDefinition = "datetime COMMENT '产品日期'")
    private Date productDate;

    @ApiModelProperty("是否大日期")
    @Column(name = "is_big_date", columnDefinition = "varchar(32) COMMENT '是否大日期'")
    private String isBigDate;

    /**
     * 到岸价
     */
    @ApiModelProperty(value = "到岸价", notes = "")
    @Column(name = "cif_price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '到岸价 '")
    private BigDecimal cifPrice;

    @ApiModelProperty("活动价（元）")
    @Column(name = "activity_price", columnDefinition = "decimal(24,6) COMMENT '活动价（元）'")
    private BigDecimal activityPrice;

    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_institution_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String salesInstitutionCode;

    @ApiModelProperty("销售机构名称")
    @Column(name = "sales_institution_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '客户名称'")
    private String salesInstitutionName;

    @ApiModelProperty(value = "分摊产品编码", notes = "分摊产品编码")
    @Column(name = "apportion_product_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分摊产品编码'")
    private String apportionProductCode;

    @ApiModelProperty(value = "分摊产品名称", notes = "分摊产品名称")
    @Column(name = "apportion_product_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '分摊产品名称'")
    private String apportionProductName;

    @ApiModelProperty("促销量（件）")
    @Column(name = "promote_sales", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '促销量（件）'")
    private BigDecimal promoteSales;
    /**
     * 标准供货价
     */
    @ApiModelProperty(value = "标准供货价", notes = "")
    @Column(name = "standard_supply_price", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '标准供货价'")
    private BigDecimal standardSupplyPrice;

    @ApiModelProperty("活动后单价")
    @Column(name = "activity_after_unit_price", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '活动后单价'")
    private BigDecimal activityAfterUnitPrice;

    @ApiModelProperty("使用优惠明细")
    @Column(name = "use_discounts_detail", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '使用优惠明细'")
    private String useDiscountsDetail;

    @ApiModelProperty("活动费用")
    @Column(name = "activity_cost", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '活动费用'")
    private BigDecimal activityCost;

    @ApiModelProperty("点内费用")
    @Column(name = "internal_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '点内费用'")
    private BigDecimal internalAmount;

    @ApiModelProperty("点外费用")
    @Column(name = "off_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '点外费用'")
    private BigDecimal offAmount;

    @ApiModelProperty("自投费用")
    @Column(name = "auto_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '自投费用'")
    private BigDecimal autoAmount;

    @ApiModelProperty("期间促销额（元）")
    @Column(name = "promotion_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '期间促销额（元）'")
    private BigDecimal promotionAmount;

    @ApiModelProperty("供货红线价")
    @Column(name = "supply_material_red_line_price", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '供货红线价'")
    private BigDecimal supplyMaterialRedLinePrice;

    @ApiModelProperty("是否低于红线价")
    @Column(name = "is_under_red_line_price", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否低于红线价'")
    private String isUnderRedLinePrice;

    @ApiModelProperty("活动最低价")
    @Column(name = "activity_lowest_price", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '活动最低价'")
    private BigDecimal activityLowestPrice;

    @ApiModelProperty("平均价格影响")
    @Column(name = "avg_price_effect", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '平均价格影响'")
    private BigDecimal avgPriceEffect;

    @ApiModelProperty("原零售价")
    @Column(name = "original_retail_price", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '平均价格影响'")
    private BigDecimal originalRetailPrice;

    @ApiModelProperty("活动零售价")
    @Column(name = "activity_retail_price", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '平均价格影响'")
    private BigDecimal activityRetailPrice;

    @ApiModelProperty("还原后价格")
    @Column(name = "restored_price", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '平均价格影响'")
    private BigDecimal restoredPrice;


}
