package com.biz.crm.tpm.business.activity.plan.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName PutOutputRatioEntity
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/9
 */
@ApiModel(value = "PutOutputRatioEntity", description = "活动规划套表-投产比审批数据保存表")
@TableName("tpm_activity_plan_table_put_output_ratio")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_table_put_output_ratio")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_table_put_output_ratio", comment = "活动规划套表-投产比审批数据保存表")
@Table(name = "tpm_activity_plan_table_put_output_ratio", indexes = {@Index(name = "table_code_index", columnList = "activity_plan_table_code")})
public class ActivityPlanTablePutOutputRatioEntity extends TenantFlagOpEntity {

    /**
     * 活动规划套表编码
     */
    @ApiModelProperty("活动规划套表编码")
    @Column(name = "activity_plan_table_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动规划套表编码'")
    private String activityPlanTableCode;


    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "fee_year_month", nullable = true, columnDefinition = "datetime COMMENT '费用所属年月'")
    private Date feeYearMonth;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码'")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '组织名称'")
    private String orgName;

    /**
     * 部门编码
     */
    @ApiModelProperty(value = "部门编码", notes = "")
    @Column(name = "department_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织名称'")
    private String departmentCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(value = "部门名称", notes = "")
    @Column(name = "department_name", nullable = true, length = 255, columnDefinition = "VARCHAR(32) COMMENT '部门名称'")
    private String departmentName;

    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动类型编码'")
    private String activityTypeCode;

    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动类型名称'")
    private String activityTypeName;

    @ApiModelProperty("费用总额")
    @Column(name = "total_cost", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '费用总额'")
    private BigDecimal totalCost;

    @ApiModelProperty("点外费用")
    @Column(name = "off_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '点外费用'")
    private BigDecimal offAmount;

    @ApiModelProperty("点内费用")
    @Column(name = "internal_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '点内费用'")
    private BigDecimal internalAmount;

    @ApiModelProperty("自投费用")
    @Column(name = "auto_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '自投费用'")
    private BigDecimal autoAmount;

    @ApiModelProperty("折前收入")
    @Column(name = "before_discount_income", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '折前收入'")
    private BigDecimal beforeDiscountIncome;

    @ApiModelProperty("折后收入")
    @Column(name = "after_discount_income", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '折后收入'")
    private BigDecimal afterDiscountIncome;

    @ApiModelProperty("投入产出比")
    @Column(name = "input_output_ratio", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '投入产出比'")
    private BigDecimal inputOutputRatio;

}