package com.biz.crm.tpm.business.activity.plan.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @ClassName ReferendumCostEntity
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/9
 */
@ApiModel(value = "ReferendumCostEntity", description = "活动规划套表-公投费用保存表")
@TableName("tpm_activity_plan_table_referendum_cost")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_table_referendum_cost")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_table_referendum_cost", comment = "活动规划套表-公投费用保存表")
@Table(name = "tpm_activity_plan_table_referendum_cost", indexes = {@Index(name = "table_code_index", columnList = "activity_plan_table_code")})
public class ActivityPlanTableReferendumCostEntity extends TenantFlagOpEntity {

    /**
     * 活动规划套表编码
     */
    @ApiModelProperty("活动规划套表编码")
    @Column(name = "activity_plan_table_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动规划套表编码'")
    private String activityPlanTableCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    @Column(name = "year_month_ly", length = 10, columnDefinition = "VARCHAR(10) COMMENT '年月'")
    private String yearMonthLy;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码'")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '组织名称'")
    private String orgName;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码'")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '预算项目名称'")
    private String budgetItemName;

    /**
     * 费用来源[数据字典:tpm_fee_source]
     */
    @ApiModelProperty(value = "费用来源[数据字典:tpm_fee_source]")
    @Column(name = "fee_source_code", nullable = true, length = 60, columnDefinition = "VARCHAR(60) COMMENT '费用来源[数据字典:tpm_fee_source]'")
    private String feeSourceCode;

    /**
     * 预算金额
     */
    @ApiModelProperty("预算金额")
    @Column(name = "budget_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '预算金额'")
    private BigDecimal budgetAmount;

    /**
     * 核准金额
     */
    @ApiModelProperty("核准金额")
    @Column(name = "approved_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '核准金额'")
    private BigDecimal approvedAmount;

    @ApiModelProperty("已规划金额")
    @Column(name = "used_amount ", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '已规划金额'")
    private BigDecimal usedAmount;

}
