package com.biz.crm.tpm.business.activity.plan.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName SaleForecastEntity
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/9
 */
@ApiModel(value = "SaleForecastEntity", description = "活动规划套表-销售预测保存表")
@TableName("tpm_activity_plan_table_sale_forecast")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_table_sale_forecast")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_table_sale_forecast", comment = "活动规划套表-销售预测保存表")
@Table(name = "tpm_activity_plan_table_sale_forecast", indexes = {@Index(name = "table_code_index", columnList = "activity_plan_table_code")})
public class ActivityPlanTableSaleForecastEntity extends TenantFlagOpEntity {

    /**
     * 活动规划套表编码
     */
    @ApiModelProperty("活动规划套表编码")
    @Column(name = "activity_plan_table_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动规划套表编码'")
    private String activityPlanTableCode;

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "fee_year_month", nullable = true, columnDefinition = "datetime COMMENT '费用所属年月'")
    private Date feeYearMonth;


    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码'")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '组织名称'")
    private String orgName;

    /**
     * 部门编码
     */
    @ApiModelProperty(value = "部门编码", notes = "")
    @Column(name = "department_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织名称'")
    private String departmentCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(value = "部门名称", notes = "")
    @Column(name = "department_name", nullable = true, length = 255, columnDefinition = "VARCHAR(32) COMMENT '部门名称'")
    private String departmentName;

    @ApiModelProperty("所属销售组编码")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售组编码'")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组名称")
    @Column(name = "sales_org_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '所属销售组名称'")
    private String salesOrgName;

    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '客户名称'")
    private String customerName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码", notes = "")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称", notes = "")
    @Column(name = "product_brand_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '品牌名称'")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码", notes = "")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码'")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称", notes = "")
    @Column(name = "product_category_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '品类名称'")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(value = "品项编码", notes = "")
    @Column(name = "product_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品项编码'")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(value = "品项名称", notes = "")
    @Column(name = "product_item_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '品项名称'")
    private String productItemName;

    @ApiModelProperty(value = "产品编码", notes = "产品编码")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(value = "产品名称", notes = "产品名称")
    @Column(name = "product_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty("折前到岸价")
    @Column(name = "before_discount_cost_and_freight", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '折前到岸价'")
    private BigDecimal beforeDiscountCostAndFreight;

    @ApiModelProperty("折前供货价	")
    @Column(name = "before_discount_provide_goods_price", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '折前供货价'")
    private BigDecimal beforeDiscountProvideGoodsPrice;

    @ApiModelProperty("全月出库件数")
    @Column(name = "month_out_stock_quantity", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '全月出库件数'")
    private BigDecimal monthOutStockQuantity;

    @ApiModelProperty("折前销售收入")
    @Column(name = "before_discount_sale_income", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '折前销售收入'")
    private BigDecimal beforeDiscountSaleIncome;

    @ApiModelProperty("折前销售成本")
    @Column(name = "before_discount_sale_cost", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '折前销售成本'")
    private BigDecimal beforeDiscountSaleCost;

    @ApiModelProperty("理论毛利")
    @Column(name = "theory_profit", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '理论毛利'")
    private BigDecimal theoryProfit;

    @ApiModelProperty("理论毛利率")
    @Column(name = "theory_gross_margin_rate", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '理论毛利率'")
    private BigDecimal theoryGrossMarginRate;

    @ApiModelProperty("折后销量")
    @Column(name = "after_discount_sale_quantity", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '折后销量'")
    private BigDecimal afterDiscountSaleQuantity;

    @ApiModelProperty("折后成本")
    @Column(name = "after_discount_cost", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '折后成本'")
    private BigDecimal afterDiscountCost;

}