package com.biz.crm.tpm.business.activity.plan.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @ClassName SpecialCostEntity
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/13
 */
@ApiModel(value = "SpecialCostEntity", description = "活动规划套表-专项费用保存表")
@TableName("tpm_activity_plan_table_special_cost")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_table_special_cost")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_table_special_cost", comment = "活动规划套表-专项费用保存表")
@Table(name = "tpm_activity_plan_table_special_cost", indexes = {@Index(name = "profit_id_index", columnList = "profit_id")})
public class ActivityPlanTableSpecialCostEntity extends TenantFlagOpEntity {

    @ApiModelProperty("利润测算id")
    @Column(name = "profit_id", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '利润测算id'")
    private String profitId;
    /**
     * 活动规划编码
     */
    @ApiModelProperty(value = "活动规划编码", notes = "")
    @Column(name = "activity_design_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动规划编码'")
    private String activityDesignCode;

    /**
     * 活动规划明细编码
     */
    @ApiModelProperty(value = "活动规划明细编码", notes = "")
    @Column(name = "activity_design_detail_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动规划明细编码'")
    private String activityDesignDetailCode;

    @ApiModelProperty("是否合计")
    @Column(name = "is_total", nullable = true, length = 1, columnDefinition = "INT(1) COMMENT '是否合计'")
    private Boolean isTotal;

    @ApiModelProperty(value = "活动类型编码", notes = "活动类型编码")
    @Column(name = "activity_type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动类型编码'")
    private String activityTypeCode;

    @ApiModelProperty(value = "活动类型名称", notes = "活动类型名称")
    @Column(name = "activity_type_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动类型名称'")
    private String activityTypeName;

    @ApiModelProperty("专项费用")
    @Column(name = "special_cost", nullable = true, precision = 24, scale = 6, columnDefinition = "VARCHAR(32) COMMENT '专项费用'")
    private BigDecimal specialCost;



    /**
     * 客户渠道编码
     */
    @ApiModelProperty(value = "客户渠道编码", notes = "")
    @Column(name = "customer_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道编码'")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(value = "客户渠道名称", notes = "")
    @Column(name = "customer_channel_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '客户渠道名称'")
    private String customerChannelName;


    /**
     * 点外金额
     */
    @ApiModelProperty(value = "点外金额", notes = "")
    @Column(name = "off_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "VARCHAR(32) COMMENT '点外金额'")
    private BigDecimal offAmount;

    /**
     * 点内金额
     */
    @ApiModelProperty(value = "点内金额", notes = "")
    @Column(name = "internal_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "VARCHAR(32) COMMENT '点内金额'")
    private BigDecimal internalAmount;

    @ApiModelProperty("是否和价格相关")
    @Column(name = "is_relate_price", nullable = true, length = 1, columnDefinition = "INT(1) COMMENT '是否和价格相关'")
    private Boolean isRelatePrice;

}
