package com.biz.crm.tpm.business.activity.plan.table.local.event;

import com.alibaba.fastjson.JSON;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.ActivityPlanTableDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.service.ActivityPlanTableService;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.ActivityPlanTableVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.ActivityPlanTableListenDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.event.ActivityPlanTableEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.ActivityPlanTableListenVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/8 12:18
 * @description：事件监听
 */
@Service
@Slf4j
public class ActivityPlanTableEventListenerImpl implements ActivityPlanTableEventListener {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityPlanTableService activityPlanTableService;
    @Override
    public void save(ActivityPlanTableListenDto dto) {
        log.info("活动规划创建活动规划套表,输入参数为:{}", JSON.toJSONString(dto));
        Validate.notNull(dto,"输入参数不能为空");
        ActivityPlanTableDto activityPlanTableDto = this.nebulaToolkitService.copyObjectByWhiteList(dto, ActivityPlanTableDto.class, null, null);
        activityPlanTableService.save(activityPlanTableDto);
    }

    @Override
    public List<ActivityPlanTableListenVo> listByCondition(ActivityPlanTableListenDto dto) {
        Validate.notNull(dto,"输入参数不能为空");

        ActivityPlanTableDto activityPlanTableDto = this.nebulaToolkitService.copyObjectByWhiteList(dto, ActivityPlanTableDto.class, null, null);
        List<ActivityPlanTableVo> activityPlanTableVos = activityPlanTableService.listByCondition(activityPlanTableDto);
        if(CollectionUtils.isNotEmpty(activityPlanTableVos)){
            Collection<ActivityPlanTableListenVo> activityPlanTableListenVos = this.nebulaToolkitService.copyCollectionByBlankList(activityPlanTableVos, ActivityPlanTableVo.class, ActivityPlanTableListenVo.class, LinkedHashSet.class, ArrayList.class);
            return (List<ActivityPlanTableListenVo>) activityPlanTableListenVos;
        }
        return new ArrayList<>();
    }

    @Override
    public void updateGenerateStatus(String tableId) {
        Validate.notEmpty(tableId, "要更新的数据不能为空！");
        activityPlanTableService.updateGenerateStatus(tableId);
    }
}
