package com.biz.crm.tpm.business.activity.plan.table.local.event;

import com.biz.crm.tpm.business.activity.plan.table.sdk.service.ActivityPlanTableService;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.ActivityPlanTableVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SelectActivityPlanTableEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.event.SelectActivityPlanTableEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SelectActivityPlanTableEventVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashSet;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/3/20
 */
@Service
@Slf4j
public class SelectActivityPlanTableEventListenerImpl implements SelectActivityPlanTableEventListener {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityPlanTableService activityPlanTableService;

    /**
     * 更据 年月+组织编码+版本查询套表
     * @param dto
     * @return
     */
    @Override
    public SelectActivityPlanTableEventVo selectTableByYearMonthAndOrg(SelectActivityPlanTableEventDto dto) {
        if (ObjectUtils.isEmpty(dto)) {
            return new SelectActivityPlanTableEventVo();
        }
        Validate.notBlank(dto.getYearAndMonth(),"年月不能为空！");
        Validate.notBlank(dto.getOrgCode(),"组织编码不能为空！");
        Validate.notBlank(dto.getTableVersion(),"套表版本不能为空！");
        ActivityPlanTableVo tableVo = activityPlanTableService.selectTableByYearMonthAndOrg(dto);
        if (ObjectUtils.isEmpty(tableVo)) {
            return new SelectActivityPlanTableEventVo();
        }
        SelectActivityPlanTableEventVo eventVo = nebulaToolkitService.copyObjectByWhiteList(tableVo, SelectActivityPlanTableEventVo.class, HashSet.class, ArrayList.class);
        return eventVo;
    }

}
