package com.biz.crm.tpm.business.activity.plan.table.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.tpm.business.activity.plan.table.local.exports.vo.PutOutputRatioCustomerExportVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.ActivityPlanTableDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.service.ActivityPlanTableService;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.PutOutputRatioCustomerVo;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 投入产出比客户维度导出
 *
 * @author liyang
 * @date 2023/12/22
 */
@Slf4j
@Component
public class PutOutputRatioCustomerExportProcess implements ExportProcess<PutOutputRatioCustomerExportVo> {

  @Autowired(required = false)
  private ActivityPlanTableService activityPlanTableService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    log.info("投入产出比客户维度导出,参数{}", JSONObject.toJSONString(params));
    ActivityPlanTableDto dto = JSONObject.parseObject(JSONObject.toJSONString(params), ActivityPlanTableDto.class);
    Pageable pageable = PageRequest.of(1,1);

    log.info("投入产出比客户维度导出,查询参数{}", JSONObject.toJSONString(dto));
    Page<PutOutputRatioCustomerVo> page = this.activityPlanTableService.findPutOutputRatioCustomerByConditions(pageable, dto);

    log.info("投入产出比客户维度导出,返回值{}", JSONObject.toJSONString(page));
    return page == null ? 0 : Integer.parseInt(String.valueOf(page.getTotal()));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    log.info("投入产出比客户维度导出,data{}", JSONObject.toJSONString(vo));
    ActivityPlanTableDto dto = JSONObject.parseObject(JSONObject.toJSONString(params), ActivityPlanTableDto.class);
    Pageable pageable = PageRequest.of(1, vo.getPageSize());
    Page<PutOutputRatioCustomerVo> page = this.activityPlanTableService.findPutOutputRatioCustomerByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(page.getRecords()));
  }

  @Override
  public String getBusinessCode() {
    return "PUT_OUTPUT_RATIO_CUSTOMER";
  }

  @Override
  public String getBusinessName() {
    return "活动套表-投入产出比客户维度导出";
  }
}
