package com.biz.crm.tpm.business.activity.plan.table.local.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 投入产出比客户维度导出vo
 * 
 * @author liyang
 * @date 2023/12/22
 */
@CrmExcelExport
@Data
public class PutOutputRatioCustomerExportVo extends CrmExcelVo {

  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
  @DateTimeFormat(pattern = "yyyy-MM")
  private Date feeYearMonth;

  @CrmExcelColumn("组织编码")
  private String orgCode;

  @CrmExcelColumn("组织名称")
  private String orgName;

  @CrmExcelColumn("客户编码")
  private String customerCode;

  @CrmExcelColumn("客户名称")
  private String customerName;

//  @CrmExcelColumn("活动类型编码")
  private String activityTypeCode;

//  @CrmExcelColumn("活动类型名称")
  private String activityTypeName;

  @CrmExcelColumn("费用合计")
  private BigDecimal totalCost;

  @CrmExcelColumn("折前收入")
  private BigDecimal beforeDiscountIncome;

  @CrmExcelColumn("折后收入")
  private BigDecimal afterDiscountIncome;

  @CrmExcelColumn("折前投产比")
  private BigDecimal beforeInputOutputRatio;

  @CrmExcelColumn("折后投产比")
  private BigDecimal afterInputOutputRatio;

  // ------------------------活动分类金额
  @CrmExcelColumn("陈列")
  private BigDecimal display;
  @CrmExcelColumn("人员")
  private BigDecimal personnel;
  @CrmExcelColumn("推广")
  private BigDecimal promotion;
  @CrmExcelColumn("促销")
  private BigDecimal sell;
  @CrmExcelColumn("物料")
  private BigDecimal material;
  @CrmExcelColumn("渠道建设")
  private BigDecimal channelConstruction;
  @CrmExcelColumn("旧货处理")
  private BigDecimal disposalOfUsedGoods;
  @CrmExcelColumn("其他费用")
  private BigDecimal other;
}
