package com.biz.crm.tpm.business.activity.plan.table.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTablePutOutputRatioEntity;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.PutOutputRatioCustomerVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.PutOutputRatioVo;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * @ClassName PutOutputRatioMapper
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/13
 */
public interface PutOutputRatioMapper extends BaseMapper<ActivityPlanTablePutOutputRatioEntity> {
    void deleteByTableCode(String tableCode);
    List<PutOutputRatioVo> findByTableCodeGroupByOrgCode(@Param("tableCode") String tableCode, @Param("tenantCode") String tenantCode);

    /**
     * 审批版，按客户汇总，不受套表编码限制
     *
     * @param feeYearMonth
     * @param tenantCode
     * @return
     */
    List<PutOutputRatioCustomerVo> findByTableCodeGroupByCustomerCode(@Param("feeYearMonth") Date feeYearMonth, @Param("tenantCode") String tenantCode);
}
