package com.biz.crm.tpm.business.activity.plan.table.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTableActivityPlanProfitEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.mapper.ActivityPlanProfitMapper;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.ActivityPlanProfitVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @ClassName ActivityPlanProfitRepository
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/13
 */
@Component
public class ActivityPlanProfitRepository extends ServiceImpl<ActivityPlanProfitMapper, ActivityPlanTableActivityPlanProfitEntity> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ActivityPlanProfitVo> findByTableCode(String tableCode) {
        List<ActivityPlanTableActivityPlanProfitEntity> entityList = this.lambdaQuery()
                .eq(ActivityPlanTableActivityPlanProfitEntity::getActivityPlanTableCode, tableCode)
                .eq(ActivityPlanTableActivityPlanProfitEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ActivityPlanTableActivityPlanProfitEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
        return new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(entityList, ActivityPlanTableActivityPlanProfitEntity.class, ActivityPlanProfitVo.class, LinkedHashSet.class, ArrayList.class));
    }

    public void deleteByTableCode(String tableCode) {
        this.baseMapper.deleteByTableCode(tableCode);
    }
}
