package com.biz.crm.tpm.business.activity.plan.table.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTable;
import com.biz.crm.tpm.business.activity.plan.table.local.mapper.ActivityPlanTableMapper;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.ActivityPlanTableDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.ActivityPlanTableVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SelectActivityPlanTableEventDto;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/5 14:18
 * @description：活动规划套表
 */
@Component
public class ActivityPlanTableRepository extends ServiceImpl<ActivityPlanTableMapper, ActivityPlanTable> {

    @Autowired
    private ActivityPlanTableMapper activityPlanTableMapper;
    public Page<ActivityPlanTableVo> findByConditions(Pageable pageable, ActivityPlanTableDto dto) {

        Page<ActivityPlanTableVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<ActivityPlanTableVo> pageList = this.activityPlanTableMapper.findByConditions(page, dto);
        return pageList;
    }

    public List<ActivityPlanTable> listByCondition(ActivityPlanTableDto dto) {
        if(Objects.isNull(dto)){
            return new ArrayList<>();
        }
        Validate.isTrue(StringUtils.isEmpty(dto.getOrgCode())&&StringUtils.isEmpty(dto.getYearAndMonth()),"查询条件不能为空");
        List<ActivityPlanTable> list = this.lambdaQuery().eq(ActivityPlanTable::getOrgCode, dto.getOrgCode())
                .eq(ActivityPlanTable::getYearAndMonth, dto.getYearAndMonth())
                .eq(ActivityPlanTable::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        if(CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }

        return list;
    }

    /**
     * 批量查询
     *
     * @author huojia
     * @date 2023/2/21 15:24
     * @param ids
     * @param delFlag
     **/
    public List<ActivityPlanTable> listByIds(List<String> ids, String delFlag) {
        if (CollectionUtils.isEmpty(ids) || StringUtils.isEmpty(delFlag)) {
            return null;
        }
        return this.lambdaQuery()
                .in(UuidEntity::getId, ids)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    public ActivityPlanTable getByProcessNo(String processNo) {
        if (StringUtils.isEmpty(processNo)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(ActivityPlanTable::getProcessNo, processNo)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
    }

    public ActivityPlanTable selectTableByYearMonthAndOrg(SelectActivityPlanTableEventDto dto) {
        return this.lambdaQuery()
                .eq(ActivityPlanTable::getYearAndMonth,dto.getYearAndMonth())
                .eq(ActivityPlanTable::getOrgCode,dto.getOrgCode())
                .eq(ActivityPlanTable::getTableVersion,dto.getTableVersion())
                .one();
    }
}
