package com.biz.crm.tpm.business.activity.plan.table.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTableCostCollectEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.mapper.CostCollectMapper;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.CostCollectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @ClassName CostCollectRepository
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/13
 */
@Component
public class CostCollectRepository extends ServiceImpl<CostCollectMapper, ActivityPlanTableCostCollectEntity> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteByTableCode(String tableCode) {
        this.baseMapper.deleteByTableCode(tableCode);
    }

    public List<CostCollectVo> findByTableCode(String tableCode) {
        List<ActivityPlanTableCostCollectEntity> costCollectEntityList = this.lambdaQuery()
                .eq(ActivityPlanTableCostCollectEntity::getActivityPlanTableCode, tableCode)
                .eq(ActivityPlanTableCostCollectEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanTableCostCollectEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
        return new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(costCollectEntityList, ActivityPlanTableCostCollectEntity.class, CostCollectVo.class, LinkedHashSet.class, ArrayList.class));
    }
}
