package com.biz.crm.tpm.business.activity.plan.table.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTableFinalFixedExpenseEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.mapper.FinalFixedExpenseMapper;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.FinalFixedExpenseDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.FinalFixedExpenseVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @ClassName FinalFixedExpenseRepository
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/13
 */
@Component
public class FinalFixedExpenseRepository extends ServiceImpl<FinalFixedExpenseMapper, ActivityPlanTableFinalFixedExpenseEntity> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteByTableCode(String tableCode) {
        this.baseMapper.deleteByTableCode(tableCode);
    }

    public List<FinalFixedExpenseVo> findByTableCode(String tableCode) {
        List<ActivityPlanTableFinalFixedExpenseEntity> finalFixedExpenseEntityList = this.lambdaQuery()
                .eq(ActivityPlanTableFinalFixedExpenseEntity::getActivityPlanTableCode, tableCode)
                .eq(ActivityPlanTableFinalFixedExpenseEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanTableFinalFixedExpenseEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
        return new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(finalFixedExpenseEntityList, ActivityPlanTableFinalFixedExpenseEntity.class, FinalFixedExpenseVo.class, LinkedHashSet.class, ArrayList.class));
    }

    public Page<FinalFixedExpenseVo> findFinalFixedExpenseByConditionsForReport(Pageable pageable, FinalFixedExpenseDto dto) {
        Page<FinalFixedExpenseVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());

        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.getBaseMapper().findFinalFixedExpenseByConditionsForReport(page,dto);
    }
}
