package com.biz.crm.tpm.business.activity.plan.table.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTableFixedExpenseEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.mapper.FixedExpenseMapper;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.vo.FixedExpenseVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @ClassName FixedExpenseRepository
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/13
 */
@Component
public class FixedExpenseRepository extends ServiceImpl<FixedExpenseMapper, ActivityPlanTableFixedExpenseEntity> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteByTableCode(String tableCode) {
        this.baseMapper.deleteByTableCode(tableCode);
    }

    public List<FixedExpenseVo> findByProfitId(String id) {
        List<ActivityPlanTableFixedExpenseEntity> fixedExpenseEntityList = this.lambdaQuery()
                .eq(ActivityPlanTableFixedExpenseEntity::getProfitId, id)
                .eq(ActivityPlanTableFixedExpenseEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanTableFixedExpenseEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
        return new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(fixedExpenseEntityList, ActivityPlanTableFixedExpenseEntity.class, FixedExpenseVo.class, LinkedHashSet.class, ArrayList.class));
    }
}
