package com.biz.crm.tpm.business.activity.plan.table.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTablePriceEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.mapper.ActivityPlanTablePriceMapper;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.PriceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @ClassName ActivityPlanTablePriceRepository
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/14
 */
@Component
public class PriceRepository extends ServiceImpl<ActivityPlanTablePriceMapper, ActivityPlanTablePriceEntity> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteByTableCode(String tableCode) {
        this.baseMapper.deleteByTableCode(tableCode);
    }

    public List<PriceVo> findByTableCode(String tableCode) {
        List<ActivityPlanTablePriceEntity> priceEntityList = this.lambdaQuery()
                .eq(ActivityPlanTablePriceEntity::getActivityPlanTableCode, tableCode)
                .eq(ActivityPlanTablePriceEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanTablePriceEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
        return new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(priceEntityList, ActivityPlanTablePriceEntity.class, PriceVo.class, LinkedHashSet.class, ArrayList.class));
    }
}
