package com.biz.crm.tpm.business.activity.plan.table.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTablePutOutputRatioEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.mapper.PutOutputRatioMapper;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.PutOutputRatioCustomerVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.PutOutputRatioVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @ClassName PutOutputRatioRepository
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/13
 */
@Component
public class PutOutputRatioRepository extends ServiceImpl<PutOutputRatioMapper, ActivityPlanTablePutOutputRatioEntity> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteByTableCode(String tableCode) {
        this.baseMapper.deleteByTableCode(tableCode);
    }

    public List<PutOutputRatioVo> findByTableCode(String tableCode) {
        List<ActivityPlanTablePutOutputRatioEntity> putOutputRatioEntityList = this.lambdaQuery()
                .eq(ActivityPlanTablePutOutputRatioEntity::getActivityPlanTableCode, tableCode)
                .eq(ActivityPlanTablePutOutputRatioEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanTablePutOutputRatioEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
        return new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(putOutputRatioEntityList, ActivityPlanTablePutOutputRatioEntity.class, PutOutputRatioVo.class, LinkedHashSet.class, ArrayList.class));
    }

    public List<PutOutputRatioVo> findByTableCodeGroupByOrgCode(String tableCode) {
        return baseMapper.findByTableCodeGroupByOrgCode(tableCode, TenantUtils.getTenantCode());
    }

    public List<PutOutputRatioCustomerVo> findByTableCodeGroupByCustomerCode(Date feeYearMonth) {
        return baseMapper.findByTableCodeGroupByCustomerCode(feeYearMonth, TenantUtils.getTenantCode());
    }
}
