package com.biz.crm.tpm.business.activity.plan.table.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTableReferendumCostEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.mapper.ReferendumCostMapper;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.ReferendumCostVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @ClassName ReferendumCostRepository
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/13
 */
@Component
public class ReferendumCostRepository extends ServiceImpl<ReferendumCostMapper, ActivityPlanTableReferendumCostEntity> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteByTableCode(String tableCode) {
        this.baseMapper.deleteByTableCode(tableCode);
    }

    public List<ReferendumCostVo> findByTableCode(String tableCode) {
        List<ActivityPlanTableReferendumCostEntity> referendumCostEntityList = this.lambdaQuery()
                .eq(ActivityPlanTableReferendumCostEntity::getActivityPlanTableCode, tableCode)
                .eq(ActivityPlanTableReferendumCostEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanTableReferendumCostEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
        return new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(referendumCostEntityList, ActivityPlanTableReferendumCostEntity.class, ReferendumCostVo.class, LinkedHashSet.class, ArrayList.class));
    }
}
