package com.biz.crm.tpm.business.activity.plan.table.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTableSaleForecastEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.mapper.SaleForecastMapper;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.SaleForecastVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @ClassName SaleForecastRepository
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/13
 */
@Component
public class SaleForecastRepository extends ServiceImpl<SaleForecastMapper, ActivityPlanTableSaleForecastEntity> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteByTableCode(String tableCode) {
        this.baseMapper.deleteByTableCode(tableCode);
    }

    public List<SaleForecastVo> findByTableCode(String tableCode) {
        List<ActivityPlanTableSaleForecastEntity> saleForecastEntityList = this.lambdaQuery()
                .eq(ActivityPlanTableSaleForecastEntity::getActivityPlanTableCode, tableCode)
                .eq(ActivityPlanTableSaleForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanTableSaleForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
        return new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(saleForecastEntityList, ActivityPlanTableSaleForecastEntity.class, SaleForecastVo.class, LinkedHashSet.class, ArrayList.class));
    }
}
