package com.biz.crm.tpm.business.activity.plan.table.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTableSpecialCostEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.mapper.SpecialCostMapper;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SpecialCostVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @ClassName SpecialCostRepository
 * @Description
 * @Author: jiangyin
 * @Date 2023/3/13
 */
@Component
public class SpecialCostRepository extends ServiceImpl<SpecialCostMapper, ActivityPlanTableSpecialCostEntity> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteByTableCode(String tableCode) {
        this.baseMapper.deleteByTableCode(tableCode);
    }

    public List<SpecialCostVo> findByProfitId(String id) {
        List<ActivityPlanTableSpecialCostEntity> specialCostEntityList = this.lambdaQuery()
                .eq(ActivityPlanTableSpecialCostEntity::getProfitId, id)
                .eq(ActivityPlanTableSpecialCostEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanTableSpecialCostEntity::getTenantCode, TenantUtils.getTenantCode()).list();
        return new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(specialCostEntityList, ActivityPlanTableSpecialCostEntity.class, SpecialCostVo.class, LinkedHashSet.class, ArrayList.class));
    }
}
