package com.biz.crm.tpm.business.activity.plan.table.local.service.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.merge.OnceAbsoluteMergeStrategy;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.channel.sdk.dto.CustomerChannelDto;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.inquiry.sdk.service.InquiryVoService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SalesApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.SalesApprovalVo;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.*;
import com.biz.crm.tpm.business.activity.plan.table.local.repository.*;
import com.biz.crm.tpm.business.activity.plan.table.sdk.constants.ActivityPlanTableConstants;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.ActivityPlanTableBatchSubmitApprovalDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.ActivityPlanTableDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.FinalFixedExpenseDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.enumeration.SheetNameEnum;
import com.biz.crm.tpm.business.activity.plan.table.sdk.enumeration.TableVersionEnum;
import com.biz.crm.tpm.business.activity.plan.table.sdk.service.ActivityPlanTableService;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.*;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemMainItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemMainItemVo;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.dto.ProfitGoalDiscountDto;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.eunm.BudgetAmountTypeEnum;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.eunm.ConfirmEunm;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.service.ProfitGoalDiscountService;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.vo.FixedExpenseVo;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.vo.ProfitGoalDiscountVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.constant.SubComActivityDesignConstant;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SelectActivityPlanTableEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.IsBigDateOrNoEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.IsPriceRelatedNoEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.RelationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SpecialCostVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/5 14:05
 * @description：活动计划套表
 */
@Service
@Slf4j
public class ActivityPlanTableServiceImpl implements ActivityPlanTableService {

    @Autowired(required = false)
    private ActivityPlanTableRepository activityPlanTableRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private SalesPlanService salesPlanService;

    @Autowired(required = false)
    private OrgVoService orgVoService;
    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private SubComBudgetForecastService subComBudgetForecastService;

    @Autowired(required = false)
    private SubComActivityDesignDetailService subComActivityDesignDetailService;

    @Autowired(required = false)
    private ProfitGoalDiscountService profitGoalDiscountService;

    @Autowired(required = false)
    private ProcessBusinessService processBusinessService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private SubComActivityDesignService subComActivityDesignService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;

    @Autowired(required = false)
    private CustomerChannelVoService customerChannelVoService;

    @Autowired(required = false)
    private ActivityPlanProfitRepository activityPlanProfitRepository;

    @Autowired(required = false)
    private CostCollectRepository costCollectRepository;

    @Autowired(required = false)
    private FinalFixedExpenseRepository finalFixedExpenseRepository;

    @Autowired(required = false)
    private FixedExpenseRepository fixedExpenseRepository;

    @Autowired(required = false)
    private PutOutputRatioRepository putOutputRatioRepository;

    @Autowired(required = false)
    private ReferendumCostRepository referendumCostRepository;

    @Autowired(required = false)
    private SaleForecastRepository saleForecastRepository;

    @Autowired(required = false)
    private SpecialCostRepository specialCostRepository;

    @Autowired(required = false)
    private PriceRepository priceRepository;

    @Autowired(required = false)
    private PriceModelVoService priceModelVoService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private SubComActivityDesignBudgetService subComActivityDesignBudgetService;

    @Autowired(required = false)
    private BudgetItemMainItemService budgetItemMainItemService;

    @Autowired(required = false)
    private ColumnConfigVoService columnConfigVoService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;


    @Override
    public Page<ActivityPlanTableVo> findByConditions(Pageable pageable, ActivityPlanTableDto dto) {

        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new ActivityPlanTableDto();
        }
        return this.activityPlanTableRepository.findByConditions(pageable, dto);
    }

    @Override
    public ActivityPlanTableVo getById(String id,SheetNameEnum sheetNameEnum) {
        return getById(id,sheetNameEnum,false);
    }

    private ActivityPlanTableVo getById(String id,SheetNameEnum sheetNameEnum,boolean refresh) {
        Validate.notBlank(id, "输入参数不能为空");

        ActivityPlanTable activityPlanTable = this.activityPlanTableRepository.getById(id);
        Validate.notNull(activityPlanTable, "没有找到对应的数据");
        ActivityPlanTableVo activityPlanTableVo = this.nebulaToolkitService.copyObjectByWhiteList(activityPlanTable, ActivityPlanTableVo.class, null, null);

        //审批版且审批状态为审批中或审批通过，则取数据库存的提交时间节点数据
        if(!refresh && (sheetNameEnum == null || SheetNameEnum.SKIP.getCode() != sheetNameEnum.getCode())){
            if(TableVersionEnum.PROCESS_COMMIT_VERSION.getCode().equals(activityPlanTableVo.getTableVersion()) &&
                    (ProcessStatusEnum.PASS.getDictCode().equals(activityPlanTableVo.getProcessStatus()) || ProcessStatusEnum.COMMIT.getDictCode().equals(activityPlanTableVo.getProcessStatus()))){
                String tableCode = activityPlanTableVo.getActivityPlanTableCode();
                //利润测算
                try {
                    if(Objects.isNull(sheetNameEnum)) {
                        List<ActivityPlanProfitVo> profitVoList = activityPlanProfitRepository.findByTableCode(tableCode);
                        if(CollectionUtils.isNotEmpty(profitVoList)){
                            for(ActivityPlanProfitVo profitVo : profitVoList){
                                profitVo.setSpecialCostList(specialCostRepository.findByProfitId(profitVo.getId()));
                                profitVo.setFixedExpenseList(fixedExpenseRepository.findByProfitId(profitVo.getId()));
                            }
                        }
                        activityPlanTableVo.setActivityPlanProfitList(profitVoList);
                    }
                }catch (Exception e){
                    log.error(e.getMessage(),e);
                }
                //投入产出比
                try {
                    if(Objects.isNull(sheetNameEnum)||SheetNameEnum.PUT_OUTPUT_RATIO.equals(sheetNameEnum)) {
                        log.info("分页查询投入产出比审批版本");
                        List<PutOutputRatioVo> putOutputRatioVoList = putOutputRatioRepository.findByTableCodeGroupByOrgCode(tableCode);
                        activityPlanTableVo.setPutOutputRatioList(putOutputRatioVoList);
                        if (CollectionUtils.isNotEmpty(putOutputRatioVoList)) {
                            Date feeYearMonth = putOutputRatioVoList.get(0).getFeeYearMonth();
                            List<PutOutputRatioCustomerVo> putOutputRatioVoCustomerList = putOutputRatioRepository.findByTableCodeGroupByCustomerCode(feeYearMonth);
                            activityPlanTableVo.setPutOutputRatioCustomerList(putOutputRatioVoCustomerList);
                        }
                    }
                }catch (Exception e){
                    log.error(e.getMessage(),e);
                }
                //销售预测
                try {
                    if(Objects.isNull(sheetNameEnum)||SheetNameEnum.SALE_FORECAST.equals(sheetNameEnum)) {
                        List<SaleForecastVo> saleForecastVoList = saleForecastRepository.findByTableCode(tableCode);
                        activityPlanTableVo.setSaleForecastList(saleForecastVoList);
                    }
                }catch (Exception e){
                    log.error(e.getMessage(),e);
                }
                //价格
                try {
                    if(Objects.isNull(sheetNameEnum)||SheetNameEnum.PRICE.equals(sheetNameEnum)) {
                        List<PriceVo> priceVoList = priceRepository.findByTableCode(tableCode);
                        activityPlanTableVo.setPriceList(priceVoList);
                    }
                }catch (Exception e){
                    log.error(e.getMessage(),e);
                }
                //费用汇总
                try {
                    if(Objects.isNull(sheetNameEnum)||SheetNameEnum.COST_COLLECT.equals(sheetNameEnum)) {
                        List<CostCollectVo> costCollectVoList = costCollectRepository.findByTableCode(tableCode);
                        activityPlanTableVo.setCostCollectList(costCollectVoList);
                    }
                }catch (Exception e){
                    log.error(e.getMessage(),e);
                }
                //公投费用
                try {
                    if(Objects.isNull(sheetNameEnum)||SheetNameEnum.REFERENDUM_COST.equals(sheetNameEnum)) {
                        //List<ReferendumCostVo> referendumCostVoList = referendumCostRepository.findByTableCode(tableCode);
                        //activityPlanTableVo.setReferendumCostList(referendumCostVoList);
                        List<OrgVo> orgVoList = orgVoService.findAllChildrenByOrgCode(activityPlanTableVo.getOrgCode());
                        Set<String> orgCodes = orgVoList.stream().map(OrgVo::getOrgCode).collect(Collectors.toSet());
                        orgCodes = Optional.ofNullable(orgCodes).orElse(SetUtils.emptySet());
                        orgCodes.add(activityPlanTableVo.getOrgCode());
                        activityPlanTableVo.setReferendumCostList(getReferendumCostList(activityPlanTableVo, orgCodes));
                    }
                }catch (Exception e){
                    log.error(e.getMessage(),e);
                }
                //固定支出
                try {
                    if(Objects.isNull(sheetNameEnum)||SheetNameEnum.FINAL_FIXED_EXPENSE.equals(sheetNameEnum)) {
                        List<FinalFixedExpenseVo> finalFixedExpenseVoList = finalFixedExpenseRepository.findByTableCode(tableCode);
                        activityPlanTableVo.setFixedExpenseList(finalFixedExpenseVoList);
                    }
                }catch (Exception e){
                    log.error(e.getMessage(),e);
                }
                convertActivityTableData(activityPlanTableVo,null);
                if (CollectionUtils.isNotEmpty(activityPlanTableVo.getCostCollectList())) {
                    this.fillDesignName(activityPlanTableVo.getCostCollectList());
                }
                return activityPlanTableVo;
            }
        } else if (null != sheetNameEnum && SheetNameEnum.SKIP.getCode() == sheetNameEnum.getCode()) {
            sheetNameEnum = null;
        }
        List<OrgVo> orgVoList = orgVoService.findAllChildrenByOrgCode(activityPlanTableVo.getOrgCode());
        Set<String> orgCodes = orgVoList.stream().map(OrgVo::getOrgCode).collect(Collectors.toSet());
        orgCodes = Optional.ofNullable(orgCodes).orElse(SetUtils.emptySet());
        orgCodes.add(activityPlanTableVo.getOrgCode());

        //销售计划数据
        SalesPlanDto salesPlanDto = new SalesPlanDto();
        salesPlanDto.setYearMonthLy(activityPlanTableVo.getYearAndMonth());
        //根据组织编码找到对应的销售组织
        OrgVo orgVo = orgVoService.findByOrgCode(activityPlanTableVo.getOrgCode());
        Validate.notNull(orgVo,"未找到组织编码【%s】组织数据",activityPlanTableVo.getOrgCode());
        Validate.notNull(orgVo.getSalesOrgCode(),"组织【%s】未维护对应销售组织",activityPlanTableVo.getOrgCode());
        SalesOrgVo salesOrgVo = salesOrgVoService.findBySalesOrgCode(orgVo.getSalesOrgCode());
        Validate.notNull(salesOrgVo,"未找到销售组织编码【%s】组织数据",orgVo.getSalesOrgCode());
        salesPlanDto.setSalesInstitutionErpCode(salesOrgVo.getErpCode());
        salesPlanDto.setSpecialDataStatus(ConfirmEunm.COMPLETETHECONFIRMATION.getCode());
        List<SalesPlanVo> salesPlanVoList = salesPlanService.findByConditions(salesPlanDto);
//        salesPlanVoList = salesPlanVoList.stream().filter(o -> StringUtils.isNotEmpty(o.getCustomerChannelCode())).collect(Collectors.toList());

        //分子公司活动规划
        List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList = null;
        if (refresh){
            SubComActivityDesignDetailDto subComActivityDesignDetailDto = new SubComActivityDesignDetailDto();
            subComActivityDesignDetailDto.setProcessNo(activityPlanTableVo.getProcessNo());
            subComActivityDesignDetailVoList = subComActivityDesignDetailService.findBudgetDetailByConditions(subComActivityDesignDetailDto);
        }else{
            SubComActivityDesignDetailDto subComActivityDesignDetailDto = new SubComActivityDesignDetailDto();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
            try {
                Validate.notBlank(activityPlanTableVo.getYearAndMonth(),"年月不能为空");
                Date yearAndMonth = df.parse(activityPlanTableVo.getYearAndMonth());
                subComActivityDesignDetailDto.setFeeYearMonth(yearAndMonth);
            } catch (ParseException e) {
                log.error(e.getMessage(),e);
                e.printStackTrace();
            }
            subComActivityDesignDetailDto.setOrgCodeSet(orgCodes);
            subComActivityDesignDetailVoList = subComActivityDesignDetailService.findBudgetDetailByConditions(subComActivityDesignDetailDto);
        }
        if (CollectionUtils.isNotEmpty(subComActivityDesignDetailVoList)) {
            //费用合计 = 费用合计 - 关闭金额
            subComActivityDesignDetailVoList.stream().forEach(d -> {d.setTotalCost(Optional.ofNullable(d.getTotalCost()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(d.getWillRefundAmount()).orElse(BigDecimal.ZERO)));});
        }

        //利润测算
        try {
            if(Objects.isNull(sheetNameEnum)) {
                List<ActivityPlanProfitVo> activityPlanProfit = getActivityPlanProfit(activityPlanTableVo, orgCodes, salesPlanVoList,subComActivityDesignDetailVoList);
                activityPlanTableVo.setActivityPlanProfitList(activityPlanProfit);
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
        }
        //投入产出比
        try {
            if(Objects.isNull(sheetNameEnum)||SheetNameEnum.PUT_OUTPUT_RATIO.equals(sheetNameEnum)) {
                log.info("分页查询投入产出比实时版本");
//                List<PutOutputRatioVo> putOutputRatioList = getPutOutputRatioList(activityPlanTableVo, orgCodes, salesPlanVoList, subComActivityDesignDetailVoList);
//                List<PutOutputRatioVo> withOutCustomerList = this.withOutCustomer(subComActivityDesignDetailVoList);
//                if(CollectionUtils.isNotEmpty(withOutCustomerList)){
//                    putOutputRatioList.addAll(withOutCustomerList);
//                }
                // 直接按组织汇总
                List<PutOutputRatioVo> putOutputRatioList = this.getPutOutputRatioListGroupByOrgCode(salesPlanVoList, subComActivityDesignDetailVoList);
                activityPlanTableVo.setPutOutputRatioList(putOutputRatioList);
                List<PutOutputRatioCustomerVo> putOutputRatioCustomerList = this.getPutOutputRatioListGroupByCustomerCode(salesPlanVoList, subComActivityDesignDetailVoList);
                activityPlanTableVo.setPutOutputRatioCustomerList(putOutputRatioCustomerList);
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
        }
        //销售预测
        try {
            if(Objects.isNull(sheetNameEnum)||SheetNameEnum.SALE_FORECAST.equals(sheetNameEnum)) {
                activityPlanTableVo.setSaleForecastList(getSaleForecastList(activityPlanTableVo, orgCodes, salesPlanVoList, subComActivityDesignDetailVoList));
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
        }

        //价格
        try {
            if(Objects.isNull(sheetNameEnum)||SheetNameEnum.PRICE.equals(sheetNameEnum)) {
                activityPlanTableVo.setPriceList(getPriceList(activityPlanTableVo, orgCodes, salesPlanVoList));
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
        }
        //费用汇总
        try {
            if(Objects.isNull(sheetNameEnum)||SheetNameEnum.COST_COLLECT.equals(sheetNameEnum)) {
                activityPlanTableVo.setCostCollectList(getCostCollectList(subComActivityDesignDetailVoList));
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
        }
        //公投费用
        try {
            if(Objects.isNull(sheetNameEnum)||SheetNameEnum.REFERENDUM_COST.equals(sheetNameEnum)) {
                activityPlanTableVo.setReferendumCostList(getReferendumCostList(activityPlanTableVo, orgCodes));
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
        }
        //固定支出
        try {
            if(Objects.isNull(sheetNameEnum)||SheetNameEnum.FINAL_FIXED_EXPENSE.equals(sheetNameEnum)) {
                activityPlanTableVo.setFixedExpenseList(getFixedExpenseList(activityPlanTableVo, orgCodes));
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
        }
        convertActivityTableData(activityPlanTableVo,subComActivityDesignDetailVoList);
        return activityPlanTableVo;
    }

    /**
     * 填充活动规划名称
     * @param costCollectVoList
     */
    private void fillDesignName(List<CostCollectVo> costCollectVoList) {
        if (CollectionUtils.isEmpty(costCollectVoList)) {
            return;
        }
        List<String> designCodes = costCollectVoList.stream().map(CostCollectVo::getActivityDesignCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SubComActivityDesignVo> designVoList = subComActivityDesignService.findByDesignCodes(designCodes);
        if (CollectionUtils.isNotEmpty(designVoList)) {
            Map<String, SubComActivityDesignVo> designVoMap = designVoList.stream().collect(Collectors.toMap(SubComActivityDesignVo::getActivityDesignCode, Function.identity(), (v1, v2) -> v2));
            costCollectVoList.forEach(cost -> {
                SubComActivityDesignVo designVo = designVoMap.get(cost.getActivityDesignCode());
                if (!Objects.isNull(designVo)) {
                    cost.setActivityDesignName(designVo.getActivityDesignName());
                }
            });
        }
    }

    private void convertActivityTableData(ActivityPlanTableVo activityPlanTableVo,List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList){
        if (null == activityPlanTableVo){
            return;
        }
        Date curDate = new Date();
        SimpleDateFormat dayFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        //投入产品比
        if (!CollectionUtils.isEmpty(activityPlanTableVo.getPutOutputRatioList())){
            for (PutOutputRatioVo putOutputRatioVo : activityPlanTableVo.getPutOutputRatioList()) {
                if (null != putOutputRatioVo.getBeforeDiscountIncome() && BigDecimal.ZERO.compareTo(putOutputRatioVo.getBeforeDiscountIncome()) != 0){
                    putOutputRatioVo.setBeforeInputOutputRatio(Optional.ofNullable(putOutputRatioVo.getTotalCost()).orElse(BigDecimal.ZERO).divide(putOutputRatioVo.getBeforeDiscountIncome(),4,BigDecimal.ROUND_DOWN));
                }
                if (null != putOutputRatioVo.getAfterDiscountIncome() && BigDecimal.ZERO.compareTo(putOutputRatioVo.getAfterDiscountIncome()) != 0){
                    putOutputRatioVo.setAfterInputOutputRatio(Optional.ofNullable(putOutputRatioVo.getTotalCost()).orElse(BigDecimal.ZERO).divide(putOutputRatioVo.getAfterDiscountIncome(),4,BigDecimal.ROUND_DOWN));
                }
            }
        }
        //价格
        if (!CollectionUtils.isEmpty(activityPlanTableVo.getPriceList())){
            for (PriceVo priceVo : activityPlanTableVo.getPriceList()) {
                //                -理论毛利：（标准供货价-到岸价）/标准供货价；
                if (null != priceVo.getStandardSupplyPrice() && priceVo.getStandardSupplyPrice().compareTo(BigDecimal.ZERO) != 0){
                    priceVo.setTheoryGrossProfit(priceVo.getStandardSupplyPrice().subtract(Optional.ofNullable(priceVo.getCifPrice()).orElse(BigDecimal.ZERO)).divide(priceVo.getStandardSupplyPrice(),4,RoundingMode.HALF_UP));
                }
                //                -毛利：（还原后价格-活动单价）/还原后价格；
                if (null != priceVo.getRestoredPrice() && priceVo.getRestoredPrice().compareTo(BigDecimal.ZERO) != 0){
                    priceVo.setGrossProfit(priceVo.getRestoredPrice().subtract(Optional.ofNullable(priceVo.getActivityLowestPrice()).orElse(BigDecimal.ZERO)).divide(priceVo.getRestoredPrice(),4,RoundingMode.HALF_UP));
                }
                //                -前台毛利：（活动零售价-还原后价格）/活动零售价；
                if (null != priceVo.getActivityRetailPrice() && priceVo.getActivityRetailPrice().compareTo(BigDecimal.ZERO) != 0){
                    priceVo.setFrontGrossProfit(priceVo.getActivityRetailPrice().subtract(Optional.ofNullable(priceVo.getRestoredPrice()).orElse(BigDecimal.ZERO)).divide(priceVo.getActivityRetailPrice(),4,RoundingMode.HALF_UP));
                }
            }
        }
        //费用汇总
        if (!CollectionUtils.isEmpty(activityPlanTableVo.getCostCollectList())){
            Set<String> activityDesignDetailCodeSet = activityPlanTableVo.getCostCollectList().stream().map(SubComActivityDesignDetailVo::getActivityDesignDetailCode).collect(Collectors.toSet());
            if (null == subComActivityDesignDetailVoList){
                subComActivityDesignDetailVoList = subComActivityDesignDetailService.findDesignDetailByCodeList(activityDesignDetailCodeSet);
            }
            Map<String, SubComActivityDesignDetailVo> subComActivityDesignDetailVoMap = subComActivityDesignDetailVoList.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity()));

            List<SubComActivityDesignBudgetVo> budgetVoList = subComActivityDesignBudgetService.listByActivityDetailCodes(com.google.common.collect.Lists.newArrayList(activityDesignDetailCodeSet));
            Map<String, List<SubComActivityDesignBudgetVo>> budgetVoMap = null;
            if (!org.springframework.util.CollectionUtils.isEmpty(budgetVoList)) {
                budgetVoMap = budgetVoList.stream().collect(Collectors.groupingBy(SubComActivityDesignBudgetVo::getActivityDesignDetailCode));
            }
            //关联类型为 ‘关联向上分子细案’ 的明细，预算项目编码需要转换下。
            Map<String, BudgetItemMainItemVo> budgetItemMainItemMap = null;
            Set<String> mainBudgetItemCodeSet = new HashSet<>();
            List<String> upDetailCodes = subComActivityDesignDetailVoList.stream().filter(d -> RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(d.getAssociationType())).map(SubComActivityDesignDetailVo::getActivityDesignDetailCode).distinct().collect(Collectors.toList());
            if (!org.springframework.util.CollectionUtils.isEmpty(upDetailCodes) && !org.springframework.util.CollectionUtils.isEmpty(budgetVoMap)) {
                for (String key : budgetVoMap.keySet()) {
                    List<SubComActivityDesignBudgetVo> subComActivityDesignBudgetVos = budgetVoMap.get(key);
                    if (!org.springframework.util.CollectionUtils.isEmpty(subComActivityDesignBudgetVos)) {
                        List<String> mainBudgetItemCodes = subComActivityDesignBudgetVos.stream().filter(s -> !FeeSourceEnum.AUTO_FEE.getCode().equals(s.getFeeSourceCode())).map(SubComActivityDesignBudgetVo::getBudgetItemCode).distinct().collect(Collectors.toList());
                        mainBudgetItemCodeSet.addAll(mainBudgetItemCodes);
                    }
                }
                List<BudgetItemMainItemVo> budgetItemMainItemVos = budgetItemMainItemService.listByMainBudgetItemCodeList(com.google.common.collect.Lists.newArrayList(mainBudgetItemCodeSet));
                if (!org.springframework.util.CollectionUtils.isEmpty(budgetItemMainItemVos)) {
                    budgetItemMainItemMap = budgetItemMainItemVos.stream().collect(Collectors.toMap(BudgetItemMainItemVo::getMainBudgetItemCode, Function.identity(), (v1, v2) -> v2));
                }
            }

            for (CostCollectVo costCollectVo : activityPlanTableVo.getCostCollectList()) {
                SubComActivityDesignDetailVo subComActivityDesignDetailVo = subComActivityDesignDetailVoMap.get(costCollectVo.getActivityDesignDetailCode());
                BeanUtils.copyProperties(subComActivityDesignDetailVo,costCollectVo);

                //费销比 = 费用合计/期间促销额
                if (null != costCollectVo.getPromotionAmount() && BigDecimal.ZERO.compareTo(costCollectVo.getPromotionAmount()) != 0){
                    costCollectVo.setCostSaleRate(Optional.ofNullable(costCollectVo.getTotalCost()).orElse(BigDecimal.ZERO).divide(costCollectVo.getPromotionAmount(),4,BigDecimal.ROUND_DOWN));
                }

                if (!org.springframework.util.CollectionUtils.isEmpty(budgetVoMap)) {
                    List<SubComActivityDesignBudgetVo> budgetVos = budgetVoMap.get(costCollectVo.getActivityDesignDetailCode());
                    if (!org.springframework.util.CollectionUtils.isEmpty(budgetVos)) {
                        for (SubComActivityDesignBudgetVo budget : budgetVos) {
                            //"关联向上分子细案“类型，预算编码需要转换下。（表中存的是主体预算项目编码，转为对应分子预算项目编码）
                            if (RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(costCollectVo.getAssociationType()) && !org.springframework.util.CollectionUtils.isEmpty(budgetItemMainItemMap)) {
                                if (FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(budget.getFeeSourceCode())) {
                                    BudgetItemMainItemVo budgetItemMainItemVo = budgetItemMainItemMap.get(budget.getBudgetItemCode());
                                    if (!Objects.isNull(budgetItemMainItemVo)) {
                                        costCollectVo.setInPointBudgetItemCode(budgetItemMainItemVo.getBudgetItemCode());
                                        costCollectVo.setInternalPointFee(budget.getBudgetAmount());
                                    }
                                }
                                if (FeeSourceEnum.OFF_POINT_FEE.getCode().equals(budget.getFeeSourceCode())) {
                                    BudgetItemMainItemVo budgetItemMainItemVo = budgetItemMainItemMap.get(budget.getBudgetItemCode());
                                    if (!Objects.isNull(budgetItemMainItemVo)) {
                                        costCollectVo.setOffPointBudgetItemCode(budgetItemMainItemVo.getBudgetItemCode());
                                        costCollectVo.setOffPointFee(budget.getBudgetAmount());
                                    }
                                }

                            }else {
                                if (FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(budget.getFeeSourceCode())) {
                                    costCollectVo.setInPointBudgetItemCode(budget.getBudgetItemCode());
                                    costCollectVo.setInternalPointFee(budget.getBudgetAmount());
                                }
                                if (FeeSourceEnum.OFF_POINT_FEE.getCode().equals(budget.getFeeSourceCode())) {
                                    costCollectVo.setOffPointBudgetItemCode(budget.getBudgetItemCode());
                                    costCollectVo.setOffPointFee(budget.getBudgetAmount());
                                }
                            }

                            if (FeeSourceEnum.AUTO_FEE.getCode().equals(budget.getFeeSourceCode())) {
                                costCollectVo.setAutoBudgetItemCode(budget.getBudgetItemCode());
                                costCollectVo.setAutoFee(budget.getBudgetAmount());
                            }
                        }
                    }
                }
//                总部支持金额=点内+点外
//                公司自投=自投金额
                costCollectVo.setHeadquartersSupportedAmount(Optional.ofNullable(costCollectVo.getOffPointFee()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(costCollectVo.getInternalPointFee()).orElse(BigDecimal.ZERO)));
                costCollectVo.setSubComAutoAmount(costCollectVo.getAutoAmount());
                //大日期剩余天数
                if (null != costCollectVo.getProductExpirationDate() && !StringUtils.isEmpty(costCollectVo.getBigDateNo())){
                    try {
                        Date bigDate = dayFormat.parse(costCollectVo.getBigDateNo());
                        long distanceDay = DateUtil.getDistanceDay(curDate.getTime()/1000, bigDate.getTime()/1000);
                        if (curDate.after(bigDate)){
                            costCollectVo.setBigDateRemainDay(- (int) distanceDay);
                        }else{
                            costCollectVo.setBigDateRemainDay((int) distanceDay);
                        }
                        //大日期剩余天数=大日期批次+产品保质期-当天时间
                        costCollectVo.setBigDateRemainDay(costCollectVo.getBigDateRemainDay() + costCollectVo.getProductExpirationDate());
                    }catch (Exception e){
                        log.error("大日期剩余天数处理失败",e);
                    }
                }
            }
        }
    }

    private List<PutOutputRatioVo>  withOutCustomer(List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoListl) {
        if(CollectionUtils.isEmpty(subComActivityDesignDetailVoListl)) {
            return Lists.newArrayList();
        }
        //找出客户为空的活动明细
        List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList = subComActivityDesignDetailVoListl.stream().filter(item -> StringUtils.isBlank(item.getCustomerCode())).collect(Collectors.toList());
        List<PutOutputRatioVo> putOutputRatioVoList = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(subComActivityDesignDetailVoList)){
            Map<String, List<SubComActivityDesignDetailVo>> subComActivityDesignDetailVoMap = subComActivityDesignDetailVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getOrgCode()).orElse("") +""+ Optional.ofNullable(item.getActivityTypeCode()).orElse("")));
            subComActivityDesignDetailVoMap.forEach((key, value)->{
                Map<String, SubComActivityDesignDetailVo> value2 = value.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity(), (o, n) -> o));
                SubComActivityDesignDetailVo subComActivityDesignDetailVo = value.get(0);
                PutOutputRatioVo putOutputRatioVo = this.nebulaToolkitService.copyObjectByWhiteList(subComActivityDesignDetailVo, PutOutputRatioVo.class, null, null);
                putOutputRatioVo.setTotalCost(value2.values().stream().map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setOffAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getOffAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setInternalAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getInternalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setAutoAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getAutoAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));

                putOutputRatioVoList.add(putOutputRatioVo);
            });
            return putOutputRatioVoList;
        }
        return new ArrayList<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(ActivityPlanTableDto dto) {
        Validate.notNull(dto,"输入参数不能为空");
        Validate.notBlank(dto.getOrgCode(),"组织编码不能为空");
        Validate.notBlank(dto.getYearAndMonth(),"年月不能为空");
        try {
            if (redisLockService.tryLock(ActivityPlanTableConstants.ACTIVITY_PLAN_TABLE_REDIS_LOCK_KEY, TimeUnit.SECONDS, 10)) {
//                String ruleCode = ActivityPlanTableConstants.ACTIVITY_PLAN_TABLE_CODE + DateFormatUtils.format(new Date(), "yyyyMM");

                dto.setActivityPlanTableCode(generateCodeService.generateCode(ActivityPlanTableConstants.ACTIVITY_PLAN_TABLE_CODE, 1, 10, 30, TimeUnit.DAYS).get(0));
                List<ActivityPlanTable> list = this.activityPlanTableRepository.lambdaQuery().eq(ActivityPlanTable::getOrgCode, dto.getOrgCode())
                        .eq(ActivityPlanTable::getYearAndMonth, dto.getYearAndMonth())
                        .eq(ActivityPlanTable::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
                if (CollectionUtils.isEmpty(list)) {
                    ActivityPlanTable activityPlanTable = this.nebulaToolkitService.copyObjectByWhiteList(dto, ActivityPlanTable.class, null, null);
                    activityPlanTable.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                    activityPlanTable.setTableVersion(TableVersionEnum.ACTUAL_TIME_VERSION.getCode());
                    activityPlanTableRepository.save(activityPlanTable);
                    activityPlanTable.setId(null);
                    activityPlanTable.setTableVersion(TableVersionEnum.PROCESS_COMMIT_VERSION.getCode());
                    activityPlanTable.setActivityPlanTableCode(generateCodeService.generateCode(ActivityPlanTableConstants.ACTIVITY_PLAN_TABLE_CODE, 1, 10, 30, TimeUnit.DAYS).get(0));
                    activityPlanTableRepository.save(activityPlanTable);
                }
            }
        }finally {
            if(redisLockService.isLock(ActivityPlanTableConstants.ACTIVITY_PLAN_TABLE_REDIS_LOCK_KEY)){
                redisLockService.unlock(ActivityPlanTableConstants.ACTIVITY_PLAN_TABLE_REDIS_LOCK_KEY);
            }
        }
    }

    @Override
    public List<ActivityPlanTableVo> listByCondition(ActivityPlanTableDto dto) {
        List<ActivityPlanTable> activityPlanTables = this.activityPlanTableRepository.listByCondition(dto);
        if(CollectionUtils.isEmpty(activityPlanTables)){
            return new ArrayList<>();
        }
        Collection<ActivityPlanTableVo> activityPlanTableVos = this.nebulaToolkitService.copyCollectionByBlankList(activityPlanTables, ActivityPlanTable.class, ActivityPlanTableVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<ActivityPlanTableVo>) activityPlanTableVos;
    }

    @Override
    @Transactional
    public List<String> batchSubmitApproval(ActivityPlanTableBatchSubmitApprovalDto dto) {
        Validate.isTrue(Objects.nonNull(dto),"输入参数不能为空");
        List<String> ids = dto.getIds();
        Validate.isTrue(CollectionUtils.isNotEmpty(ids),"输入id不能为空");
        Validate.isTrue(ids.size()==1,"只能单条审批");
        List<ActivityPlanTable> activityPlanTables = this.activityPlanTableRepository.listByIds(ids);
        Validate.isTrue(CollectionUtils.isNotEmpty(activityPlanTables),"未查询到对应的数据");
        Collection<ActivityPlanTableDto> activityPlanTableDtos = this.nebulaToolkitService.copyCollectionByBlankList(activityPlanTables, ActivityPlanTable.class, ActivityPlanTableDto.class, LinkedHashSet.class, ArrayList.class);
        List<String> processNoList = Lists.newArrayList();
        activityPlanTableDtos.forEach(item->{
            String processNo = submitApproval(item,dto.getProcessBusiness());
            processNoList.add(processNo);
        });
        return processNoList;
    }

    @Override
    public void generateData(String id) {
        List<ActivityPlanTable> activityPlanTables = this.activityPlanTableRepository.listByIds(Arrays.asList(id), DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(activityPlanTables)) {
            return;
        }
        ActivityPlanTable activityPlanTable = activityPlanTables.get(0);
        Validate.isTrue(ProcessStatusEnum.PASS.getDictCode().equals(activityPlanTable.getProcessStatus()), "只有审批通过的套表能生成数据！");
        Validate.isTrue(!BooleanEnum.TRUE.getCapital().equals(activityPlanTable.getGenerateStatus()), "当前数据已经生成了对应分子公司预算、细案，请勿重复点击！");
        subComActivityDesignService.passBatch(activityPlanTable.getProcessNo(), id);
    }

    private static final String PARENT_CODE = "CRM202211221669085054";

    @Override
    public ActivityPlanTableVo download(String id, HttpServletResponse response) throws IOException {
        ActivityPlanTableVo resultVo = this.getById(id,null);

        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        // 这里URLEncoder.encode可以防止中文乱码 当然和easyexcel没有关系
        String fileName = URLEncoder.encode("活动规划套表"+resultVo.getOrgName()+resultVo.getYearAndMonth(), "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");

        ExcelWriter excelWriter = EasyExcel.write(response.getOutputStream()).autoCloseStream(Boolean.FALSE).build();
        for (int i = 0; i < 7; i++) {
            ExcelWriterSheetBuilder excelWriterSheetBuilder = EasyExcel.writerSheet(i, SheetNameEnum.getName(i));
            //利润计算需要动态拼接表
            if(i==0){
                List<OnceAbsoluteMergeStrategy> mergeStrategyList = getMergeStrategy(resultVo.getActivityPlanProfitList());
                excelWriterSheetBuilder = excelWriterSheetBuilder.head(getProfitHead(resultVo.getActivityPlanProfitList()));
                for (OnceAbsoluteMergeStrategy onceAbsoluteMergeStrategy : mergeStrategyList) {
                    excelWriterSheetBuilder = excelWriterSheetBuilder.registerWriteHandler(onceAbsoluteMergeStrategy);
                }
                WriteSheet writeSheet = excelWriterSheetBuilder.build();
                excelWriter.write(getProfitData(resultVo.getActivityPlanProfitList()),writeSheet);
            }else {
                List<ColumnConfigVo> column = columnConfigVoService.findByParentCodeAndFunctionCodeOrderByFormorder(PARENT_CODE, SheetNameEnum.getFunctionCode(i));
                List<ColumnConfigVo> visibleColumnList = column.stream().filter(ColumnConfigVo::getVisible)
                        .sorted(Comparator.comparing(item -> Integer.valueOf(Optional.ofNullable(item.getFormorder()).orElse("99"))))
                        .collect(Collectors.toList());
                List<List<String>> headList = visibleColumnList.stream().map(item -> Lists.newArrayList(item.getTitle())).collect(Collectors.toList());
                excelWriterSheetBuilder = excelWriterSheetBuilder.head(headList);
                WriteSheet writeSheet = excelWriterSheetBuilder.build();
                excelWriter.write(getData(i,resultVo,visibleColumnList),writeSheet);
            }
        }

        excelWriter.finish();
        return resultVo;
    }

    @Override
    public Page<PutOutputRatioVo> findPutOutputRatioByConditions(Pageable pageable, ActivityPlanTableDto dto) {

        ActivityPlanTableVo byId = this.getById(dto.getId(),SheetNameEnum.PUT_OUTPUT_RATIO);

        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));

        Page<PutOutputRatioVo> page = new Page<>(pageable.getPageNumber(),pageable.getPageSize());
        List<PutOutputRatioVo> putOutputRatioList = byId.getPutOutputRatioList();
        if(CollectionUtils.isNotEmpty(putOutputRatioList)){
            List<PutOutputRatioVo> limit = putOutputRatioList.stream().skip((page.getCurrent() - 1) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
            page.setRecords(limit);
            page.setTotal(putOutputRatioList.size());
        }
        return page;
    }

    @Override
    public Page<PutOutputRatioCustomerVo> findPutOutputRatioCustomerByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        log.info("分页查询投入产出比（客户），参数{}", JSONObject.toJSONString(dto));
        ActivityPlanTableVo byId = this.getById(dto.getId(),SheetNameEnum.PUT_OUTPUT_RATIO);

        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));

        Page<PutOutputRatioCustomerVo> page = new Page<>(pageable.getPageNumber(),pageable.getPageSize());
        List<PutOutputRatioCustomerVo> putOutputRatioList = byId.getPutOutputRatioCustomerList();
        if(CollectionUtils.isNotEmpty(putOutputRatioList)){
            List<PutOutputRatioCustomerVo> limit = putOutputRatioList.stream().skip((page.getCurrent() - 1) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
            page.setRecords(limit);
            page.setTotal(putOutputRatioList.size());
        }
        return page;
    }

    @Override
    public Page<SaleForecastVo> findSaleForecastByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        ActivityPlanTableVo byId = this.getById(dto.getId(),SheetNameEnum.SALE_FORECAST);

        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));

        Page<SaleForecastVo> page = new Page<>(pageable.getPageNumber(),pageable.getPageSize());
        List<SaleForecastVo> saleForecastList = byId.getSaleForecastList();
        if(CollectionUtils.isNotEmpty(saleForecastList)){
            List<SaleForecastVo> limit = saleForecastList.stream().skip((page.getCurrent() - 1) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
            page.setRecords(limit);
            page.setTotal(saleForecastList.size());
        }
        return page;
    }

    @Override
    public Page<CostCollectVo> findCostCollectByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        ActivityPlanTableVo byId = this.getById(dto.getId(),SheetNameEnum.COST_COLLECT);

        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));

        Page<CostCollectVo> page = new Page<>(pageable.getPageNumber(),pageable.getPageSize());
        List<CostCollectVo> costCollectList = byId.getCostCollectList();
        if(CollectionUtils.isNotEmpty(costCollectList)){
            List<CostCollectVo> limit = costCollectList.stream().skip((page.getCurrent() - 1) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
            page.setRecords(limit);
            page.setTotal(costCollectList.size());
        }
        return page;
    }

    @Override
    public Page<ReferendumCostVo> findReferendumCostByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        ActivityPlanTableVo byId = this.getById(dto.getId(),SheetNameEnum.REFERENDUM_COST);

        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));

        Page<ReferendumCostVo> page = new Page<>(pageable.getPageNumber(),pageable.getPageSize());
        List<ReferendumCostVo> referendumCostList = byId.getReferendumCostList();
        if(CollectionUtils.isNotEmpty(referendumCostList)){
            List<ReferendumCostVo> limit = referendumCostList.stream().skip((page.getCurrent() - 1) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
            page.setRecords(limit);
            page.setTotal(referendumCostList.size());
        }
        return page;
    }

    @Override
    public Page<FinalFixedExpenseVo> findFinalFixedExpenseByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        ActivityPlanTableVo byId = this.getById(dto.getId(),SheetNameEnum.FINAL_FIXED_EXPENSE);

        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));

        Page<FinalFixedExpenseVo> page = new Page<>(pageable.getPageNumber(),pageable.getPageSize());
        List<FinalFixedExpenseVo> fixedExpenseVos = byId.getFixedExpenseList();
        if(CollectionUtils.isNotEmpty(fixedExpenseVos)){
            List<FinalFixedExpenseVo> limit = fixedExpenseVos.stream().skip((page.getCurrent() - 1) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
            page.setRecords(limit);
            page.setTotal(fixedExpenseVos.size());
        }
        return page;
    }

    @Override
    public Page<PriceVo> findPriceByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        ActivityPlanTableVo byId = this.getById(dto.getId(),SheetNameEnum.PRICE);

        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));

        Page<PriceVo> page = new Page<>(pageable.getPageNumber(),pageable.getPageSize());
        List<PriceVo> priceList = byId.getPriceList();
        if(CollectionUtils.isNotEmpty(priceList)){
            List<PriceVo> limit = priceList.stream().skip((page.getCurrent() - 1) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
            //对当前页数据获取活动最低价
            loadActivityLowerPrice(byId,limit);
            page.setRecords(limit);
            page.setTotal(priceList.size());
        }
        return page;
    }

    private void loadActivityLowerPrice(ActivityPlanTableVo byId,List<PriceVo> limit){
        for(PriceVo priceVo : limit){
            SubComActivityDesignDetailVo designDetailVo = new SubComActivityDesignDetailVo();
            designDetailVo.setCustomerCode(priceVo.getCustomerCode());
            designDetailVo.setOrgCode(priceVo.getOrgCode());
            designDetailVo.setProductCode(priceVo.getApportionProductCode());
            designDetailVo.setActivityBeginTimeStart(byId.getYearAndMonth() + "-01");
            designDetailVo.setActivityBeginTimeEnd(DateUtil.format(DateUtil.dateAddMonth(DateUtil.parse(byId.getYearAndMonth() + "-01",DateUtil.DEFAULT_YEAR_MONTH_DAY), 1), DateUtil.DEFAULT_YEAR_MONTH_DAY));
            priceVo.setActivityLowestPrice(subComActivityDesignDetailService.findActivityLowestPrice(designDetailVo));
            if (priceVo.getActivityLowestPrice() == null) {
                priceVo.setActivityLowestPrice(BigDecimal.ZERO);
            }
        }
    }

    @Override
    public void updateGenerateStatus(String tableId) {
        Validate.notEmpty(tableId, "要更新的数据不能为空！");
        List<ActivityPlanTable> activityPlanTables = this.activityPlanTableRepository.listByIds(Arrays.asList(tableId), DelFlagStatusEnum.NORMAL.getCode());
        activityPlanTables.forEach(activityPlanTable -> {
            activityPlanTable.setGenerateStatus(BooleanEnum.TRUE.getCapital());
        });
        this.activityPlanTableRepository.updateBatchById(activityPlanTables);
    }

    private List<OnceAbsoluteMergeStrategy> getMergeStrategy(List<ActivityPlanProfitVo> activityPlanProfitList) {
        List<OnceAbsoluteMergeStrategy> onceAbsoluteMergeStrategyList = new ArrayList<>();
//        //项目名称
//        OnceAbsoluteMergeStrategy mergeStrategy1 = new OnceAbsoluteMergeStrategy(0, 0, 0, 2);
//        onceAbsoluteMergeStrategyList.add(mergeStrategy1);
        //出库件数
        OnceAbsoluteMergeStrategy mergeStrategy2 = new OnceAbsoluteMergeStrategy(1, 1, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy2);

        //折前收入
        OnceAbsoluteMergeStrategy mergeStrategy3 = new OnceAbsoluteMergeStrategy(2, 2, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy3);
        //折前成本
        OnceAbsoluteMergeStrategy mergeStrategy4 = new OnceAbsoluteMergeStrategy(3, 3, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy4);
        //折后收入
        OnceAbsoluteMergeStrategy mergeStrategy5 = new OnceAbsoluteMergeStrategy(4, 4, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy5);
        //销量占比
        OnceAbsoluteMergeStrategy mergeStrategy6 = new OnceAbsoluteMergeStrategy(5, 5, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy6);
        //理论毛利额
        OnceAbsoluteMergeStrategy mergeStrategy7 = new OnceAbsoluteMergeStrategy(6, 6, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy7);
        //理论毛利率
        OnceAbsoluteMergeStrategy mergeStrategy8 = new OnceAbsoluteMergeStrategy(7, 7, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy8);
        //税金及附加
        OnceAbsoluteMergeStrategy mergeStrategy9 = new OnceAbsoluteMergeStrategy(8, 8, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy9);

        int specialCostCount = getSpecialCostTotalRow(activityPlanProfitList);
        int fixedExpenseCount = getFixedExpenseTotalRow(activityPlanProfitList);
        if(specialCostCount>0 && fixedExpenseCount>0){
            //整体向下支出
            OnceAbsoluteMergeStrategy mergeStrategy10 = new OnceAbsoluteMergeStrategy(9, 9+specialCostCount+fixedExpenseCount+1, 0, 0);
            onceAbsoluteMergeStrategyList.add(mergeStrategy10);
        }
        //专项费用
        if(specialCostCount>0) {
            OnceAbsoluteMergeStrategy mergeStrategy101 = new OnceAbsoluteMergeStrategy(9, 9+specialCostCount, 1, 1);
            onceAbsoluteMergeStrategyList.add(mergeStrategy101);
        }

        //固定支出
        if(fixedExpenseCount>1) {
            OnceAbsoluteMergeStrategy mergeStrategy103 = new OnceAbsoluteMergeStrategy(9 + specialCostCount + 1, 9 + specialCostCount + 1 + fixedExpenseCount, 1, 1);
            onceAbsoluteMergeStrategyList.add(mergeStrategy103);
        }

        //总部支持
        OnceAbsoluteMergeStrategy mergeStrategy11 = new OnceAbsoluteMergeStrategy(11+specialCostCount+fixedExpenseCount, 11+specialCostCount+fixedExpenseCount+5, 0, 0);
        onceAbsoluteMergeStrategyList.add(mergeStrategy11);
        OnceAbsoluteMergeStrategy mergeStrategy11_0 = new OnceAbsoluteMergeStrategy(11+specialCostCount+fixedExpenseCount, 11+specialCostCount+fixedExpenseCount, 1, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy11_0);
        OnceAbsoluteMergeStrategy mergeStrategy11_1 = new OnceAbsoluteMergeStrategy(11+specialCostCount+fixedExpenseCount+1, 11+specialCostCount+fixedExpenseCount+1, 1, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy11_1);
        OnceAbsoluteMergeStrategy mergeStrategy11_2 = new OnceAbsoluteMergeStrategy(11+specialCostCount+fixedExpenseCount+2, 11+specialCostCount+fixedExpenseCount+2, 1, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy11_2);
        OnceAbsoluteMergeStrategy mergeStrategy11_3 = new OnceAbsoluteMergeStrategy(11+specialCostCount+fixedExpenseCount+3, 11+specialCostCount+fixedExpenseCount+3, 1, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy11_3);
        OnceAbsoluteMergeStrategy mergeStrategy11_4 = new OnceAbsoluteMergeStrategy(11+specialCostCount+fixedExpenseCount+4, 11+specialCostCount+fixedExpenseCount+4, 1, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy11_4);
        OnceAbsoluteMergeStrategy mergeStrategy11_5 = new OnceAbsoluteMergeStrategy(11+specialCostCount+fixedExpenseCount+5, 11+specialCostCount+fixedExpenseCount+5, 1, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy11_5);

        //利润额
        OnceAbsoluteMergeStrategy mergeStrategy12 = new OnceAbsoluteMergeStrategy(17+specialCostCount+fixedExpenseCount, 17+specialCostCount+fixedExpenseCount, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy12);
        //产品促销费用率
        OnceAbsoluteMergeStrategy mergeStrategy13 = new OnceAbsoluteMergeStrategy(18+specialCostCount+fixedExpenseCount, 18+specialCostCount+fixedExpenseCount, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy13);
        //其他费用率
        OnceAbsoluteMergeStrategy mergeStrategy14 = new OnceAbsoluteMergeStrategy(19+specialCostCount+fixedExpenseCount, 19+specialCostCount+fixedExpenseCount, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy14);
        //专项费用率
        OnceAbsoluteMergeStrategy mergeStrategy15 = new OnceAbsoluteMergeStrategy(20+specialCostCount+fixedExpenseCount, 20+specialCostCount+fixedExpenseCount, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy15);
        //固定支出费用率
        OnceAbsoluteMergeStrategy mergeStrategy16 = new OnceAbsoluteMergeStrategy(21+specialCostCount+fixedExpenseCount, 21+specialCostCount+fixedExpenseCount, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy16);
        //整体费用率
        OnceAbsoluteMergeStrategy mergeStrategy17 = new OnceAbsoluteMergeStrategy(22+specialCostCount+fixedExpenseCount, 22+specialCostCount+fixedExpenseCount, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy17);


        return onceAbsoluteMergeStrategyList;
    }

    private int getFixedExpenseTotalRow(List<ActivityPlanProfitVo> activityPlanProfitList) {
        if(CollectionUtils.isNotEmpty(activityPlanProfitList)){
            Set<String> rows = new HashSet<>();
            for (ActivityPlanProfitVo activityPlanProfitVo : activityPlanProfitList) {
                if(activityPlanProfitVo.getIsTotal()){
                    continue;
                }
                List<FixedExpenseVo> fixedExpenseList = activityPlanProfitVo.getFixedExpenseList();
                if(CollectionUtils.isNotEmpty(fixedExpenseList)) {
                    for (FixedExpenseVo fixedExpenseVo : fixedExpenseList) {
                        if(fixedExpenseVo.getIsTotal()){
                            continue;
                        }
                        rows.add(fixedExpenseVo.getBudgetSortCode());
                    }
                }
            }
            return rows.size();
        }
        return 0;
    }

    private int getSpecialCostTotalRow(List<ActivityPlanProfitVo> activityPlanProfitList) {
        if(CollectionUtils.isNotEmpty(activityPlanProfitList)){
            Set<String> rows = new HashSet<>();
            for (ActivityPlanProfitVo activityPlanProfitVo : activityPlanProfitList) {
                if(activityPlanProfitVo.getIsTotal()){
                    continue;
                }
                List<SpecialCostVo> specialCostList = activityPlanProfitVo.getSpecialCostList();
                if(CollectionUtils.isNotEmpty(specialCostList)) {
                    for (SpecialCostVo specialCostVo : specialCostList) {
                        if(specialCostVo.getIsTotal()){
                            continue;
                        }
                        rows.add(specialCostVo.getActivityTypeCode());
                    }
                }
            }
            return rows.size();
        }
        return 0;
    }

    private List<List<String>> getProfitHead(List<ActivityPlanProfitVo> activityPlanProfitList) {
        ArrayList<List<String>> list = ListUtils.newArrayList();
        List<String> head0 = ListUtils.newArrayList();
        head0.add("项目名称");
        list.add(head0);
        List<String> head1 = ListUtils.newArrayList();
        head1.add("项目名称");
        list.add(head1);
        List<String> head2 = ListUtils.newArrayList();
        head2.add("项目名称");
        list.add(head2);
        List<ActivityPlanProfitVo> collect = activityPlanProfitList.stream().sorted(Comparator.comparing(ActivityPlanProfitVo::getIsTotal)).collect(Collectors.toList());
        for (ActivityPlanProfitVo activityPlanProfitVo : collect) {
            List<String> head = ListUtils.newArrayList();
            head.add(activityPlanProfitVo.getIsTotal()?"合计":activityPlanProfitVo.getCustomerChannelName());
            list.add(head);
        }
        return list;
    }

    /**
     * 整合数据
     * @param i
     * @param resultVo
     * @return
     */
    private Collection<?> getData(int i, ActivityPlanTableVo resultVo,List<ColumnConfigVo> columnConfigVos) {
       if ( i==1 ) {//投入产出比
            List<PutOutputRatioVo> putOutputRatioList = resultVo.getPutOutputRatioList();
            if(CollectionUtils.isNotEmpty(putOutputRatioList)){
                return findExportData(putOutputRatioList,columnConfigVos);
            }
        } else if (i == 2) {//销售预测
            List<SaleForecastVo> saleForecastList = resultVo.getSaleForecastList();
            if(CollectionUtils.isNotEmpty(saleForecastList)){
                return findExportData(saleForecastList,columnConfigVos);
            }
        } else if (i == 3) {//费用汇总
            List<CostCollectVo> costCollectList = resultVo.getCostCollectList();
            if(CollectionUtils.isNotEmpty(costCollectList)){
                return findExportData(costCollectList,columnConfigVos);
            }
        } else if (i == 4) {//公投费用
            List<ReferendumCostVo> referendumCostList = resultVo.getReferendumCostList();
            if(CollectionUtils.isNotEmpty(referendumCostList)){
                return findExportData(referendumCostList,columnConfigVos);
            }
        } else if (i == 5) {//固定支出
            List<FinalFixedExpenseVo> fixedExpenseList = resultVo.getFixedExpenseList();
            if(CollectionUtils.isNotEmpty(fixedExpenseList)){
                return findExportData(fixedExpenseList,columnConfigVos);
            }
        } else if (i == 6) {//价格
            List<PriceVo> priceList = resultVo.getPriceList();
            if(CollectionUtils.isNotEmpty(priceList)){
                loadActivityLowerPrice(resultVo,priceList);
                return findExportData(priceList,columnConfigVos);
            }
        }
        return null;
    }

    private Collection<?> findExportData(Collection<?> data,List<ColumnConfigVo> columnConfigVos){
        List<List<Object>> list = Lists.newLinkedList();
        List<String> dictCodeList = columnConfigVos.stream().map(ColumnConfigVo::getDictCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        Map<String, Map<String, String>> dictMapMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(dictCodeList)){
            Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodeList);
            dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue,(o,n)->n)),(o,n)->n));
        }
        SimpleDateFormat dayFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH);
        for (Object o : data) {
            cn.hutool.json.JSONObject obj = JSONUtil.parseObj(o);
            List<Object> cur = Lists.newLinkedList();
            for (ColumnConfigVo columnConfigVo : columnConfigVos) {
                String fieldName = columnConfigVo.getField();
                Object objectValue = obj.getOrDefault(fieldName, null);
                if (null != objectValue){
                    if (StringUtils.isNotEmpty(columnConfigVo.getDictCode())){
                        Map<String, String> columnDictMap = dictMapMap.get(columnConfigVo.getDictCode());
                        if (null != columnDictMap){
                            String objectStrValue = objectValue.toString();
                            objectValue = columnDictMap.getOrDefault(objectStrValue, objectStrValue);
                        }
                    }else if (objectValue instanceof Date){
                        if (columnConfigVo.getField().equals("feeYearMonth") ){
                            objectValue = yearMonthFormat.format((Date)objectValue);
                        }else{
                            objectValue = dayFormat.format((Date)objectValue);
                        }
                    }
                }
                cur.add(objectValue);
            }
            list.add(cur);
        }
        return list;
    }

    /**
     * 利润测算的数据
     * @param activityPlanProfitList
     * @return
     */
    private Collection<?> getProfitData(List<ActivityPlanProfitVo> activityPlanProfitList) {

        List<List<Object>> dataList = new ArrayList<>();
        activityPlanProfitList = activityPlanProfitList.stream().sorted(Comparator.comparing(ActivityPlanProfitVo::getIsTotal)).collect(Collectors.toList());

//        int specialCostRow = getSpecialCostTotalRow(activityPlanProfitList);
        Map<String,String> specialCostMap = getSpecialCostMap(activityPlanProfitList);

//        int fixedExpenseRow = getFixedExpenseTotalRow(activityPlanProfitList);
        Map<String,String> fixedExpenseMap = getFixedExpenseMap(activityPlanProfitList);

        //出库件数
        List<Object> data1 = ListUtils.newArrayList();
        data1.add("出库件数");
        data1.add("出库件数");
        data1.add("出库件数");

        //折前收入
        List<Object> data2 = ListUtils.newArrayList();
        data2.add("折前收入");
        data2.add("折前收入");
        data2.add("折前收入");

        //折前成本
        List<Object> data3 = ListUtils.newArrayList();
        data3.add("折前成本");
        data3.add("折前成本");
        data3.add("折前成本");

        //折后收入
        List<Object> data4 = ListUtils.newArrayList();
        data4.add("折后收入");
        data4.add("折后收入");
        data4.add("折后收入");

        //销量占比
        List<Object> data5 = ListUtils.newArrayList();
        data5.add("销量占比");
        data5.add("销量占比");
        data5.add("销量占比");

        //理论毛利额
        List<Object> data6 = ListUtils.newArrayList();
        data6.add("理论毛利额");
        data6.add("理论毛利额");
        data6.add("理论毛利额");

        //理论毛利率
        List<Object> data7 = ListUtils.newArrayList();
        data7.add("理论毛利率");
        data7.add("理论毛利率");
        data7.add("理论毛利率");

        //税金及附加
        List<Object> data8 = ListUtils.newArrayList();
        data8.add("税金及附加");
        data8.add("税金及附加");
        data8.add("税金及附加");

        //整体向下支出-专项费用
        Map<String,List<Object>> specialCostDataMap = new HashMap();
        for (Map.Entry<String, String> one : specialCostMap.entrySet()) {
            List<Object> specialCostDataList = ListUtils.newArrayList();
            specialCostDataList.add("整体向下支出");
            specialCostDataList.add("专项费用");
            specialCostDataList.add(one.getValue());
            specialCostDataMap.put(one.getKey(),specialCostDataList);
        }
        List<Object> data81 = ListUtils.newArrayList();
        if (specialCostMap.size() > 0){
            //整体向下支出-专项费用-小计
            data81.add("整体向下支出");
            data81.add("专项费用");
            data81.add("小计");
        }

        //整体向下支出-固定支出
        Map<String,List<Object>> fixedExpenseDataMap = new HashMap<>();
        for (Map.Entry<String, String> one : fixedExpenseMap.entrySet()) {
            List<Object> fixedExpenseDataList = ListUtils.newArrayList();
            fixedExpenseDataList.add("整体向下支出");
            fixedExpenseDataList.add("固定支出");
            fixedExpenseDataList.add(one.getValue());
            fixedExpenseDataMap.put(one.getKey(),fixedExpenseDataList);
        }

        List<Object> data82 = ListUtils.newArrayList();
        if (fixedExpenseMap.size() > 0){
            //整体向下支出-固定支出-小计
            data82.add("整体向下支出");
            data82.add("固定支出");
            data82.add("小计");
        }


        //点内费用
        List<Object> data9 = ListUtils.newArrayList();
        data9.add("总部支持");
        data9.add("点内费用");
        data9.add("点内费用");

        //点外费用
        List<Object> data10 = ListUtils.newArrayList();
        data10.add("总部支持");
        data10.add("点外费用");
        data10.add("点外费用");

        //点数内费率
        List<Object> data91 = ListUtils.newArrayList();
        data91.add("总部支持");
        data91.add("点数内费率");
        data91.add("点数内费率");

        //点数外费率
        List<Object> data101 = ListUtils.newArrayList();
        data101.add("总部支持");
        data101.add("点数外费率");
        data101.add("点数外费率");

        //总部考核
        List<Object> data11 = ListUtils.newArrayList();
        data11.add("总部支持");
        data11.add("总部考核");
        data11.add("总部考核");

        //总部支出-小计
        List<Object> data12 = ListUtils.newArrayList();
        data12.add("总部支持");
        data12.add("小计");
        data12.add("小计");

        //利润额
        List<Object> data13 = ListUtils.newArrayList();
        data13.add("利润额");
        data13.add("利润额");
        data13.add("利润额");

        //产品促销费用率
        List<Object> data14 = ListUtils.newArrayList();
        data14.add("产品促销费用率");
        data14.add("产品促销费用率");
        data14.add("产品促销费用率");

        //其他费用率
        List<Object> data15 = ListUtils.newArrayList();
        data15.add("其他费用率");
        data15.add("其他费用率");
        data15.add("其他费用率");

        //专项费用率
        List<Object> data16 = ListUtils.newArrayList();
        data16.add("专项费用率");
        data16.add("专项费用率");
        data16.add("专项费用率");

        //固定支出费用率
        List<Object> data17 = ListUtils.newArrayList();
        data17.add("固定支出费用率");
        data17.add("固定支出费用率");
        data17.add("固定支出费用率");

        //整体费用率
        List<Object> data18 = ListUtils.newArrayList();
        data18.add("整体费用率");
        data18.add("整体费用率");
        data18.add("整体费用率");



        for (int i = 0; i < activityPlanProfitList.size(); i++) {
            ActivityPlanProfitVo activityPlanProfitVo = activityPlanProfitList.get(i);
            data1.add(activityPlanProfitVo.getOutStorageQuantity());
            data2.add(activityPlanProfitVo.getBeforeDiscountIncome());
            data3.add(activityPlanProfitVo.getBeforeDiscountCost());
            data4.add(activityPlanProfitVo.getAfterDiscountIncome());
            data5.add(activityPlanProfitVo.getSaleQuantityRatio());
            data6.add(activityPlanProfitVo.getTheoryGrossMarginAmount());
            data7.add(activityPlanProfitVo.getTheoryGrossMarginRate());
            data8.add(activityPlanProfitVo.getTaxAndAddition());

            //整体向下支出-专项费用
            List<SpecialCostVo> specialCostList = activityPlanProfitVo.getSpecialCostList();
            Map<String, SpecialCostVo> specialCostVoMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(specialCostList)){
                specialCostVoMap = specialCostList.stream().filter(o->StringUtils.isNotEmpty(o.getActivityTypeCode())).collect(Collectors.toMap(SpecialCostVo::getActivityTypeCode, Function.identity()));
            }
            for (Map.Entry<String, String> specialCostEntry : specialCostMap.entrySet()) {
                List<Object> specialCostList2 = specialCostDataMap.get(specialCostEntry.getKey());
                SpecialCostVo specialCostVo = specialCostVoMap.get(specialCostEntry.getKey());
                if(specialCostVo!=null){
                    specialCostList2.add(specialCostVo.getSpecialCost());
                }else {
                    specialCostList2.add(null);
                }
            }
            List<SpecialCostVo> specialCostTotal = Optional.ofNullable(specialCostList).orElse(Lists.newArrayList()).stream().filter(o -> Objects.nonNull(o.getIsTotal()) && o.getIsTotal()).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(specialCostTotal)){
                data81.add(specialCostTotal.get(0).getSpecialCost());
            }else {
                data81.add(null);
            }

            //整体向下支出-固定支出
            List<FixedExpenseVo> fixedExpenseList = activityPlanProfitVo.getFixedExpenseList();
            Map<String, FixedExpenseVo> fixedExpenseVoMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(fixedExpenseList)){
                fixedExpenseVoMap = fixedExpenseList.stream().filter(o -> StringUtils.isNotEmpty(o.getBudgetSortCode())).collect(Collectors.toMap(FixedExpenseVo::getBudgetSortCode, Function.identity()));
            }
            for (Map.Entry<String, String> fixedExpenseEntry : fixedExpenseMap.entrySet()) {
                List<Object> fixedExpenseDataList2 = fixedExpenseDataMap.get(fixedExpenseEntry.getKey());
                FixedExpenseVo fixedExpenseVo = fixedExpenseVoMap.get(fixedExpenseEntry.getKey());
                if(fixedExpenseVo!=null){
                    fixedExpenseDataList2.add(fixedExpenseVo.getFixedExpense());
                }else {
                    fixedExpenseDataList2.add(null);
                }
            }
            List<FixedExpenseVo> fixedExpenseTotal = Optional.ofNullable(fixedExpenseList).orElse(Lists.newArrayList()).stream().filter(o -> Objects.nonNull(o.getIsTotal()) && o.getIsTotal()).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(fixedExpenseTotal)){
                data82.add(fixedExpenseTotal.get(0).getFixedExpense());
            }else {
                data82.add(null);
            }

            data9.add(activityPlanProfitVo.getPointInCost());
            data10.add(activityPlanProfitVo.getPointOutCost());

            if (activityPlanProfitVo.getAfterDiscountIncome() != null && activityPlanProfitVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                //总部支持-点数内费率
                if(activityPlanProfitVo.getPointInCost() != null){
                    data91.add(activityPlanProfitVo.getPointInCost().divide(activityPlanProfitVo.getAfterDiscountIncome(), 2, BigDecimal.ROUND_HALF_UP));
                }
                //总部支持-点数外费率
                if(activityPlanProfitVo.getPointOutCost() != null){
                    data101.add(activityPlanProfitVo.getPointOutCost().divide(activityPlanProfitVo.getAfterDiscountIncome(), 2, BigDecimal.ROUND_HALF_UP));
                }
            }

            data11.add(activityPlanProfitVo.getHeadquartersAssess());
            data12.add(activityPlanProfitVo.getHeadquartersExpenseTotal());
            data13.add(activityPlanProfitVo.getProfitAmount());
            data14.add(activityPlanProfitVo.getProductPromotionCost());
            data15.add(activityPlanProfitVo.getOtherCostRatio());
            data16.add(activityPlanProfitVo.getSpecialCostRate());
            data17.add(activityPlanProfitVo.getPointInExpendCostRate());
            data18.add(activityPlanProfitVo.getAllCostRate());
        }
        dataList.add(data1);
        dataList.add(data2);
        dataList.add(data3);
        dataList.add(data4);
        dataList.add(data5);
        dataList.add(data6);
        dataList.add(data7);
        dataList.add(data8);

        dataList.addAll(specialCostDataMap.values());
        dataList.add(data81);

        dataList.addAll(fixedExpenseDataMap.values());
        dataList.add(data82);

        dataList.add(data9);
        dataList.add(data10);
        dataList.add(data91);
        dataList.add(data101);
        dataList.add(data11);
        dataList.add(data12);
        dataList.add(data13);
        dataList.add(data14);
        dataList.add(data15);
        dataList.add(data16);
        dataList.add(data17);
        dataList.add(data18);

        return dataList;
    }

    private Map<String, String> getFixedExpenseMap(List<ActivityPlanProfitVo> activityPlanProfitList) {
        Map<String, String> resultMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(activityPlanProfitList)){
            for (ActivityPlanProfitVo activityPlanProfitVo : activityPlanProfitList) {
                if(activityPlanProfitVo.getIsTotal()){
                    continue;
                }
                List<FixedExpenseVo> fixedExpenseList = activityPlanProfitVo.getFixedExpenseList();
                if(CollectionUtils.isNotEmpty(fixedExpenseList)) {
                    for (FixedExpenseVo fixedExpenseVo : fixedExpenseList) {
                        if(fixedExpenseVo.getIsTotal()){
                            continue;
                        }
                        String budgetSortName = resultMap.get(fixedExpenseVo.getBudgetSortCode());
                        if(StringUtils.isEmpty(budgetSortName)){
                            resultMap.put(fixedExpenseVo.getBudgetSortCode(),fixedExpenseVo.getBudgetSortName());
                        }
                    }
                }
            }
        }
        return resultMap;
    }

    private Map<String, String> getSpecialCostMap(List<ActivityPlanProfitVo> activityPlanProfitList) {
        Map<String, String> resultMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(activityPlanProfitList)){
            for (ActivityPlanProfitVo activityPlanProfitVo : activityPlanProfitList) {
                if(activityPlanProfitVo.getIsTotal()){
                    continue;
                }
                List<SpecialCostVo> specialCostList = activityPlanProfitVo.getSpecialCostList();
                if(CollectionUtils.isNotEmpty(specialCostList)) {
                    for (SpecialCostVo specialCostVo : specialCostList) {
                        if(specialCostVo.getIsTotal()){
                            continue;
                        }
                        String typeName = resultMap.get(specialCostVo.getActivityTypeCode());
                        if(StringUtils.isEmpty(typeName)){
                            resultMap.put(specialCostVo.getActivityTypeCode(),specialCostVo.getActivityTypeName());
                        }
                    }
                }
            }
        }
        return resultMap;
    }


    private String submitApproval(ActivityPlanTableDto dto, ProcessBusinessDto processBusiness) {
        Validate.notNull(dto, "提交审批流的数据不能为空");
        submitApprovalValidate(dto);
        processBusiness.setBusinessNo(dto.getId());
        processBusiness.setProcessTitle("活动规划套表[" + dto.getOrgCode() + "-" + dto.getYearAndMonth() + "]发起审批流");
        ProcessBusinessFormVo processBusinessForm = new ProcessBusinessFormVo();
        //根据年月查询自投预算预测
        SubComBudgetForecastDto subComBudgetForecastDto = new SubComBudgetForecastDto();
        subComBudgetForecastDto.setYearMonthLy(dto.getYearAndMonth());
        subComBudgetForecastDto.setOrgCode(dto.getOrgCode());
        subComBudgetForecastDto.setFeeSourceCode(com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum.AUTO_FEE.getCode());
        List<SubComBudgetForecastVo> subComBudgetForecastVos = this.subComBudgetForecastService.listByConditions(subComBudgetForecastDto);
        if(!org.springframework.util.CollectionUtils.isEmpty(subComBudgetForecastVos)){
            SubComBudgetForecastVo subComBudgetForecastVo = subComBudgetForecastVos.get(0);
            processBusinessForm.setRemainderAmount(subComBudgetForecastVo.getRemainderAmount());
        }
        processBusiness.setBusinessCode(ActivityPlanTableConstants.ORDINARY_ACTIVITY_PLAN_TABLE_PROCESS);
        //判断是否走特批
        ActivityPlanTableVo tablePriceVo = this.getById(dto.getId(), SheetNameEnum.PRICE);
        List<PriceVo> priceVoList = tablePriceVo.getPriceList();
        if(CollectionUtils.isNotEmpty(priceVoList)){
            List<String> customerCodeList = priceVoList.stream().map(PriceVo::getCustomerCode).distinct().collect(Collectors.toList());
            List<String> productCodeList = priceVoList.stream().map(PriceVo::getApportionProductCode).distinct().collect(Collectors.toList());
            List<String> channelCodeList = priceVoList.stream().map(PriceVo::getDistributionChannelCode).distinct().collect(Collectors.toList());
            SubComActivityDesignDetailVo conditionVo = new SubComActivityDesignDetailVo();
            conditionVo.setCustomerCodeList(customerCodeList);
            conditionVo.setProductCodeList(productCodeList);
            conditionVo.setChannelCodeList(channelCodeList);
            conditionVo.setOrgCode(dto.getOrgCode());
            conditionVo.setActivityBeginTimeStart(dto.getYearAndMonth() + "-01");
            conditionVo.setActivityBeginTimeEnd(DateUtil.format(DateUtil.dateAddMonth(DateUtil.parse(dto.getYearAndMonth() + "-01",DateUtil.DEFAULT_YEAR_MONTH_DAY), 1), DateUtil.DEFAULT_YEAR_MONTH_DAY));
            List<SubComActivityDesignDetailVo> lowestPriceList = this.subComActivityDesignDetailService.findActivityLowestPriceByConditions(conditionVo);
            boolean isSpecial = false;
            if(CollectionUtils.isNotEmpty(lowestPriceList)){
                Map<String, SubComActivityDesignDetailVo> lowestPriceMap = lowestPriceList.stream().collect(Collectors.toMap(o -> o.getCustomerCode() + o.getProductCode() + o.getDistributionChannelCode(), Function.identity()));
                for(PriceVo priceVo : priceVoList){
                    SubComActivityDesignDetailVo lowestPrice = lowestPriceMap.get(priceVo.getCustomerCode()+priceVo.getApportionProductCode()+priceVo.getDistributionChannelCode());
                    if(lowestPrice.getActivityPrice().compareTo(priceVo.getSupplyMaterialRedLinePrice()) < 0 ||
                            priceVo.getStandardSupplyPrice().subtract(priceVo.getAvgPriceEffect()).compareTo(priceVo.getSupplyMaterialRedLinePrice()) < 0){
                        isSpecial = true;
                        break;
                    }
                }
            }
            if(isSpecial){
                processBusinessForm.setIsBreakPrice(BooleanEnum.TRUE.getCapital());
                processBusinessForm.setIsSpecialGrantProcess(BooleanEnum.TRUE.getCapital());
                processBusinessForm.setIsSpecialProcess(BooleanEnum.TRUE.getCapital());
            } else {
                processBusinessForm.setIsBreakPrice(BooleanEnum.FALSE.getCapital());
                processBusinessForm.setIsSpecialGrantProcess(BooleanEnum.FALSE.getCapital());
                processBusinessForm.setIsSpecialProcess(BooleanEnum.FALSE.getCapital());
            }
        }

        SubComActivityDesignDto subComActivityDesignDto = new SubComActivityDesignDto();
        subComActivityDesignDto.setOrgCode(dto.getOrgCode());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        Date yearAndMonth = null;
        try {
            yearAndMonth = df.parse(dto.getYearAndMonth());
        } catch (ParseException e) {
            log.error(e.getMessage(),e);
            e.printStackTrace();
        }
        subComActivityDesignDto.setFeeYearMonth(yearAndMonth);

        List<SubComActivityDesignDto> designDtos = subComActivityDesignService.listByYearMonthAndOrg(subComActivityDesignDto);
        List<String> activityDesignCodeList = designDtos.stream().map(SubComActivityDesignDto::getActivityDesignCode).collect(Collectors.toList());
        SubComActivityDesignApproveSubmitDto businessFormDto = subComActivityDesignDetailService.getProcessBusinessForm(activityDesignCodeList);
        processBusinessForm.setIsUnderRedLinePrice(Optional.ofNullable(businessFormDto.getIsUnderRedLinePrice()).orElse(BooleanEnum.FALSE.getCapital()));

        processBusiness.setBusinessFormJson(JSONObject.toJSONString(processBusinessForm));
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);

        ActivityPlanTable activityPlanTable = new ActivityPlanTable();
        activityPlanTable.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        activityPlanTable.setProcessNo(processBusinessVo.getProcessNo());
        activityPlanTable.setId(dto.getId());
        this.activityPlanTableRepository.updateById(activityPlanTable);
        subComActivityDesignService.submitBatch(designDtos,processBusinessVo.getProcessNo());
        return processBusinessVo.getProcessNo();
    }

    @Override
    public void saveSubmitBatchByMq(List<String> processNoList) {
        MqMessageVo mqMessageVo = new MqMessageVo();
        mqMessageVo.setMsgBody(JSONObject.toJSONString(processNoList));
        mqMessageVo.setTopic(SubComActivityDesignConstant.TPM_SUB_COM_ACTIVITY_DESIGN_MODIFY_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
        mqMessageVo.setTag(SubComActivityDesignConstant.TPM_SUB_COM_ACTIVITY_DESIGN_SAVE_DATA_TAG);
        rocketMqProducer.sendMqMsg(mqMessageVo, 10);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveSubmitTimeData(String processNo) {
        if (StringUtil.isEmpty(processNo)){
            return;
        }
        ActivityPlanTable table = activityPlanTableRepository.getByProcessNo(processNo);
        ActivityPlanTableVo tableVo = this.getById(table.getId(), null,true);
        log.error("异步保存分子活动规划套表数据查询结果："+ JSON.toJSONString(tableVo));
        if(Objects.isNull(tableVo)){
            return;
        }
        //构建各项数据实体
        List<ActivityPlanTableActivityPlanProfitEntity> activityPlanTableActivityPlanProfitEntityList = new ArrayList<>();
        List<ActivityPlanTableFixedExpenseEntity> activityPlanTableFixedExpenseEntityList = new ArrayList<>();
        List<ActivityPlanTableSpecialCostEntity> activityPlanTableSpecialCostEntityList = new ArrayList<>();
        if(!CollectionUtils.isEmpty(tableVo.getActivityPlanProfitList())){
            //给利润测算id赋值，方便后续映射处理
            for(int i = 0; i < tableVo.getActivityPlanProfitList().size(); i++){
                tableVo.getActivityPlanProfitList().get(i).setId(UUID.randomUUID().toString().replaceAll("-", ""));
            }

            activityPlanTableActivityPlanProfitEntityList.addAll(nebulaToolkitService.copyCollectionByWhiteList(tableVo.getActivityPlanProfitList(), ActivityPlanProfitVo.class, ActivityPlanTableActivityPlanProfitEntity.class, LinkedHashSet.class, ArrayList.class));
            for(ActivityPlanProfitVo profitVo : tableVo.getActivityPlanProfitList()){
                if(!CollectionUtils.isEmpty(profitVo.getFixedExpenseList())){
                    List<ActivityPlanTableFixedExpenseEntity> profitFixedList = new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(profitVo.getFixedExpenseList(), FixedExpenseVo.class, ActivityPlanTableFixedExpenseEntity.class, LinkedHashSet.class, ArrayList.class));
                    //循环设置id
                    for (ActivityPlanTableFixedExpenseEntity activityPlanTableFixedExpenseEntity : profitFixedList) {
                        activityPlanTableFixedExpenseEntity.setProfitId(profitVo.getId());
                        activityPlanTableFixedExpenseEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        activityPlanTableFixedExpenseEntity.setTenantCode(TenantUtils.getTenantCode());
                    }
                    activityPlanTableFixedExpenseEntityList.addAll(profitFixedList);
                }
                if(!CollectionUtils.isEmpty(profitVo.getSpecialCostList())) {
                    List<ActivityPlanTableSpecialCostEntity> profitSpecialList = new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(profitVo.getSpecialCostList(), SpecialCostVo.class, ActivityPlanTableSpecialCostEntity.class, LinkedHashSet.class, ArrayList.class));
                    for (ActivityPlanTableSpecialCostEntity activityPlanTableSpecialCostEntity : profitSpecialList) {
                        activityPlanTableSpecialCostEntity.setProfitId(profitVo.getId());
                        activityPlanTableSpecialCostEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        activityPlanTableSpecialCostEntity.setTenantCode(TenantUtils.getTenantCode());
                    }
                    activityPlanTableSpecialCostEntityList.addAll(profitSpecialList);
                }
            }
        }
        List<ActivityPlanTableCostCollectEntity> activityPlanTableCostCollectEntityList = new ArrayList<>();
        List<ActivityPlanTableFinalFixedExpenseEntity> activityPlanTableFinalFixedExpenseEntityList = new ArrayList<>();
        List<ActivityPlanTablePutOutputRatioEntity> activityPlanTablePutOutputRatioEntityList = new ArrayList<>();
        List<ActivityPlanTableReferendumCostEntity> referendumCostEntityList = new ArrayList<>();
        List<ActivityPlanTableSaleForecastEntity> activityPlanTableSaleForecastEntityList = new ArrayList<>();
        List<ActivityPlanTablePriceEntity> activityPlanTablePriceEntityList = new ArrayList<>();
        String tableCode = tableVo.getActivityPlanTableCode();
        if(!CollectionUtils.isEmpty(activityPlanTableActivityPlanProfitEntityList)){
            for(ActivityPlanTableActivityPlanProfitEntity profitEntity : activityPlanTableActivityPlanProfitEntityList){
                profitEntity.setActivityPlanTableCode(tableCode);
                profitEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                profitEntity.setTenantCode(TenantUtils.getTenantCode());
            }
        }
        if(!CollectionUtils.isEmpty(tableVo.getCostCollectList())){
            activityPlanTableCostCollectEntityList.addAll(nebulaToolkitService.copyCollectionByWhiteList(tableVo.getCostCollectList(), CostCollectVo.class, ActivityPlanTableCostCollectEntity.class, LinkedHashSet.class, ArrayList.class));
            for (ActivityPlanTableCostCollectEntity activityPlanTableCostCollectEntity : activityPlanTableCostCollectEntityList) {
                activityPlanTableCostCollectEntity.setId(null);
                activityPlanTableCostCollectEntity.setActivityPlanTableCode(tableCode);
                activityPlanTableCostCollectEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                activityPlanTableCostCollectEntity.setTenantCode(TenantUtils.getTenantCode());
            }
        }
        if(!CollectionUtils.isEmpty(tableVo.getFixedExpenseList())){
            activityPlanTableFinalFixedExpenseEntityList.addAll(nebulaToolkitService.copyCollectionByWhiteList(tableVo.getFixedExpenseList(), FinalFixedExpenseVo.class, ActivityPlanTableFinalFixedExpenseEntity.class, LinkedHashSet.class, ArrayList.class));
            for (ActivityPlanTableFinalFixedExpenseEntity activityPlanTableFinalFixedExpenseEntity : activityPlanTableFinalFixedExpenseEntityList) {
                activityPlanTableFinalFixedExpenseEntity.setId(null);
                activityPlanTableFinalFixedExpenseEntity.setActivityPlanTableCode(tableCode);
                activityPlanTableFinalFixedExpenseEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                activityPlanTableFinalFixedExpenseEntity.setTenantCode(TenantUtils.getTenantCode());
            }
        }
        if(!CollectionUtils.isEmpty(tableVo.getPutOutputRatioList())){
            activityPlanTablePutOutputRatioEntityList.addAll(nebulaToolkitService.copyCollectionByWhiteList(tableVo.getPutOutputRatioList(), PutOutputRatioVo.class, ActivityPlanTablePutOutputRatioEntity.class, LinkedHashSet.class, ArrayList.class));
            for (ActivityPlanTablePutOutputRatioEntity activityPlanTablePutOutputRatioEntity : activityPlanTablePutOutputRatioEntityList) {
                activityPlanTablePutOutputRatioEntity.setId(null);
                activityPlanTablePutOutputRatioEntity.setActivityPlanTableCode(tableCode);
                activityPlanTablePutOutputRatioEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                activityPlanTablePutOutputRatioEntity.setTenantCode(TenantUtils.getTenantCode());
            }
        }
        if(!CollectionUtils.isEmpty(tableVo.getReferendumCostList())){
            referendumCostEntityList.addAll(nebulaToolkitService.copyCollectionByWhiteList(tableVo.getReferendumCostList(), ReferendumCostVo.class, ActivityPlanTableReferendumCostEntity.class, LinkedHashSet.class, ArrayList.class));
            for (ActivityPlanTableReferendumCostEntity referendumCostEntity : referendumCostEntityList) {
                referendumCostEntity.setId(null);
                referendumCostEntity.setActivityPlanTableCode(tableCode);
                referendumCostEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                referendumCostEntity.setTenantCode(TenantUtils.getTenantCode());
            }
        }
        if(!CollectionUtils.isEmpty(tableVo.getSaleForecastList())){
            activityPlanTableSaleForecastEntityList.addAll(nebulaToolkitService.copyCollectionByWhiteList(tableVo.getSaleForecastList(), SaleForecastVo.class, ActivityPlanTableSaleForecastEntity.class, LinkedHashSet.class, ArrayList.class));
            for (ActivityPlanTableSaleForecastEntity activityPlanTableSaleForecastEntity : activityPlanTableSaleForecastEntityList) {
                activityPlanTableSaleForecastEntity.setId(null);
                activityPlanTableSaleForecastEntity.setActivityPlanTableCode(tableCode);
                activityPlanTableSaleForecastEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                activityPlanTableSaleForecastEntity.setTenantCode(TenantUtils.getTenantCode());
            }
        }
        if(!CollectionUtils.isEmpty(tableVo.getPriceList())){
            activityPlanTablePriceEntityList.addAll(nebulaToolkitService.copyCollectionByWhiteList(tableVo.getPriceList(), PriceVo.class, ActivityPlanTablePriceEntity.class, LinkedHashSet.class, ArrayList.class));
            for (ActivityPlanTablePriceEntity activityPlanTablePriceEntity : activityPlanTablePriceEntityList) {
                activityPlanTablePriceEntity.setId(null);
                activityPlanTablePriceEntity.setActivityPlanTableCode(tableCode);
                activityPlanTablePriceEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                activityPlanTablePriceEntity.setTenantCode(TenantUtils.getTenantCode());
                SubComActivityDesignDetailVo designDetailVo = new SubComActivityDesignDetailVo();
                designDetailVo.setCustomerCode(activityPlanTablePriceEntity.getCustomerCode());
                designDetailVo.setOrgCode(activityPlanTablePriceEntity.getOrgCode());
                designDetailVo.setProductCode(activityPlanTablePriceEntity.getApportionProductCode());
                activityPlanTablePriceEntity.setActivityLowestPrice(subComActivityDesignDetailService.findActivityLowestPrice(designDetailVo));
            }
        }
        //清理旧数据
        specialCostRepository.deleteByTableCode(tableCode);
        fixedExpenseRepository.deleteByTableCode(tableCode);
        activityPlanProfitRepository.deleteByTableCode(tableCode);

        costCollectRepository.deleteByTableCode(tableCode);
        finalFixedExpenseRepository.deleteByTableCode(tableCode);
        putOutputRatioRepository.deleteByTableCode(tableCode);
        referendumCostRepository.deleteByTableCode(tableCode);
        saleForecastRepository.deleteByTableCode(tableCode);
        priceRepository.deleteByTableCode(tableCode);
        //保存审批数据
        activityPlanProfitRepository.saveBatch(activityPlanTableActivityPlanProfitEntityList);
        costCollectRepository.saveBatch(activityPlanTableCostCollectEntityList);
        finalFixedExpenseRepository.saveBatch(activityPlanTableFinalFixedExpenseEntityList);
        fixedExpenseRepository.saveBatch(activityPlanTableFixedExpenseEntityList);
        putOutputRatioRepository.saveBatch(activityPlanTablePutOutputRatioEntityList);
        referendumCostRepository.saveBatch(referendumCostEntityList);
        saleForecastRepository.saveBatch(activityPlanTableSaleForecastEntityList);
        specialCostRepository.saveBatch(activityPlanTableSpecialCostEntityList);
        priceRepository.saveBatch(activityPlanTablePriceEntityList);

    }

    private void submitApprovalValidate(ActivityPlanTableDto dto) {
        ActivityPlanTable table = activityPlanTableRepository.getById(dto.getId());
        if(StringUtils.isNotEmpty(table.getTableVersion()) && !TableVersionEnum.PROCESS_COMMIT_VERSION.getCode().equals(table.getTableVersion())){
            throw new UnsupportedOperationException("实时版活动规划套表不能提交");
        }
        //todo
    }

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    private List<PriceVo> getPriceList(ActivityPlanTableVo activityPlanTableVo, Set<String> orgCodes, List<SalesPlanVo> salesPlanVoList) {

        if(Objects.isNull(activityPlanTableVo)){return null;}

        //客户-产品
        Map<String, List<SalesPlanVo>> salesPlanVoMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(salesPlanVoList)){
            salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.groupingBy(o->o.getErpCode() + "-" + o.getProductCode()));
        }
        SubComActivityDesignDetailDto subComActivityDesignDetailDto = new SubComActivityDesignDetailDto();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        try {
            Validate.notBlank(activityPlanTableVo.getYearAndMonth(),"年月不能为空");
            Date yearAndMonth = df.parse(activityPlanTableVo.getYearAndMonth());
            subComActivityDesignDetailDto.setFeeYearMonth(yearAndMonth);
        } catch (ParseException e) {
            log.error(e.getMessage(),e);
            e.printStackTrace();
        }
        subComActivityDesignDetailDto.setOrgCodeSet(orgCodes);
        subComActivityDesignDetailDto.setIsPriceRelation(IsPriceRelatedNoEnum.isPriceRelated.getCode());
        List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList = subComActivityDesignDetailService.findApportionDetailByConditions(subComActivityDesignDetailDto);
        if(CollectionUtils.isEmpty(subComActivityDesignDetailVoList)){
            return null;
        }
        //过滤产品为空，或者共用量为Z的数据
        subComActivityDesignDetailVoList = subComActivityDesignDetailVoList.stream()
                .filter(o -> StringUtils.isNotEmpty(o.getProductCode()) && !"Z".equals(o.getIsSupplyAmount())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(subComActivityDesignDetailVoList)) {
            return null;
        }
        //维度 客户，产品
//        1031554 【验收相关】【数据归集维度矫正】活动导入红线价判断；套表中红线价按明细维度汇总
        Map<String, List<SubComActivityDesignDetailVo>> subComActivityDesignDetailVoMap = subComActivityDesignDetailVoList.stream().collect(Collectors.groupingBy(o -> o.getCustomerCode() + o.getProductCode() + o.getActivityDesignDetailCode()));
        Set<String> customerErpCodeSet = subComActivityDesignDetailVoList.stream().map(SubComActivityDesignDetailVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<String, List<CustomerVo>> customerMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(customerErpCodeSet)) {
            List<CustomerVo> customerVoList = customerVoService.findByErpCodeList(new ArrayList<>(customerErpCodeSet));
            if (CollectionUtils.isNotEmpty(customerVoList)) {
                customerMap.putAll(customerVoList.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode)));
            } else {
                log.error("活动规划套表-价格，客户信息查询异常，客户编码列表：" + JSONArray.toJSONString(customerErpCodeSet));
                return null;
            }
        }
        List<PriceVo> priceVoList = new ArrayList<>();
        Map<String, List<SalesPlanVo>> finalSalesPlanVoMap = salesPlanVoMap;
        subComActivityDesignDetailVoMap.forEach((uniqueKey, value2)->{
            PriceVo priceVo = this.nebulaToolkitService.copyObjectByWhiteList(value2.get(0), PriceVo.class, null, null);
            priceVo.setRestoredPrice(value2.get(0).getOriginalProductActivityPrice());
            List<CustomerVo> customerVoList = customerMap.get(priceVo.getCustomerCode());
            priceVo.setOrgName(activityPlanTableVo.getOrgName());
            priceVo.setDistributionChannelName(value2.get(0).getDistributionChannelName());
            priceVo.setActivityDesignCode(value2.stream().map(SubComActivityDesignDetailVo::getActivityDesignCode).collect(Collectors.joining(",")));
            priceVo.setActivityDesignName(value2.stream().map(SubComActivityDesignDetailVo::getActivityDesignName).collect(Collectors.joining(",")));
            priceVo.setActivityDesignDetailCode(value2.stream().map(SubComActivityDesignDetailVo::getActivityDesignDetailCode).collect(Collectors.joining(",")));
            priceVo.setApportionProductCode(value2.get(0).getProductCode());
            priceVo.setApportionProductName(value2.get(0).getProductName());

            List<SalesPlanVo> salesPlanVos = finalSalesPlanVoMap.get(value2.get(0).getCustomerCode() + value2.get(0).getProductCode());
            if (CollectionUtils.isNotEmpty(salesPlanVos)){
                priceVo.setCifPrice(salesPlanVos.stream().map(SalesPlanVo::getCifPrice).filter(Objects::nonNull).findFirst().orElse(BigDecimal.ZERO));
            }

            BigDecimal promoteSales = BigDecimal.ZERO;
            for (SubComActivityDesignDetailVo subComActivityDesignDetailVo : value2) {
                //促销量（件） = 期间促销量*产品比例
//                    promoteSales = promoteSales.add(Optional.ofNullable(subComActivityDesignDetailVo.getPromoteSales()).orElse(BigDecimal.ZERO).multiply(Optional.ofNullable(subComActivityDesignDetailVo.getProductRatio()).orElse(BigDecimal.ZERO)));
                if (subComActivityDesignDetailVo.getPromoteSales() != null) {
                    promoteSales = promoteSales.add(subComActivityDesignDetailVo.getPromoteSales());
                }
            }
            priceVo.setPromoteSales(promoteSales);
            //计算平均价格影响
            BigDecimal totalFeeAmount = value2.stream().map(SubComActivityDesignDetailVo::getTotalCost).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalPromotionQuantity = value2.stream().map(SubComActivityDesignDetailVo::getPromoteSales).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal avgPriceEffect = BigDecimal.ZERO;
            if(totalPromotionQuantity != null && BigDecimal.ZERO.compareTo(totalPromotionQuantity) != 0 && totalFeeAmount != null) {
                avgPriceEffect = totalFeeAmount.divide(totalPromotionQuantity, 2, BigDecimal.ROUND_HALF_UP);
            }
            priceVo.setAvgPriceEffect(avgPriceEffect);
            priceVo.setStandardSupplyPrice(BigDecimal.ZERO);
            priceVo.setActivityAfterUnitPrice(BigDecimal.ZERO);
            Optional<SubComActivityDesignDetailVo> activityAfterUnitPriceOptional = value2.stream().filter(o -> Objects.nonNull(o.getActivityPrice())).findAny();
            activityAfterUnitPriceOptional.ifPresent(o -> priceVo.setActivityAfterUnitPrice(o.getActivityPrice()));
            if(StringUtils.isNotEmpty(priceVo.getDistributionChannelCode())){
                SearchPriceDto searchPriceDto = new SearchPriceDto();
                searchPriceDto.setPriceTypeCode("price1");
                List<SearchPriceDimensionItemDto> itemDtos = new ArrayList<>();
                SearchPriceDimensionItemDto dimensionItemDto1 = new SearchPriceDimensionItemDto();
                dimensionItemDto1.setDimensionCode(PriceDimensionEnum.MATERIAL.getDictCode());
                dimensionItemDto1.setRelateCodeSet(Sets.newHashSet(priceVo.getApportionProductCode()));
                itemDtos.add(dimensionItemDto1);
                SearchPriceDimensionItemDto dimensionItemDto2 = new SearchPriceDimensionItemDto();
                dimensionItemDto2.setDimensionCode(PriceDimensionEnum.SALES_INSTITUTION_CODE.getDictCode());
                dimensionItemDto2.setRelateCodeSet(Sets.newHashSet(priceVo.getSalesInstitutionCode().substring(4,8)));
                itemDtos.add(dimensionItemDto2);
                SearchPriceDimensionItemDto dimensionItemDto3 = new SearchPriceDimensionItemDto();
                dimensionItemDto3.setDimensionCode(PriceDimensionEnum.DISTRIBUTION_CHANNEL.getDictCode());
                dimensionItemDto3.setRelateCodeSet(Sets.newHashSet(priceVo.getDistributionChannelCode()));
                itemDtos.add(dimensionItemDto3);
                searchPriceDto.setDimensionItems(itemDtos);
                Map<String, PriceModelVo> priceVoMap = priceModelVoService.handleSearchPrice(searchPriceDto);
                if (priceVoMap != null) {
                    PriceModelVo priceModelVo = priceVoMap.get(priceVo.getApportionProductCode());
                    if (priceModelVo != null) {
                        priceVo.setStandardSupplyPrice(priceModelVo.getPrice());
                    }
                }
                //供货红线价
                searchPriceDto.setPriceTypeCode("fzredlineprice");
                Map<String, PriceModelVo> redLinePriceVoMap = priceModelVoService.handleSearchPrice(searchPriceDto);
                if(redLinePriceVoMap != null && redLinePriceVoMap.get(priceVo.getApportionProductCode()) != null){
                    priceVo.setSupplyMaterialRedLinePrice(redLinePriceVoMap.get(priceVo.getApportionProductCode()).getPrice());
                } else {
                    priceVo.setSupplyMaterialRedLinePrice(BigDecimal.ZERO);
                }
            }
            //点内费用
            priceVo.setInternalAmount(value2.stream().map(SubComActivityDesignDetailVo::getInternalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            //点外费用
            priceVo.setOffAmount(value2.stream().map(SubComActivityDesignDetailVo::getOffAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            //自投费用
            priceVo.setAutoAmount(value2.stream().map(SubComActivityDesignDetailVo::getAutoAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            //活动费用
            priceVo.setActivityCost(value2.stream().map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            //期间促销额
            BigDecimal promotionAmount = BigDecimal.ZERO;
            for (SubComActivityDesignDetailVo o : value2) {
                promotionAmount = promotionAmount.add(Optional.ofNullable(o.getPromotionAmount()).orElse(BigDecimal.ZERO));
            }
            priceVo.setPromotionAmount(promotionAmount);
            priceVoList.add(priceVo);
        });
        return priceVoList;
    }

    private BigDecimal getMaxAmount(Date thisDate, List<SubComActivityDesignDetailVo> value2,List<String> activityDesignDetailCodeList) {

        BigDecimal totalAmount = BigDecimal.ZERO;
        for (SubComActivityDesignDetailVo item : value2) {
            if(item.getActivityBeginTime().compareTo(thisDate)<=0&&item.getActivityEndTime().compareTo(thisDate)>=0){
                totalAmount = totalAmount.add(Optional.ofNullable(item.getDiscountAmount()).orElse(BigDecimal.ZERO));
                activityDesignDetailCodeList.add(item.getActivityDesignDetailCode());
            }
        }
        return totalAmount;
    }

    private List<FinalFixedExpenseVo> getFixedExpenseList(ActivityPlanTableVo activityPlanTableVo, Set<String> orgCodes) {
        if(Objects.isNull(activityPlanTableVo)){
            return null;
        }

        List<FinalFixedExpenseVo> fixedExpenseVoList = new ArrayList<>();
        ProfitGoalDiscountDto profitGoalDiscountDto = new ProfitGoalDiscountDto();
        profitGoalDiscountDto.setYearMonthLy(activityPlanTableVo.getYearAndMonth());
        profitGoalDiscountDto.setOrgCode(activityPlanTableVo.getOrgCode());
        profitGoalDiscountDto.setTypeCodeList(Arrays.asList(BudgetAmountTypeEnum.FIXED_PAY.getCode(),BudgetAmountTypeEnum.ASSESS_DEDUCTION.getCode()));
        profitGoalDiscountDto.setSpecialDataStatus(ConfirmEunm.COMPLETETHECONFIRMATION.getCode());
        List<ProfitGoalDiscountVo> profitGoalDiscountVos = profitGoalDiscountService.groupListByConditions(profitGoalDiscountDto);
        if(CollectionUtils.isNotEmpty(profitGoalDiscountVos)){
            profitGoalDiscountVos.forEach(item->{
                FinalFixedExpenseVo finalFixedExpenseVo = this.nebulaToolkitService.copyObjectByWhiteList(item, FinalFixedExpenseVo.class, null, null);
                fixedExpenseVoList.add(finalFixedExpenseVo);
            });
        }
        return fixedExpenseVoList;
    }

    private List<ReferendumCostVo> getReferendumCostList(ActivityPlanTableVo activityPlanTableVo, Set<String> orgCodes) {
        if(Objects.isNull(activityPlanTableVo)){
            return null;
        }
//        业务单元（主体）+年月（套表对应的年月）+执行客户编码（上海客户编码：190000122760002011；天津客户编码：190000079960002011；西安客户编码：190000082760002011）+活动开始时间到结束时间是当月一整月
        List<ReferendumCostVo> referendumCostVoList = new ArrayList<>();

        SalesApprovalDto salesApprovalDto = new SalesApprovalDto();
        salesApprovalDto.setYearMonthLy(activityPlanTableVo.getYearAndMonth());
        salesApprovalDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        OrgVo orgVo = orgVoService.findByOrgCode(activityPlanTableVo.getOrgCode());
        if (null == orgVo || StringUtils.isEmpty(orgVo.getSalesOrgCode())){
            return null;
        }
        SalesOrgVo salesOrgVo = salesOrgVoService.findBySalesOrgCode(orgVo.getSalesOrgCode());
        if (null == salesOrgVo || StringUtils.isEmpty(salesOrgVo.getErpCode())){
            return null;
        }
        List<SalesOrgSubComOrgVo> salesOrgSubComOrgVos = salesOrgSubComOrgService.findBySaleOrgErpCode(salesOrgVo.getErpCode());
        if (CollectionUtils.isEmpty(salesOrgSubComOrgVos)){
            return null;
        }
        List<String> customerErpCodeList = salesOrgSubComOrgVos.stream().map(SalesOrgSubComOrgVo::getSubComOrgCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(customerErpCodeList)){
            return null;
        }
        List<CustomerVo> customerVos = customerVoService.findByErpCodeList(customerErpCodeList);
        if (CollectionUtils.isEmpty(customerVos)){
            return null;
        }
        List<String> customerCodeList = customerVos.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
        salesApprovalDto.setCustomerCodeList(customerCodeList);
        salesApprovalDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        List<SalesApprovalVo> psmList = activityDetailPlanItemSdkService.findPsmList(salesApprovalDto);
        if(CollectionUtils.isEmpty(psmList)){
            return null;
        }
        psmList.forEach(item->{
            ReferendumCostVo referendumCostVo = this.nebulaToolkitService.copyObjectByWhiteList(item, ReferendumCostVo.class, null, null);
            referendumCostVoList.add(referendumCostVo);
        });
        return referendumCostVoList;
    }

    private List<CostCollectVo> getCostCollectList(List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList) {

        List<CostCollectVo> costCollectVoList = new ArrayList<>();
        if(CollectionUtils.isEmpty(subComActivityDesignDetailVoList)){
            return new ArrayList<>();
        }

        Map<String, List<SubComActivityDesignDetailVo>> collect = subComActivityDesignDetailVoList.stream().collect(Collectors.groupingBy(SubComActivityDesignDetailVo::getActivityDesignDetailCode));
        collect.forEach((key,value)->{
            SubComActivityDesignDetailVo designDetail = value.get(0);
            BigDecimal priceEffect = this.calculatePriceEffect(designDetail);
            CostCollectVo costCollectVo = this.nebulaToolkitService.copyObjectByWhiteList(value.get(0), CostCollectVo.class, null, null);
            costCollectVo.setPriceEffect(priceEffect);
            costCollectVoList.add(costCollectVo);
        });
        List<CostCollectVo> bigDateList = costCollectVoList.stream().filter(item -> {
            return IsBigDateOrNoEnum.isbigdate.getCode().equals(item.getIsBigDate());
        }).collect(Collectors.toList());
        bigProduct:if (!CollectionUtils.isEmpty(bigDateList)){
            //设置大日期产品的保质期
            List<String> productCodeList = bigDateList.stream().map(CostCollectVo::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(productCodeList)){
                break bigProduct;
            }
            List<ProductVo> productVoList = productVoService.findByCodes(productCodeList);
            if (CollectionUtils.isEmpty(productVoList)){
                break bigProduct;
            }
            Map<String, ProductVo> productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o, n) -> n));
            for (CostCollectVo costCollectVo : bigDateList) {
                if (!productVoMap.containsKey(costCollectVo.getProductCode())){
                    continue ;
                }
                ProductVo productVo = productVoMap.get(costCollectVo.getProductCode());
                costCollectVo.setProductExpirationDate(productVo.getExpirationDate());
            }
        }
        return costCollectVoList;
    }

    /**
     * 计算 价格影响 null表‘未定义’
     * @param designDetail
     * @return
     */
    private BigDecimal calculatePriceEffect(SubComActivityDesignDetailVo designDetail) {
        if (ObjectUtils.isEmpty(designDetail)) {
            return null;
        }
        BigDecimal priceEffect = BigDecimal.ZERO;
        //是否模板为：“HDMBPZ3919”
        if (!ActivityPlanTableConstants.DESIGN_DETAIL_TEMPLATECONFIGCODE.equals(designDetail.getTemplateConfigCode())) {
            return null;
        }else {
            //是否关联促销政策
            if (BooleanEnum.TRUE.getCapital().equals(designDetail.getIsAssPromotion())) {
                if (ObjectUtils.isNotEmpty(designDetail.getTotalCost()) && ObjectUtils.isNotEmpty(designDetail.getPromoteSales())) {
                    return designDetail.getTotalCost().divide(designDetail.getPromoteSales(),2,BigDecimal.ROUND_DOWN);
                }
            }else {
                //活动形式是否为“ZS03”
                if (ActivityPlanTableConstants.DESIGN_DETAIL_FORM_CODE_ZS03.equals(designDetail.getActivityFormCode())) {
                    if (ObjectUtils.isNotEmpty(designDetail.getOriginalProductPrice()) && ObjectUtils.isNotEmpty(designDetail.getActivityPrice())){
                        return designDetail.getOriginalProductPrice().subtract(designDetail.getActivityPrice());
                    }
                }else if (ActivityPlanTableConstants.DESIGN_DETAIL_FORM_CODE_ZS01.equals(designDetail.getActivityFormCode())){
                    //活动形式是否为“ZS01”
                    if (ObjectUtils.isNotEmpty(designDetail.getOriginalProductPrice()) && ObjectUtils.isNotEmpty(designDetail.getOriginalProductNumber())
                            && ObjectUtils.isNotEmpty(designDetail.getGiftProductNumber())) {
                        BigDecimal multiply = designDetail.getOriginalProductPrice().multiply(designDetail.getOriginalProductNumber());
                        BigDecimal add = designDetail.getOriginalProductNumber().add(designDetail.getGiftProductNumber());
                        if (BigDecimal.ZERO.compareTo(add) == 0) {
                            return null;
                        }
                        return designDetail.getOriginalProductPrice().subtract(multiply.divide(add,2,BigDecimal.ROUND_DOWN));
                    }
                }else {
                    if (ObjectUtils.isNotEmpty(designDetail.getTotalCost()) && ObjectUtils.isNotEmpty(designDetail.getPromoteSales())) {
                        return designDetail.getTotalCost().divide(designDetail.getPromoteSales(),2,BigDecimal.ROUND_DOWN);
                    }
                }
            }
        }
        return null;
    }

    private List<SaleForecastVo> getSaleForecastList(ActivityPlanTableVo activityPlanTableVo, Set<String> orgCodes, List<SalesPlanVo> salesPlanVoList, List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList) {
        List<SaleForecastVo> saleForecastVoList = new ArrayList<>();

        //客户-产品
        Map<String, List<SalesPlanVo>> salesPlanVoMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(salesPlanVoList)){
            salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.groupingBy(o->o.getErpCode() + "-" + o.getProductCode()));
        }
        salesPlanVoMap.forEach((key, value)->{
                    SaleForecastVo saleForecastVo = new SaleForecastVo();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            try {
                saleForecastVo.setFeeYearMonth(sdf.parse(activityPlanTableVo.getYearAndMonth()));
            } catch (ParseException e) {
                log.error(e.getMessage(),e);
                e.printStackTrace();
            }
            SalesPlanVo salesPlanVo = value.get(0);
            saleForecastVo.setOrgCode(activityPlanTableVo.getOrgCode());
                    saleForecastVo.setOrgName(activityPlanTableVo.getOrgName());
                    saleForecastVo.setDepartmentCode(salesPlanVo.getSalesOrgRegionCode());
                    saleForecastVo.setDepartmentName(salesPlanVo.getSalesOrgRegionName());
                    saleForecastVo.setSalesOrgCode(salesPlanVo.getSalesOrgProvinceCode());
                    saleForecastVo.setSalesOrgName(salesPlanVo.getSalesOrgProvinceName());
                    saleForecastVo.setCustomerCode(salesPlanVo.getErpCode());
                    saleForecastVo.setCustomerName(salesPlanVo.getCustomerName());
                    saleForecastVo.setProductBrandCode(salesPlanVo.getProductBrandCode());
                    saleForecastVo.setProductBrandName(salesPlanVo.getProductBrandName());
                    saleForecastVo.setProductCategoryCode(salesPlanVo.getProductCategoryCode());
                    saleForecastVo.setProductCategoryName(salesPlanVo.getProductCategoryName());
                    saleForecastVo.setProductItemCode(salesPlanVo.getProductItemCode());
                    saleForecastVo.setProductItemName(salesPlanVo.getProductItemName());
                    saleForecastVo.setProductCode(salesPlanVo.getProductCode());
                    saleForecastVo.setProductName(salesPlanVo.getProductName());

                    if(CollectionUtils.isNotEmpty(value)){
                        //折前到岸价
                        saleForecastVo.setBeforeDiscountCostAndFreight(value.stream().map(SalesPlanVo::getCifPrice).filter(Objects::nonNull).findFirst().orElse(BigDecimal.ZERO));
                        //折前供货价
                        saleForecastVo.setBeforeDiscountProvideGoodsPrice(value.stream().map(SalesPlanVo::getStandardSupplyPrice).filter(Objects::nonNull).findFirst().orElse(BigDecimal.ZERO));
                        //全月出库件数
                        saleForecastVo.setMonthOutStockQuantity(value.stream().map(SalesPlanVo::getPlanQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                        //折前销售收入
                        saleForecastVo.setBeforeDiscountSaleIncome(value.stream().map(SalesPlanVo::getTheoryIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                        //折前销售成本
                        saleForecastVo.setBeforeDiscountSaleCost(value.stream().map(SalesPlanVo::getTheoryCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                        //理论毛利=折前销售收入-折前销售成本
                        saleForecastVo.setTheoryProfit(saleForecastVo.getBeforeDiscountSaleIncome().subtract(saleForecastVo.getBeforeDiscountSaleCost()));
                        //理论毛利率=理论毛利/折前销售收入
                        if(saleForecastVo.getBeforeDiscountSaleIncome().compareTo(BigDecimal.ZERO)!=0) {
                            saleForecastVo.setTheoryGrossMarginRate(saleForecastVo.getTheoryProfit().divide(saleForecastVo.getBeforeDiscountSaleIncome(),6,RoundingMode.HALF_UP));
                        }
                        //折后销量 销售计划中 根据年月+组织+客户+产品维度汇总“折后收入”
                        saleForecastVo.setAfterDiscountSaleQuantity(value.stream().map(SalesPlanVo::getDiscountedIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                        //折后销量 销售计划中 根据年月+组织+客户+产品取“折后成本”后展示
                        saleForecastVo.setAfterDiscountCost(value.stream().map(SalesPlanVo::getDiscountedCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    }
                    saleForecastVoList.add(saleForecastVo);
            });
        return saleForecastVoList;
    }

    private List<PutOutputRatioVo> getPutOutputRatioList(ActivityPlanTableVo activityPlanTableVo, Set<String> orgCodes, List<SalesPlanVo> salesPlanVoList, List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoListl) {

        //销售收入
        Map<String, List<SalesPlanVo>> salesPlanVoMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(salesPlanVoList)) {
            salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getErpCode()).orElse("")));
        }
        // 只处理客户不为空的数据
        List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList = subComActivityDesignDetailVoListl.stream().filter(item -> StringUtils.isNotEmpty(item.getCustomerCode())).collect(Collectors.toList());
        List<PutOutputRatioVo> putOutputRatioVoList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(subComActivityDesignDetailVoList)){
            Set<String> customerErpCodeSet = subComActivityDesignDetailVoList.stream().map(SubComActivityDesignDetailVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
            Map<String, List<CustomerVo>> customerMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(customerErpCodeSet)) {
                List<CustomerVo> customerVoList = customerVoService.findByErpCodeList(new ArrayList<>(customerErpCodeSet));
                if (CollectionUtils.isNotEmpty(customerVoList)) {
                    customerMap.putAll(customerVoList.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode)));
                }
            }
            Map<String, List<SubComActivityDesignDetailVo>> subComActivityDesignDetailVoMap = subComActivityDesignDetailVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getCustomerCode()).orElse("")));
            Map<String, List<SalesPlanVo>> finalSalesPlanVoMap = salesPlanVoMap;
            subComActivityDesignDetailVoMap.forEach((key, value)->{
                Map<String, SubComActivityDesignDetailVo> value2 = value.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity(), (o, n) -> o));
                SubComActivityDesignDetailVo subComActivityDesignDetailVo = value.get(0);
                PutOutputRatioVo putOutputRatioVo = this.nebulaToolkitService.copyObjectByWhiteList(subComActivityDesignDetailVo, PutOutputRatioVo.class, null, null);
                putOutputRatioVo.setTotalCost(value2.values().stream().map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setOffAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getOffAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setInternalAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getInternalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setAutoAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getAutoAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));

                //1、年月+组织（对应的销售机构）+客户
                //2、折前收入取【理论收入】，折后收入取【折后金额】
                List<SalesPlanVo> salesPlanVoList1 = finalSalesPlanVoMap.get(key);
                if(CollectionUtils.isNotEmpty(salesPlanVoList1)){
                    //折前收入
                    putOutputRatioVo.setBeforeDiscountIncome(salesPlanVoList1.stream().map(SalesPlanVo::getTheoryIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    //折后收入
                    putOutputRatioVo.setAfterDiscountIncome(salesPlanVoList1.stream().map(SalesPlanVo::getDiscountedIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    if(putOutputRatioVo.getAfterDiscountIncome()!=null&&putOutputRatioVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO)!=0) {
                        putOutputRatioVo.setInputOutputRatio(Optional.ofNullable(putOutputRatioVo.getTotalCost()).orElse(BigDecimal.ZERO).divide(putOutputRatioVo.getAfterDiscountIncome(),6,RoundingMode.HALF_UP));
                        DecimalFormat df = new DecimalFormat("0.0000%");
                        putOutputRatioVo.setInputOutPutRatioStr(df.format(putOutputRatioVo.getInputOutputRatio()));
                    }
                }
                if (null != putOutputRatioVo.getCustomerCode() && customerMap.containsKey(putOutputRatioVo.getCustomerCode())){
                    CustomerVo customerVo = customerMap.get(putOutputRatioVo.getCustomerCode()).get(0);
                    putOutputRatioVo.setDepartmentCode(customerVo.getSalesOrgCode());
                    putOutputRatioVo.setDepartmentName(customerVo.getSalesOrgName());
                }
                putOutputRatioVoList.add(putOutputRatioVo);
            });
            return putOutputRatioVoList;
        }
        return new ArrayList<>();
    }

    private List<PutOutputRatioVo> getPutOutputRatioListGroupByOrgCode(List<SalesPlanVo> salesPlanVoList, List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList) {
        log.info("实时版查询投入产出比salesPlanVoList:{}", JSON.toJSONString(salesPlanVoList));
        log.info("实时版查询投入产出比subComActivityDesignDetailVoList:{}", JSON.toJSONString(subComActivityDesignDetailVoList));
        //销售收入
        Map<String, List<SalesPlanVo>> salesPlanVoMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(salesPlanVoList)) {
            salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getOrgCode()).orElse("")));
        }
        log.info("实时版查询投入产出比salesPlanVoMap:{}", JSON.toJSONString(salesPlanVoMap));
        List<PutOutputRatioVo> putOutputRatioVoList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(subComActivityDesignDetailVoList)){
            Map<String, List<SubComActivityDesignDetailVo>> subComActivityDesignDetailVoMap = subComActivityDesignDetailVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getOrgCode()).orElse("")));
            log.info("实时版查询投入产出比subComActivityDesignDetailVoMap:{}", JSON.toJSONString(subComActivityDesignDetailVoMap));
            Map<String, List<SalesPlanVo>> finalSalesPlanVoMap = salesPlanVoMap;
            subComActivityDesignDetailVoMap.forEach((key, value)->{
                log.info("实时版查询投入产出比key:{},value:{}", JSON.toJSONString(key), JSON.toJSONString(subComActivityDesignDetailVoMap));
                Map<String, SubComActivityDesignDetailVo> value2 = value.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity(), (o, n) -> o));
                SubComActivityDesignDetailVo subComActivityDesignDetailVo = value.get(0);
                PutOutputRatioVo putOutputRatioVo = this.nebulaToolkitService.copyObjectByWhiteList(subComActivityDesignDetailVo, PutOutputRatioVo.class, null, null);
                putOutputRatioVo.setTotalCost(value2.values().stream().map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setOffAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getOffAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setInternalAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getInternalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setAutoAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getAutoAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));

                //1、年月+组织（对应的销售机构）+客户
                //2、折前收入取【理论收入】，折后收入取【折后金额】
                List<SalesPlanVo> salesPlanVoList1 = finalSalesPlanVoMap.get(key);
                log.info("实时版查询投入产出比salesPlanVoList1:{}", JSON.toJSONString(salesPlanVoList1));
                if(CollectionUtils.isNotEmpty(salesPlanVoList1)){
                    //折前收入
                    putOutputRatioVo.setBeforeDiscountIncome(salesPlanVoList1.stream().map(SalesPlanVo::getTheoryIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    //折后收入
                    putOutputRatioVo.setAfterDiscountIncome(salesPlanVoList1.stream().map(SalesPlanVo::getDiscountedIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));

                    log.info("实时版查询投入产出比putOutputRatioVo:{}", JSON.toJSONString(putOutputRatioVo));
                    if(putOutputRatioVo.getAfterDiscountIncome()!=null&&putOutputRatioVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO)!=0) {
                        putOutputRatioVo.setInputOutputRatio(Optional.ofNullable(putOutputRatioVo.getTotalCost()).orElse(BigDecimal.ZERO).divide(putOutputRatioVo.getAfterDiscountIncome(),6,RoundingMode.HALF_UP));
                        DecimalFormat df = new DecimalFormat("0.0000%");
                        putOutputRatioVo.setInputOutPutRatioStr(df.format(putOutputRatioVo.getInputOutputRatio()));
                    }
                    if (putOutputRatioVo.getBeforeDiscountIncome() != null && putOutputRatioVo.getBeforeDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                        //折前投产比
                        putOutputRatioVo.setBeforeInputOutputRatio(putOutputRatioVo.getTotalCost().divide(putOutputRatioVo.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
                    }
                    if (putOutputRatioVo.getAfterDiscountIncome() != null && putOutputRatioVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                        //折后投产比
                        putOutputRatioVo.setAfterInputOutputRatio(putOutputRatioVo.getTotalCost().divide(putOutputRatioVo.getAfterDiscountIncome(), 6, RoundingMode.HALF_UP));
                    }
                }
                putOutputRatioVoList.add(putOutputRatioVo);
            });
            return putOutputRatioVoList;
        }
        return new ArrayList<>();
    }

    private List<PutOutputRatioCustomerVo> getPutOutputRatioListGroupByCustomerCode(List<SalesPlanVo> salesPlanVoList, List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList) {
        //销售收入
        Map<String, List<SalesPlanVo>> salesPlanVoMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(salesPlanVoList)) {
            salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getErpCode()).orElse("")));
        }
        // 只处理客户不为空的数据
        subComActivityDesignDetailVoList = subComActivityDesignDetailVoList.stream().filter(item -> StringUtils.isNotEmpty(item.getCustomerCode())).collect(Collectors.toList());
        List<PutOutputRatioCustomerVo> putOutputRatioVoList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(subComActivityDesignDetailVoList)){
            Map<String, List<SubComActivityDesignDetailVo>> subComActivityDesignDetailVoMap = subComActivityDesignDetailVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getCustomerCode()).orElse("")));
            Map<String, List<SalesPlanVo>> finalSalesPlanVoMap = salesPlanVoMap;
            subComActivityDesignDetailVoMap.forEach((key, value)->{
                Map<String, SubComActivityDesignDetailVo> value2 = value.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity(), (o, n) -> o));
                SubComActivityDesignDetailVo subComActivityDesignDetailVo = value.get(0);
                PutOutputRatioCustomerVo putOutputRatioVo = this.nebulaToolkitService.copyObjectByWhiteList(subComActivityDesignDetailVo, PutOutputRatioCustomerVo.class, null, null);
                putOutputRatioVo.setTotalCost(value2.values().stream().map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setOffAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getOffAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setInternalAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getInternalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setAutoAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getAutoAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));

                putOutputRatioVo.setDisplay(value2.values().stream().filter(e -> "Z0001".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setPersonnel(value2.values().stream().filter(e -> "Z0002".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setPromotion(value2.values().stream().filter(e -> "Z0003".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setSell(value2.values().stream().filter(e -> "Z0006".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setMaterial(value2.values().stream().filter(e -> "Z0008".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setChannelConstruction(value2.values().stream().filter(e -> "Z0014".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setDisposalOfUsedGoods(value2.values().stream().filter(e -> "Z0038".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setOther(value2.values().stream().filter(e -> "Z0039".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));


                //1、年月+组织（对应的销售机构）+客户
                //2、折前收入取【理论收入】，折后收入取【折后金额】
                List<SalesPlanVo> salesPlanVoList1 = finalSalesPlanVoMap.get(key);
                if(CollectionUtils.isNotEmpty(salesPlanVoList1)){
                    //折前收入
                    putOutputRatioVo.setBeforeDiscountIncome(salesPlanVoList1.stream().map(SalesPlanVo::getTheoryIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    //折后收入
                    putOutputRatioVo.setAfterDiscountIncome(salesPlanVoList1.stream().map(SalesPlanVo::getDiscountedIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    if(putOutputRatioVo.getAfterDiscountIncome()!=null&&putOutputRatioVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO)!=0) {
                        putOutputRatioVo.setInputOutputRatio(Optional.ofNullable(putOutputRatioVo.getTotalCost()).orElse(BigDecimal.ZERO).divide(putOutputRatioVo.getAfterDiscountIncome(),6,RoundingMode.HALF_UP));
                        DecimalFormat df = new DecimalFormat("0.0000%");
                        putOutputRatioVo.setInputOutPutRatioStr(df.format(putOutputRatioVo.getInputOutputRatio()));
                    }
                    if (putOutputRatioVo.getBeforeDiscountIncome() != null && putOutputRatioVo.getBeforeDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                        //折前收入
                        putOutputRatioVo.setBeforeInputOutputRatio(putOutputRatioVo.getTotalCost().divide(putOutputRatioVo.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
                    }
                    if (putOutputRatioVo.getAfterDiscountIncome() != null && putOutputRatioVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                        //折后收入
                        putOutputRatioVo.setAfterInputOutputRatio(putOutputRatioVo.getTotalCost().divide(putOutputRatioVo.getAfterDiscountIncome(), 6, RoundingMode.HALF_UP));
                    }
                }
                putOutputRatioVoList.add(putOutputRatioVo);
            });
            return putOutputRatioVoList;
        }
        return new ArrayList<>();
    }

    private List<ActivityPlanProfitVo> getActivityPlanProfit(ActivityPlanTableVo activityPlanTableVo, Set<String> orgCodes, List<SalesPlanVo> salesPlanVoList, List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList){

        PageRequest page = PageRequest.of(0, Integer.MAX_VALUE);
        CustomerChannelDto customerChannelDto = new CustomerChannelDto();
        Page<CustomerChannelVo> customerChannelVoPage = customerChannelVoService.findByConditions(page, customerChannelDto);
        Map<String, CustomerChannelVo> customerChannelVoMap = new HashMap<>();
        if(customerChannelVoPage!=null){
            if(CollectionUtils.isNotEmpty(customerChannelVoPage.getRecords())){
                customerChannelVoMap = customerChannelVoPage.getRecords().stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity()));
            }
        }
        //合计
        ActivityPlanProfitVo total = new ActivityPlanProfitVo();
        total.setIsTotal(true);
        total.setOutStorageQuantity(BigDecimal.ZERO);
        total.setBeforeDiscountIncome(BigDecimal.ZERO);
        total.setBeforeDiscountCost(BigDecimal.ZERO);
        total.setAfterDiscountIncome(BigDecimal.ZERO);
        total.setTheoryGrossMarginAmount(BigDecimal.ZERO);
        total.setTheoryGrossMarginRate(BigDecimal.ZERO);

        //利润测算
        List<ActivityPlanProfitVo> activityPlanProfitList = new ArrayList<>();

        Map<String,BigDecimal> chanalCodeToSaleQuantityRatioMap = Maps.newHashMap();

        //分子公司预算预测税金及附加
        SubComBudgetForecastVo subComBudgetForecastVo = new SubComBudgetForecastVo();
        subComBudgetForecastVo.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        subComBudgetForecastVo.setOrgCode(activityPlanTableVo.getOrgCode());
        subComBudgetForecastVo.setYearMonthLy(activityPlanTableVo.getYearAndMonth());

        BigDecimal totalTaxAndAddition = subComBudgetForecastService.queryTaxAndAddition(subComBudgetForecastVo);
        total.setTaxAndAddition(totalTaxAndAddition);

        if(CollectionUtils.isNotEmpty(salesPlanVoList)){
            Map<String, List<SalesPlanVo>> salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getCustomerChannelCode()).orElse("")));
            List<ActivityPlanProfitVo> finalActivityPlanProfitList = activityPlanProfitList;
            salesPlanVoMap.forEach((key, value)->{
                ActivityPlanProfitVo activityPlanProfitVo = new ActivityPlanProfitVo();
                activityPlanProfitVo.setIsTotal(false);
                activityPlanProfitVo.setCustomerChannelCode(key);
                SalesPlanVo salesPlanVo = value.get(0);
                //计划数量
                BigDecimal planQuantity = value.stream().map(SalesPlanVo::getPlanQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                //出库件数 = 计划数量
                activityPlanProfitVo.setOutStorageQuantity(planQuantity);
                activityPlanProfitVo.setCustomerChannelName(salesPlanVo.getCustomerChannelName());
                total.setOutStorageQuantity(total.getOutStorageQuantity().add(planQuantity));
                //折前金额
                BigDecimal amount = value.stream().map(SalesPlanVo::getAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal theoryIncome = value.stream().map(SalesPlanVo::getTheoryIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                //折前收入 = 理论收入
                activityPlanProfitVo.setBeforeDiscountIncome(theoryIncome);
                total.setBeforeDiscountIncome(total.getBeforeDiscountIncome().add(theoryIncome));

                //折前成本 = 理论成本
                BigDecimal theoryCost = value.stream().map(SalesPlanVo::getTheoryCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                activityPlanProfitVo.setBeforeDiscountCost(theoryCost);
                total.setBeforeDiscountCost(total.getBeforeDiscountCost().add(theoryCost));

                //折后收入 = 折后收入
                BigDecimal discountAmount = value.stream().map(SalesPlanVo::getDiscountedIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                activityPlanProfitVo.setAfterDiscountIncome(discountAmount);
                total.setAfterDiscountIncome(total.getAfterDiscountIncome().add(discountAmount));

                //理论毛利额 = 折前收入-折前成本
                activityPlanProfitVo.setTheoryGrossMarginAmount(theoryIncome.subtract(theoryCost));
                total.setTheoryGrossMarginAmount(total.getTheoryGrossMarginAmount().add(activityPlanProfitVo.getTheoryGrossMarginAmount()));

                //理论毛利率= 理论毛利额/折前收入
                if(Objects.nonNull(activityPlanProfitVo.getTheoryGrossMarginAmount())&&Objects.nonNull(activityPlanProfitVo.getBeforeDiscountIncome())&&activityPlanProfitVo.getBeforeDiscountIncome().compareTo(BigDecimal.ZERO)!=0) {
                    activityPlanProfitVo.setTheoryGrossMarginRate(activityPlanProfitVo.getTheoryGrossMarginAmount().divide(activityPlanProfitVo.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
                }

                finalActivityPlanProfitList.add(activityPlanProfitVo);
            });
            //理论毛利率= 理论毛利额/折前收入
            if(Objects.nonNull(total.getBeforeDiscountIncome())&&total.getBeforeDiscountIncome().compareTo(BigDecimal.ZERO)!=0) {
                total.setTheoryGrossMarginRate(Optional.ofNullable(total.getTheoryGrossMarginAmount()).orElse(BigDecimal.ZERO).divide(total.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
            }

            activityPlanProfitList.forEach(item -> {
                //销量占比=折后收入/折后收入合计
                if (Objects.nonNull(item.getAfterDiscountIncome()) && item.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                    item.setSaleQuantityRatio(Optional.ofNullable(item.getAfterDiscountIncome()).orElse(BigDecimal.ZERO).divide(total.getAfterDiscountIncome(), 6, RoundingMode.HALF_UP));
                    //取分子公司预算预测里的自投费用中算出来的税，然后乘以销量占比
                    BigDecimal saleQuantityRatio = item.getSaleQuantityRatio();
                    chanalCodeToSaleQuantityRatioMap.put(item.getCustomerChannelCode(), saleQuantityRatio);
                    item.setTaxAndAddition(saleQuantityRatio.multiply(Optional.ofNullable(totalTaxAndAddition).orElse(BigDecimal.ZERO)));
                }
            });
            total.setSaleQuantityRatio(BigDecimal.ONE);
        }

        //查询分子公司活动规划
        SubComActivityDesignDetailDto subComActivityDesignDetailDto = new SubComActivityDesignDetailDto();
        List<String> activityDesignDetailCodeList = subComActivityDesignDetailVoList.stream().map(SubComActivityDesignDetailVo::getActivityDesignDetailCode).collect(Collectors.toList());
        subComActivityDesignDetailDto.setActivityDesignDetailCodeList(activityDesignDetailCodeList);
        //分子公司所有下级
        subComActivityDesignDetailDto.setOrgCodeSet(orgCodes);
        //专项费用
        List<SpecialCostVo> specialCostVoList = Optional.ofNullable(subComActivityDesignDetailService.findSpecialCost(subComActivityDesignDetailDto)).orElse(new ArrayList<>());

        //map(客户渠道,利润测算实体)
        Map<String, ActivityPlanProfitVo> activityPlanProfitVoMap = activityPlanProfitList.stream().collect(Collectors.toMap(ActivityPlanProfitVo::getCustomerChannelCode, Function.identity()));
        //map(客户渠道，活动类型，集合)
        //对集合的结果进行去重
        specialCostVoList = specialCostVoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(SpecialCostVo::getActivityDesignDetailCode))), ArrayList::new));
        Map<String, Map<String, List<SpecialCostVo>>> specialCostVoMap = specialCostVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getCustomerChannelCode()).orElse(""), Collectors.groupingBy(item -> Optional.ofNullable(item.getActivityTypeCode()).orElse(""))));
        Map<String, CustomerChannelVo> finalCustomerChannelVoMap = customerChannelVoMap;
        specialCostVoMap.forEach((key, value)->{
            //小计
            SpecialCostVo specialCostVoTotal = new SpecialCostVo();
            specialCostVoTotal.setIsTotal(true);
            specialCostVoTotal.setCustomerChannelCode(key);
            specialCostVoTotal.setSpecialCost(BigDecimal.ZERO);

            ActivityPlanProfitVo activityPlanProfitVo = activityPlanProfitVoMap.get(key);
            List<SpecialCostVo> specialCostList = new ArrayList<>();
            if(activityPlanProfitVo == null){
                ActivityPlanProfitVo activityPlanProfitVo2 = new ActivityPlanProfitVo();
                activityPlanProfitVo2.setIsTotal(false);
                activityPlanProfitVo2.setCustomerChannelCode(key);
                //查询客户渠道名称
                CustomerChannelVo customerChannelVo = finalCustomerChannelVoMap.get(key);
                if(customerChannelVo != null) {
                    activityPlanProfitVo2.setCustomerChannelName(customerChannelVo.getCustomerChannelName());
                }
                activityPlanProfitVo2.setPointInCost(BigDecimal.ZERO);
                activityPlanProfitVo2.setPointOutCost(BigDecimal.ZERO);
                activityPlanProfitVo2.setProductPromotionCostNumerator(BigDecimal.ZERO);
                activityPlanProfitVo2.setPointInCostRateNumerator(BigDecimal.ZERO);
                value.forEach((key2,value2)->{
                    SpecialCostVo specialCostVo = value2.get(0);
//                    activityPlanProfitVo2.setCustomerChannelName(specialCostVo.getCustomerChannelName());
                    specialCostVoTotal.setCustomerChannelName(specialCostVo.getCustomerChannelName());
                    SpecialCostVo specialCostVo1 = new SpecialCostVo();
                    specialCostVo1.setIsTotal(false);
                    specialCostVo1.setActivityTypeCode(key2);
                    specialCostVo1.setActivityTypeName(specialCostVo.getActivityTypeName());
                    specialCostVo1.setSpecialCost(value2.stream().map(SpecialCostVo::getSpecialCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    specialCostList.add(specialCostVo1);
                    //点内费用
                    activityPlanProfitVo2.setPointInCost(activityPlanProfitVo2.getPointInCost().add(value2.stream().map(SpecialCostVo::getInternalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                    //点外费用
                    activityPlanProfitVo2.setPointOutCost(activityPlanProfitVo2.getPointOutCost().add(value2.stream().map(SpecialCostVo::getOffAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                    specialCostVoTotal.setSpecialCost(specialCostVoTotal.getSpecialCost().add(specialCostVo1.getSpecialCost()));

                    //用于计算产品促销费用率，分子
                    activityPlanProfitVo2.setProductPromotionCostNumerator(activityPlanProfitVo2.getProductPromotionCostNumerator().add(value2.stream().filter(o->Objects.nonNull(o.getIsRelatePrice())).filter(SpecialCostVo::getIsRelatePrice).map(SpecialCostVo::getSpecialCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                    //用于计算产品促销费用率，分子
                    activityPlanProfitVo2.setPointInCostRateNumerator(activityPlanProfitVo2.getPointInCostRateNumerator().add(value2.stream().filter(o->Objects.nonNull(o.getIsRelatePrice())).filter(o->!o.getIsRelatePrice()).map(SpecialCostVo::getSpecialCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));

                });
                specialCostList.add(specialCostVoTotal);
                activityPlanProfitVo2.setSpecialCostList(specialCostList);
                activityPlanProfitVoMap.put(key,activityPlanProfitVo2);
            }else {
                specialCostVoTotal.setCustomerChannelName(activityPlanProfitVo.getCustomerChannelName());
                activityPlanProfitVo.setPointInCost(BigDecimal.ZERO);
                activityPlanProfitVo.setPointOutCost(BigDecimal.ZERO);
                activityPlanProfitVo.setProductPromotionCostNumerator(BigDecimal.ZERO);
                activityPlanProfitVo.setPointInCostRateNumerator(BigDecimal.ZERO);
                value.forEach((key2,value2)->{
                    SpecialCostVo specialCostVo = value2.get(0);
                    SpecialCostVo specialCostVo1 = new SpecialCostVo();
                    specialCostVo1.setIsTotal(false);
                    specialCostVo1.setActivityTypeCode(key2);
                    specialCostVo1.setActivityTypeName(specialCostVo.getActivityTypeName());
                    specialCostVo1.setSpecialCost(value2.stream().map(SpecialCostVo::getSpecialCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    specialCostList.add(specialCostVo1);
                    //点内费用
                    activityPlanProfitVo.setPointInCost(activityPlanProfitVo.getPointInCost().add(value2.stream().map(SpecialCostVo::getInternalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                    //点外费用
                    activityPlanProfitVo.setPointOutCost(activityPlanProfitVo.getPointOutCost().add(value2.stream().map(SpecialCostVo::getOffAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                    if(activityPlanProfitVo.getPointInCost() != null && activityPlanProfitVo.getAfterDiscountIncome() != null && activityPlanProfitVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0){
                        activityPlanProfitVo.setPointInCostRatio(activityPlanProfitVo.getPointInCost().divide(activityPlanProfitVo.getAfterDiscountIncome(), 2, BigDecimal.ROUND_HALF_UP));
                    }
                    if(activityPlanProfitVo.getPointOutCost() != null && activityPlanProfitVo.getAfterDiscountIncome() != null && activityPlanProfitVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0){
                        activityPlanProfitVo.setPointOutCostRatio(activityPlanProfitVo.getPointOutCost().divide(activityPlanProfitVo.getAfterDiscountIncome(), 2, BigDecimal.ROUND_HALF_UP));
                    }
                    specialCostVoTotal.setSpecialCost(specialCostVoTotal.getSpecialCost().add(specialCostVo1.getSpecialCost()));
                    //用于计算产品促销费用率，分子
                    activityPlanProfitVo.setProductPromotionCostNumerator(activityPlanProfitVo.getProductPromotionCostNumerator().add(value2.stream().filter(o->Objects.nonNull(o.getIsRelatePrice())).filter(SpecialCostVo::getIsRelatePrice).map(SpecialCostVo::getSpecialCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                    //用于计算产品促销费用率，分子
                    activityPlanProfitVo.setPointInCostRateNumerator(activityPlanProfitVo.getPointInCostRateNumerator().add(value2.stream().filter(o->Objects.nonNull(o.getIsRelatePrice())).filter(o->!o.getIsRelatePrice()).map(SpecialCostVo::getSpecialCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));

                });

                specialCostList.add(specialCostVoTotal);
                activityPlanProfitVo.setSpecialCostList(specialCostList);
            }
        });

        //合计 固定费用
        Map<String,SpecialCostVo> specialCostVoTotalMap = new HashMap<>();
        //小计的合计
        SpecialCostVo specialCostVoVo1 = new SpecialCostVo();
        activityPlanProfitVoMap.forEach((key,value)->{
            List<SpecialCostVo> specialCostVoList2 = value.getSpecialCostList();
            if(CollectionUtils.isNotEmpty(specialCostVoList2)) {
                for (SpecialCostVo specialCostVo : specialCostVoList2) {
                    if (!specialCostVo.getIsTotal()) {
                        SpecialCostVo specialCostVoTotal = specialCostVoTotalMap.get(specialCostVo.getActivityTypeCode());
                        if (null == specialCostVoTotal){
                            specialCostVoTotal = new SpecialCostVo();
                            specialCostVoTotal.setIsTotal(false);
                            specialCostVoTotal.setActivityTypeCode(specialCostVo.getActivityTypeCode());
                            specialCostVoTotal.setActivityTypeName(specialCostVo.getActivityTypeName());
                            specialCostVoTotal.setSpecialCost(BigDecimal.ZERO);
                            specialCostVoTotalMap.put(specialCostVo.getActivityTypeCode(),specialCostVoTotal);
                        }
                        specialCostVoTotal.setSpecialCost(specialCostVoTotal.getSpecialCost().add(specialCostVo.getSpecialCost()));
                    } else {
                        specialCostVoVo1.setIsTotal(true);
                        specialCostVoVo1.setSpecialCost(Optional.ofNullable(specialCostVoVo1.getSpecialCost()).orElse(BigDecimal.ZERO).add(specialCostVo.getSpecialCost()));
                    }
                }
            }
        });
        List<SpecialCostVo> specialCostVos = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(specialCostVoTotalMap.values())){
//            specialCostVos.add(specialCostVoVo1);
            specialCostVoTotalMap.values().forEach(item->{
                specialCostVos.add(item);
            });
            specialCostVos.add(specialCostVoVo1);
        }
        total.setSpecialCostList(specialCostVos);

        activityPlanProfitList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(activityPlanProfitVoMap.values())){
            activityPlanProfitList.addAll(activityPlanProfitVoMap.values());
        }

        //固定支出,考核扣款
        ProfitGoalDiscountDto profitGoalDiscountDto = new ProfitGoalDiscountDto();
        profitGoalDiscountDto.setOrgCode(activityPlanTableVo.getOrgCode());
        profitGoalDiscountDto.setYearMonthLy(activityPlanTableVo.getYearAndMonth());
        List<FixedExpenseVo> fixedExpenseVoList = profitGoalDiscountService.findFixedExpense(profitGoalDiscountDto);
        //按渠道显示
        if (CollectionUtils.isNotEmpty(fixedExpenseVoList) && CollectionUtils.isNotEmpty(activityPlanProfitList)) {
            //有渠道的固定支出
            Map<String, String> budgetItemCodeToNameMap = fixedExpenseVoList.stream()
                    .filter(item -> BudgetAmountTypeEnum.FIXED_PAY.getCode().equals(item.getTypeCode()))
                    .filter(item -> StringUtils.isNotEmpty(item.getBudgetSortCode()) && StringUtils.isNotEmpty(item.getBudgetSortName()))
                    .collect(Collectors.toMap(FixedExpenseVo::getBudgetSortCode, FixedExpenseVo::getBudgetSortName,(o,n) -> n));
            Map<String, Map<String, List<FixedExpenseVo>>> fixedExpenseVoMap = fixedExpenseVoList.stream()
                    .filter(item -> BudgetAmountTypeEnum.FIXED_PAY.getCode().equals(item.getTypeCode()))
                    .filter(item -> Objects.nonNull(item.getFixedExpense()) && StringUtils.isNotEmpty(item.getBudgetSortCode()))
                    .collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getCustomerChannelCode()).orElse(" ")
                            , Collectors.groupingBy(FixedExpenseVo::getBudgetSortCode)));
            //有渠道的考核扣款
            Map<String, List<FixedExpenseVo>> assessDeductionVoMap = fixedExpenseVoList.stream()
                    .filter(item -> BudgetAmountTypeEnum.ASSESS_DEDUCTION.getCode().equals(item.getTypeCode()))
                    .filter(item -> Objects.nonNull(item.getFixedExpense()))
                    .collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getCustomerChannelCode()).orElse(" ")));
            //没有渠道的固定支出
            Map<String, List<FixedExpenseVo>> haveNoChannelExpenseVoMap = fixedExpenseVoMap.getOrDefault(" ", Maps.newHashMap());
            Map<String, BigDecimal> budgetItemToNoChannelExpenseMap = Maps.newHashMap();
            haveNoChannelExpenseVoMap.forEach((key, value) -> budgetItemToNoChannelExpenseMap.put(key, value.stream().map(FixedExpenseVo::getFixedExpense).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
            //考核扣款
            Map<String, BigDecimal> channelToAssessDeductionAmountMap = Maps.newHashMap();
            assessDeductionVoMap.forEach((key, value) -> channelToAssessDeductionAmountMap.put(key, value.stream().map(FixedExpenseVo::getFixedExpense).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));

            activityPlanProfitList.forEach(activityPlanProfit -> {
                String thisChannelCode = activityPlanProfit.getCustomerChannelCode();
                BigDecimal saleQuantityRatio = chanalCodeToSaleQuantityRatioMap.get(thisChannelCode);
                Map<String, BigDecimal> thisChannelbudgetItemToNoChannelExpenseMap = Maps.newHashMap();
                BigDecimal noChannelAssessDeductionShareAmount = BigDecimal.ZERO;
                if (Objects.nonNull(saleQuantityRatio) && !(BigDecimal.ZERO.compareTo(saleQuantityRatio) == 0)) {
                    if (!budgetItemToNoChannelExpenseMap.isEmpty()) {
                        budgetItemToNoChannelExpenseMap.forEach((key, value) -> thisChannelbudgetItemToNoChannelExpenseMap.put(key, saleQuantityRatio.multiply(value)));
                    }
                    noChannelAssessDeductionShareAmount = saleQuantityRatio.multiply(channelToAssessDeductionAmountMap.getOrDefault(" ", BigDecimal.ZERO));
                }
                Map<String, List<FixedExpenseVo>> thisChannelbudgetItemToHaveChannelExpenseMap = fixedExpenseVoMap.getOrDefault(thisChannelCode, Maps.newHashMap());
                List<FixedExpenseVo> fixedExpenseList = Lists.newArrayList();
                thisChannelbudgetItemToHaveChannelExpenseMap.forEach((key, value) -> {
                    FixedExpenseVo fixedExpenseVo1 = value.get(0);
                    FixedExpenseVo fixedExpenseVo = new FixedExpenseVo();
                    fixedExpenseVo.setBudgetSortCode(key);
                    fixedExpenseVo.setBudgetSortName(fixedExpenseVo1.getBudgetSortName());
                    BigDecimal fixedExpense = value.stream().map(FixedExpenseVo::getFixedExpense).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    fixedExpenseVo.setFixedExpense(fixedExpense.add(thisChannelbudgetItemToNoChannelExpenseMap.getOrDefault(key, BigDecimal.ZERO)));
                    fixedExpenseVo.setIsTotal(false);
                    fixedExpenseList.add(fixedExpenseVo);
                });
                thisChannelbudgetItemToNoChannelExpenseMap.forEach((key, value) -> {
                    if (!thisChannelbudgetItemToHaveChannelExpenseMap.containsKey(key)) {
                        FixedExpenseVo fixedExpenseVo = new FixedExpenseVo();
                        fixedExpenseVo.setBudgetSortCode(key);
                        fixedExpenseVo.setBudgetSortName(budgetItemCodeToNameMap.get(key));
                        fixedExpenseVo.setIsTotal(false);
                        fixedExpenseVo.setFixedExpense(value);
                        fixedExpenseList.add(fixedExpenseVo);
                    }
                });
                activityPlanProfit.setHeadquartersAssess(noChannelAssessDeductionShareAmount.add(channelToAssessDeductionAmountMap.getOrDefault(thisChannelCode, BigDecimal.ZERO)).negate());
                //小计
                if (CollectionUtils.isNotEmpty(fixedExpenseList)) {
                    FixedExpenseVo fixedExpenseVo = new FixedExpenseVo();
                    fixedExpenseVo.setFixedExpense(fixedExpenseList.stream().map(FixedExpenseVo::getFixedExpense).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    fixedExpenseVo.setIsTotal(true);
                    fixedExpenseList.add(fixedExpenseVo);
                }
                activityPlanProfit.setFixedExpenseList(fixedExpenseList);
            });
        }

        if(CollectionUtils.isNotEmpty(fixedExpenseVoList)){
            //map(类型，预算类别，）
            Map<String, List<FixedExpenseVo>> fixedExpenseVoMap = fixedExpenseVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getTypeCode()).orElse("")));
            fixedExpenseVoMap.forEach((key,value)->{
                //固定支出
                if(BudgetAmountTypeEnum.FIXED_PAY.getCode().equals(key)){

                    List<FixedExpenseVo> fixedExpenseVoList1 = new ArrayList<>();
                    Map<String, List<FixedExpenseVo>> collect = value.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getBudgetSortCode()).orElse("")));
                    collect.forEach((key2,value2)->{
                        FixedExpenseVo fixedExpenseVo1 = value2.get(0);
                        FixedExpenseVo fixedExpenseVo = new FixedExpenseVo();
                        fixedExpenseVo.setIsTotal(false);
                        fixedExpenseVo.setBudgetSortCode(key2);
                        fixedExpenseVo.setBudgetSortName(fixedExpenseVo1.getBudgetSortName());
                        fixedExpenseVo.setFixedExpense(value2.stream().map(FixedExpenseVo::getFixedExpense).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                        fixedExpenseVoList1.add(fixedExpenseVo);
                    });
                    //小计的合计
                    FixedExpenseVo fixedExpenseVoTotal = new FixedExpenseVo();
                    fixedExpenseVoTotal.setIsTotal(true);
                    fixedExpenseVoTotal.setFixedExpense(fixedExpenseVoList1.stream().map(FixedExpenseVo::getFixedExpense).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    fixedExpenseVoList1.add(fixedExpenseVoTotal);
                    total.setFixedExpenseList(fixedExpenseVoList1);
                }
                //总部考核 = 考核扣款累计
                if(BudgetAmountTypeEnum.ASSESS_DEDUCTION.getCode().equals(key)){
                    total.setHeadquartersAssess(value.stream().map(FixedExpenseVo::getFixedExpense).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).negate());
                }
            });
        }


        //根据年月查询自投预算预测
        SubComBudgetForecastDto subComBudgetForecastDto = new SubComBudgetForecastDto();
        subComBudgetForecastDto.setYearMonthLy(activityPlanTableVo.getYearAndMonth());
        subComBudgetForecastDto.setOrgCode(activityPlanTableVo.getOrgCode());
        subComBudgetForecastDto.setFeeSourceCode(com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum.INTERNAL_POINT_FEE.getCode());
        List<SubComBudgetForecastVo> internalForecastVos = this.subComBudgetForecastService.listByConditions(subComBudgetForecastDto);
        //        合计值为：  根据年月+组织+点内费用/点外费用 取分子预算预测中所有的已向上申请金额之和
        BigDecimal internalApplyAmountUp = internalForecastVos.stream().map(SubComBudgetForecastVo::getApplyAmountUp).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
//        BigDecimal internalUsedAmount = internalForecastVos.stream().map(SubComBudgetForecastVo::getUsedAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal activityPointInCost = activityPlanProfitList.stream().map(ActivityPlanProfitVo::getPointInCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal internalUsableAmount = internalApplyAmountUp.subtract(activityPointInCost);
        subComBudgetForecastDto.setFeeSourceCode(com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum.OFF_POINT_FEE.getCode());
        List<SubComBudgetForecastVo> offPointForecastVos = this.subComBudgetForecastService.listByConditions(subComBudgetForecastDto);
        BigDecimal offPointApplyAmountUp = offPointForecastVos.stream().map(SubComBudgetForecastVo::getApplyAmountUp).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
//        BigDecimal offPointUsedAmount = offPointForecastVos.stream().map(SubComBudgetForecastVo::getUsedAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal activityPointOutCost = activityPlanProfitList.stream().map(ActivityPlanProfitVo::getPointOutCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal offPointUsableAmount = offPointApplyAmountUp.subtract(activityPointOutCost);


        //点内费用、点外费用
        activityPlanProfitList.forEach(activityPlanProfit -> {
            String thisChannelCode = activityPlanProfit.getCustomerChannelCode();
            BigDecimal saleQuantityRatio = chanalCodeToSaleQuantityRatioMap.get(thisChannelCode);
            if (Objects.nonNull(saleQuantityRatio) && !(BigDecimal.ZERO.compareTo(saleQuantityRatio) == 0)) {
                activityPlanProfit.setPointInCost(saleQuantityRatio.multiply(internalUsableAmount).add(Optional.ofNullable(activityPlanProfit.getPointInCost()).orElse(BigDecimal.ZERO)));
                activityPlanProfit.setPointOutCost(saleQuantityRatio.multiply(offPointUsableAmount).add(Optional.ofNullable(activityPlanProfit.getPointOutCost()).orElse(BigDecimal.ZERO)));
            }
            if(activityPlanProfit.getPointInCost() != null && activityPlanProfit.getAfterDiscountIncome() != null && activityPlanProfit.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0){
                activityPlanProfit.setPointInCostRatio(activityPlanProfit.getPointInCost().divide(activityPlanProfit.getAfterDiscountIncome(), 6, BigDecimal.ROUND_HALF_UP));
            }
            if(activityPlanProfit.getPointOutCost() != null && activityPlanProfit.getAfterDiscountIncome() != null && activityPlanProfit.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0){
                activityPlanProfit.setPointOutCostRatio(activityPlanProfit.getPointOutCost().divide(activityPlanProfit.getAfterDiscountIncome(), 6, BigDecimal.ROUND_HALF_UP));
            }
        });
        BigDecimal pointInCost = activityPlanProfitList.stream().map(ActivityPlanProfitVo::getPointInCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal pointOutCost = activityPlanProfitList.stream().map(ActivityPlanProfitVo::getPointOutCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        // 合计
        total.setPointInCost(pointInCost);
        total.setPointOutCost(pointOutCost);
        if(total.getPointInCost() != null && total.getAfterDiscountIncome() != null && total.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0){
            total.setPointInCostRatio(total.getPointInCost().divide(total.getAfterDiscountIncome(), 6, RoundingMode.HALF_UP));
        }
        if(total.getPointOutCost() != null && total.getAfterDiscountIncome() != null && total.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0){
            total.setPointOutCostRatio(total.getPointOutCost().divide(total.getAfterDiscountIncome(), 6, RoundingMode.HALF_UP));
        }

        activityPlanProfitList.add(total);
        for (ActivityPlanProfitVo activityPlanProfitVo : activityPlanProfitList) {
            BigDecimal specialCostTotal = BigDecimal.ZERO;
            //专项费用
            List<SpecialCostVo> specialCostList = activityPlanProfitVo.getSpecialCostList();
            if(CollectionUtils.isNotEmpty(specialCostList)) {
                specialCostTotal = specialCostList.stream().filter(o->Objects.nonNull(o.getIsTotal())).filter(SpecialCostVo::getIsTotal).map(SpecialCostVo::getSpecialCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            //固定支出费用
            BigDecimal fixedExpenseTotal = BigDecimal.ZERO;
            List<FixedExpenseVo> fixedExpenseList = activityPlanProfitVo.getFixedExpenseList();
            if(CollectionUtils.isNotEmpty(fixedExpenseList)) {
                fixedExpenseTotal = fixedExpenseList.stream().filter(FixedExpenseVo::getIsTotal).map(FixedExpenseVo::getFixedExpense).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }

            //整体向下支出
            BigDecimal totalDownPay = specialCostTotal.add(fixedExpenseTotal);

            activityPlanProfitVo.setHeadquartersExpenseTotal(Optional.ofNullable(activityPlanProfitVo.getPointInCost()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(activityPlanProfitVo.getPointOutCost()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(activityPlanProfitVo.getHeadquartersAssess()).orElse(BigDecimal.ZERO)));
            if(activityPlanProfitVo.getIsTotal()) {
                //总部支出-小计
//                利润额：“理论毛利额”-“税金及附加”-“整体向下支出”+“总部支持”；
                activityPlanProfitVo.setProfitAmount(Optional.ofNullable(activityPlanProfitVo.getTheoryGrossMarginAmount()).orElse(BigDecimal.ZERO)
                        .subtract(Optional.ofNullable(activityPlanProfitVo.getTaxAndAddition()).orElse(BigDecimal.ZERO)).subtract(totalDownPay)
                        .add(Optional.ofNullable(activityPlanProfitVo.getHeadquartersExpenseTotal()).orElse(BigDecimal.ZERO)));
            }


            if(Objects.nonNull(activityPlanProfitVo.getBeforeDiscountIncome())&&activityPlanProfitVo.getBeforeDiscountIncome().compareTo(BigDecimal.ZERO)!=0) {
                //产品促销费用率 = 常规产品促销/折前收入
                activityPlanProfitVo.setProductPromotionCost(Optional.ofNullable(activityPlanProfitVo.getProductPromotionCostNumerator()).orElse(BigDecimal.ZERO).divide(activityPlanProfitVo.getBeforeDiscountIncome(),6, RoundingMode.HALF_UP));
                //其他费用率 = 除常规产品促销、大日期费用外专项费用/折前收入
                activityPlanProfitVo.setOtherCostRatio(Optional.ofNullable(activityPlanProfitVo.getPointInCostRateNumerator()).orElse(BigDecimal.ZERO).divide(activityPlanProfitVo.getBeforeDiscountIncome(),6, RoundingMode.HALF_UP));
                //专项费用率 = 专项费用/折前收入
                if(CollectionUtils.isNotEmpty(specialCostList)) {
                    activityPlanProfitVo.setSpecialCostRate(specialCostTotal.divide(activityPlanProfitVo.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
                }
                //固定支出费用率 = 固定支出费用/折前收入
                if(CollectionUtils.isNotEmpty(fixedExpenseList)) {
                    activityPlanProfitVo.setPointInExpendCostRate(fixedExpenseTotal.divide(activityPlanProfitVo.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
                }
                //整体费用率 = 整体向下支出/折前收入
                activityPlanProfitVo.setAllCostRate(totalDownPay.divide(activityPlanProfitVo.getBeforeDiscountIncome(),6, RoundingMode.HALF_UP));
            }
        }

        //固定支出费用率=固定支出/折前收入
        List<FixedExpenseVo> fixedExpenseList = total.getFixedExpenseList();
        BigDecimal fixedExpense = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(fixedExpenseList)){
            List<FixedExpenseVo> fixedExpenseVos = fixedExpenseList.stream().filter(o -> Objects.nonNull(o.getIsTotal())).filter(FixedExpenseVo::getIsTotal).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(fixedExpenseVos)){
                fixedExpense = fixedExpenseVos.get(0).getFixedExpense();
            }
        }
        if (Objects.nonNull(total.getBeforeDiscountIncome()) && total.getBeforeDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
            total.setPointInExpendCostRate(fixedExpense.divide(total.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
        }
        //整体费用率 = 整体向下支出(专项费用+固定支出)/折前收入
        BigDecimal specialCost = BigDecimal.ZERO;
        List<SpecialCostVo> specialCostList = total.getSpecialCostList();
        if(CollectionUtils.isNotEmpty(specialCostList)){
            List<SpecialCostVo> specialCostVos1 = specialCostList.stream().filter(o -> Objects.nonNull(o.getIsTotal())).filter(SpecialCostVo::getIsTotal).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(specialCostVos1)){
                specialCost = specialCostVos1.get(0).getSpecialCost();
            }
        }
        if(Objects.nonNull(total.getBeforeDiscountIncome())&&total.getBeforeDiscountIncome().compareTo(BigDecimal.ZERO)!=0) {
            total.setAllCostRate(fixedExpense.add(specialCost).divide(total.getBeforeDiscountIncome(),6,RoundingMode.HALF_UP));
        }
        return activityPlanProfitList;

    }

    @Override
    public ActivityPlanTableVo selectTableByYearMonthAndOrg(SelectActivityPlanTableEventDto dto) {
        if (ObjectUtils.isEmpty(dto)) {
            return null;
        }
        ActivityPlanTable activityPlanTable = activityPlanTableRepository.selectTableByYearMonthAndOrg(dto);
        if (ObjectUtils.isEmpty(activityPlanTable)) {
            return null;
        }
        ActivityPlanTableVo tableVo = nebulaToolkitService.copyObjectByWhiteList(activityPlanTable, ActivityPlanTableVo.class, HashSet.class, ArrayList.class);
        return tableVo;
    }

    /**
     * 更据年月+组织查询分子预算预测自投费用
     *
     * @param yearAndMonth
     * @param orgCode
     */
    @Override
    public BigDecimal getAutoAmount(String yearAndMonth, String orgCode) {
        Validate.notBlank(yearAndMonth,"年月不能为空！");
        Validate.notBlank(orgCode,"组织编码不能为空！");
        SubComBudgetForecastDto selectDto = new SubComBudgetForecastDto();
        selectDto.setYearMonthLy(yearAndMonth);
        selectDto.setOrgCode(orgCode);
        selectDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        selectDto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
        selectDto.setFeeSourceCode(FeeSourceEnum.AUTO_FEE.getCode());
        List<SubComBudgetForecastVo> subBudgetForecast = subComBudgetForecastService.findListByConditions(selectDto);
        if (!CollectionUtils.isEmpty(subBudgetForecast)){
            if (subBudgetForecast.size() > 1) {
                throw new RuntimeException("更据业态+业务单元+年月+组织维度查询到多个自投费用！");
            }
            return subBudgetForecast.get(0).getRemainderAmount();
        }
        return null;
    }

    @Override
    public Page<FinalFixedExpenseVo> findFinalFixedExpenseByConditionsForReport(Pageable pageable, FinalFixedExpenseDto dto2) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        return this.finalFixedExpenseRepository.findFinalFixedExpenseByConditionsForReport(pageable,dto2);
    }
}
