package com.biz.crm.tpm.business.activity.plan.table.local.workFlowListener;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTable;
import com.biz.crm.tpm.business.activity.plan.table.local.repository.ActivityPlanTableRepository;
import com.biz.crm.tpm.business.activity.plan.table.sdk.constants.ActivityPlanTableConstants;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;


/**
 * @author ：dengwei
 * @date ：Created in 2022/11/10 17:00
 * @description：活动规划套表审批回调
 */
@Component
@Slf4j
public class OrdinaryActivityPlanTableProcessCallBackListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private SubComActivityDesignService subComActivityDesignService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityPlanTableRepository activityPlanTableRepository;

    @Override
    public String getBusinessCode() {
        return ActivityPlanTableConstants.ORDINARY_ACTIVITY_PLAN_TABLE_PROCESS;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onProcessComplete(ProcessStatusDto dto) {

        String processStatus = dto.getProcessStatus();

        ActivityPlanTable one = this.activityPlanTableRepository.lambdaQuery()
                .eq(ActivityPlanTable::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanTable::getId,dto.getBusinessNo())
                .one();
        //校验回调实例
        Validate.notNull(one, "核销申请审批流程回调失败，未查询到当前实例");
        ActivityPlanTable two = new ActivityPlanTable();
        two.setId(one.getId());
        //审批通过
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.PASS.getDictCode())) {
            try {
                subComActivityDesignService.passBatch(dto.getProcessNo(), one.getId());
                two.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
                this.activityPlanTableRepository.updateById(two);
            }catch (Exception e){
                log.error("活动规划套表审批出错",e);
                throw e;
            }
        }

        //审批驳回
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.REJECT.getDictCode())) {
            two.setProcessStatus(ProcessStatusEnum.REJECT.getDictCode());
            this.activityPlanTableRepository.updateById(two);


            //流程编码传给活动规划
            SubComActivityDesignDto subComActivityDesignDto = new SubComActivityDesignDto();
            subComActivityDesignDto.setOrgCode(one.getOrgCode());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
            Date yearAndMonth = null;
            try {
                yearAndMonth = df.parse(one.getYearAndMonth());
            } catch (ParseException e) {
                log.error(e.getMessage(),e);
                e.printStackTrace();
            }
            subComActivityDesignDto.setFeeYearMonth(yearAndMonth);
            subComActivityDesignDto.setProcessStatus(processStatus);
            subComActivityDesignDto.setProcessNo(dto.getProcessNo());
            subComActivityDesignService.rejectBatch(subComActivityDesignDto);
        }
        //流程追回
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.RECOVER.getDictCode())) {
            two.setProcessStatus(ProcessStatusEnum.RECOVER.getDictCode());
            this.activityPlanTableRepository.updateById(two);

            //流程编码传给活动规划
            SubComActivityDesignDto subComActivityDesignDto = new SubComActivityDesignDto();
            subComActivityDesignDto.setOrgCode(one.getOrgCode());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
            Date yearAndMonth = null;
            try {
                yearAndMonth = df.parse(one.getYearAndMonth());
            } catch (ParseException e) {
                log.error(e.getMessage(),e);
                e.printStackTrace();
            }
            subComActivityDesignDto.setFeeYearMonth(yearAndMonth);
            subComActivityDesignDto.setProcessStatus(processStatus);
            subComActivityDesignDto.setProcessNo(dto.getProcessNo());
            subComActivityDesignService.rejectBatch(subComActivityDesignDto);
        }
    }
}
