/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.table.local.controller;

import com.alibaba.excel.util.MapUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.ActivityPlanTableBatchSubmitApprovalDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.ActivityPlanTableDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.service.ActivityPlanTableService;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.ActivityPlanTableVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.CostCollectVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.FinalFixedExpenseVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.PriceVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.PutOutputRatioCustomerVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.PutOutputRatioVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.ReferendumCostVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.SaleForecastVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/activityPlanTable"})
@Api(tags={"\u6d3b\u52a8\u8ba1\u5212\u5957\u8868"})
public class ActivityPlanTableController {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanTableController.class);
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private ActivityPlanTableService activityPlanTableService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ActivityPlanTableVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, ActivityPlanTableDto dto) {
        try {
            Page page = this.activityPlanTableService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u660e\u7ec6")
    @GetMapping(value={"getById/{id}"})
    public Result<ActivityPlanTableVo> getById(@PathVariable(value="id") String id) {
        try {
            return Result.ok((Object)this.activityPlanTableService.getById(id, null));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={"save"})
    public Result<?> save(@RequestBody ActivityPlanTableDto dto) {
        try {
            this.activityPlanTableService.save(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u63d0\u4ea4\u5ba1\u6279\u6d41")
    @PostMapping(value={"batchSubmitApproval"})
    public Result<?> batchSubmitApproval(@RequestBody ActivityPlanTableBatchSubmitApprovalDto dto) {
        try {
            Assert.notNull((Object)dto, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
            Assert.notEmpty((Collection)dto.getIds(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a!");
            List processNoList = this.activityPlanTableService.batchSubmitApproval(dto);
            this.activityPlanTableService.saveSubmitBatchByMq(processNoList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6570\u636e\u751f\u6210")
    @PostMapping(value={"generateData"})
    public Result generateData(@ApiParam(name="ids", value="TPM-\u5957\u8868id") @RequestBody List<String> ids) {
        try {
            if (CollectionUtils.isEmpty(ids)) {
                throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\uff01");
            }
            ids.forEach(id -> {
                if (this.redisLockService.isLock("sub_com_activity_design:lock:approve:" + id)) {
                    throw new RuntimeException("\u5f53\u524d\u6570\u636e\u6b63\u5728\u751f\u6210\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
                }
                this.activityPlanTableService.generateData(id);
            });
            return Result.ok((String)"\u6570\u636e\u751f\u6210\u4e2d\uff0c\u8bf7\u7a0d\u540e");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"download"})
    public void download(@RequestParam(value="id") String id, HttpServletResponse response) throws IOException {
        try {
            ActivityPlanTableVo activityPlanTableVo = this.activityPlanTableService.download(id, response);
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6d3b\u52a8\u89c4\u5212\u5957\u8868\u51fa\u9519", (Throwable)e);
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap map = MapUtils.newHashMap();
            map.put("status", "failure");
            map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            response.getWriter().println(JSON.toJSONString((Object)map));
        }
    }

    @ApiOperation(value="\u6295\u5165\u4ea7\u51fa\u6bd4\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"findPutOutputRatioByConditions"})
    public Result<Page<PutOutputRatioVo>> findPutOutputRatioByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u6d3b\u52a8\u5f62\u5f0f\u5957\u8868") ActivityPlanTableDto dto) {
        try {
            Page page = this.activityPlanTableService.findPutOutputRatioByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6295\u5165\u4ea7\u51fa\u6bd4\u5ba2\u6237\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"findPutOutputRatioCustomerByConditions"})
    public Result<Page<PutOutputRatioCustomerVo>> findPutOutputRatioCustomerByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u6d3b\u52a8\u5f62\u5f0f\u5957\u8868") ActivityPlanTableDto dto) {
        try {
            Page page = this.activityPlanTableService.findPutOutputRatioCustomerByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9500\u552e\u9884\u6d4b\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"findSaleForecastByConditions"})
    public Result<Page<SaleForecastVo>> findSaleForecastByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u6d3b\u52a8\u5f62\u5f0f\u5957\u8868") ActivityPlanTableDto dto) {
        try {
            Page page = this.activityPlanTableService.findSaleForecastByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8d39\u7528\u6c47\u603b\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"findCostCollectByConditions"})
    public Result<Page<CostCollectVo>> findCostCollectByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u6d3b\u52a8\u5f62\u5f0f\u5957\u8868") ActivityPlanTableDto dto) {
        try {
            Page page = this.activityPlanTableService.findCostCollectByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u516c\u6295\u8d39\u7528\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"findReferendumCostByConditions"})
    public Result<Page<ReferendumCostVo>> findReferendumCostByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u6d3b\u52a8\u5f62\u5f0f\u5957\u8868") ActivityPlanTableDto dto) {
        try {
            Page page = this.activityPlanTableService.findReferendumCostByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u56fa\u5b9a\u652f\u51fa\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"findFinalFixedExpenseByConditions"})
    public Result<Page<FinalFixedExpenseVo>> findFinalFixedExpenseByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u6d3b\u52a8\u5f62\u5f0f\u5957\u8868") ActivityPlanTableDto dto) {
        try {
            Page page = this.activityPlanTableService.findFinalFixedExpenseByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4ef7\u683c\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"findPriceByConditions"})
    public Result<Page<PriceVo>> findPriceByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u6d3b\u52a8\u5f62\u5f0f\u5957\u8868") ActivityPlanTableDto dto) {
        try {
            Page page = this.activityPlanTableService.findPriceByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279\u6570\u636e\u66f4\u65b0")
    @GetMapping(value={"saveSubmitTimeData"})
    public Result saveSubmitTimeData(@ApiParam(name="dto", value="\u6d3b\u52a8\u5f62\u5f0f\u5957\u8868") ActivityPlanTableDto dto) {
        try {
            Assert.notNull((Object)dto, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
            Assert.hasLength((String)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a!");
            this.activityPlanTableService.saveSubmitTimeData(dto.getId());
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279\u6570\u636e\u66f4\u65b0")
    @GetMapping(value={"saveSubmitTimeDataAsync"})
    public Result saveSubmitTimeDataAsync(@ApiParam(name="dto", value="\u6d3b\u52a8\u5f62\u5f0f\u5957\u8868") ActivityPlanTableDto dto) {
        try {
            Assert.notNull((Object)dto, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
            Assert.hasLength((String)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a!");
            this.activityPlanTableService.saveSubmitBatchByMq(Collections.singletonList(dto.getProcessNo()));
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u81ea\u6295\u9884\u7b97\u9884\u6d4b\u5269\u4f59\u53ef\u7528\u4f59\u989d")
    @GetMapping(value={"getAutoAmount"})
    public Result<BigDecimal> getAutoAmount(@ApiParam(name="yearAndMonth", value="\u5e74\u6708") @RequestParam(value="yearAndMonth") String yearAndMonth, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801") @RequestParam(value="orgCode") String orgCode) {
        try {
            BigDecimal autoAmount = this.activityPlanTableService.getAutoAmount(yearAndMonth, orgCode);
            return Result.ok((Object)autoAmount);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

